/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.signaltek;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public enum SignaltekFileTitle {
    ABONENTS("abonents_v4", "/abonents"),
    PAYMENTS("payments_v3", "/payments"),
    PAYMENT_TYPES("pay_types", "/general"),
    DOCUMENT_TYPES("doc_types_short", "/general"),
    LOGINS("", "/general"),
    IP_NUMBERING("ip_numbering_plan_long", "/general"),
    PHONE_NUMBERING_PLAN("phone_numbering_plan", "/general"),
    SWITCHES("switches_long", "/general"),
    GATEWAYS("gates_short", "/general"),
    BUNCHES("bunches_long", "/general"),
    REGIONS("telcos_short", "/general"),
    SERVICES("services", "/abonents"),
    SUPPLEMENT_SERVICES("supplement_services", "/general");

    private final String title;
    private final String ftpDirectory;

    private SignaltekFileTitle(String title, String ftpDirectory) {
        this.title = title;
        this.ftpDirectory = ftpDirectory;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFTPDirectory() {
        return this.ftpDirectory;
    }

    public static String getFTPDirectory(String fileTitle) {
        String fileName = SignaltekFileTitle.extractName(fileTitle);
        return Stream.of(SignaltekFileTitle.values()).filter(a -> a.getTitle().equals(fileName) || fileName.equals(a.getTitle() + ".txt")).findFirst().map(SignaltekFileTitle::getFTPDirectory).orElse("/");
    }

    public static String extractName(String fileTitle) {
        Matcher matcher = Pattern.compile("^(.*?)(?:_\\d{4}_\\d{2}_\\d{2}_\\d{2}_\\d{2})?$").matcher(fileTitle);
        return matcher.matches() ? matcher.group(1) : fileTitle;
    }
}

