/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.table;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class TableTvSearch
extends BGTableInfoBase {
    public TableTvSearch() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnId(), BGUTableColumn.buildColumnTextLeft((String)"\u0414\u043e\u0433\u043e\u0432\u043e\u0440", (String)"contractTitle"), BGUTableColumn.buildColumnTextLeft((String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", (String)"contractComment").setMaxWidth(-1), BGUTableColumn.buildColumnTextLeft((String)"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", (String)"title").setMaxWidth(-1), BGUTableColumn.buildColumnPeriod()};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        if (tableParams == null || tableParams.getParams() == null) {
            return Collections.emptyList();
        }
        ArrayList<TvAccount> accounts = new ArrayList<TvAccount>();
        KeyValue idKeyValue = tableParams.getParams().stream().filter(a -> a.getKey().equals("id")).findFirst().orElse(null);
        if (idKeyValue != null) {
            int idValue = Utils.parseInt((String)idKeyValue.getValue(), (int)-1);
            if (idValue == -1) {
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0451\u043d ID!");
            }
            TvAccount tvAccount = ((TvAccountService)this.getContext().newService(TvAccountService.class, moduleId)).tvAccountGet(-1, idValue);
            if (tvAccount != null) {
                accounts.add(tvAccount);
                Contract contract = ContractDao.getContract((Connection)this.getContext().getConnection(), (int)tvAccount.getContractId());
                if (contract != null) {
                    tvAccount.setContractTitle(contract.getTitle());
                    tvAccount.setContractComment(contract.getComment());
                }
            }
        } else {
            int selectedTypeId = Utils.parseInt((String)tableParams.optParamValue("typeId").orElse("0"), (int)0);
            String filterKey = tableParams.optParamValue("filter_key").orElse("");
            String filterValue = tableParams.optParamValue("filter_value").orElse("");
            accounts.addAll(((TvAccountService)this.getContext().newService(TvAccountService.class, moduleId)).tvAccountSearch(Arrays.asList(new KeyValue(filterKey, filterValue)), selectedTypeId, false));
        }
        return accounts.stream().map(a -> new BGUTableRowData().addValue(this.getId(a.getId())).addValue("title", a.getTitle()).addValue("contractId", String.valueOf(a.getContractId())).addValue("contractTitle", a.getContractTitle()).addValue("contractComment", a.getContractComment()).addValue(this.getPeriod(new Period(a.getDateFrom(), a.getDateTo())))).toList();
    }
}

