/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.server.bean.api;

import bitel.billing.server.contract.bean.ContractUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.drweb.common.bean.AgentAVD;
import ru.bitel.bgbilling.modules.drweb.server.bean.AgentAVDManager;
import ru.bitel.bgbilling.modules.drweb.server.bean.api.AVDescAPI;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.io.Base64;

public class AVDesc6
extends BGLogger
implements AVDescAPI {
    private static final String ADD_CUSTOMER = "add-customer.ds";
    private static final String INFO_CUSTOMER = "get-customer-info.ds";
    private static final String UPDATE_CUSTOMER = "change-customer-info.ds";
    private Connection con;
    int moduleId;
    AgentAVDManager agentManager = null;
    private int graceperiodCount = 1;
    private boolean graceperiod = true;
    private String urlString = null;
    private String userName = null;
    private String userPswd = null;
    private String encoding = null;
    private int httpTimeout = 30000;

    public AVDesc6(Connection con, ParameterMap moduleSetup, int moduleId, AgentAVDManager agentManager) {
        this.con = con;
        this.moduleId = moduleId;
        this.agentManager = agentManager;
        this.urlString = moduleSetup.get("drweb.api.url", null);
        this.userName = moduleSetup.get("drweb.api.user", null);
        this.userPswd = moduleSetup.get("drweb.api.pswd", null);
        this.encoding = moduleSetup.get("drweb.api.encoding", null);
        this.graceperiodCount = moduleSetup.getInt("graceperiod.count", 1);
        this.graceperiod = !moduleSetup.get("graceperiod", "yes").toLowerCase().equals("no");
        this.httpTimeout = moduleSetup.getInt("drweb.api.timeout", 30000);
    }

    @Override
    public AgentAVD getAgentFromAVD(int contractId, String groupTitle, Date expires) throws BGException {
        AgentAVD agent;
        block12: {
            agent = null;
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("description", this.getDescription(contractId));
                if (groupTitle != null) {
                    params.put("group", groupTitle);
                }
                if (!this.graceperiod) {
                    params.put("graceperiod", "no");
                }
                GregorianCalendar date = new GregorianCalendar();
                date.setTime(new Date());
                ((Calendar)date).add(2, this.graceperiodCount);
                date.set(5, ((Calendar)date).getActualMaximum(5));
                date.set(11, 23);
                date.set(12, 59);
                date.set(13, 59);
                try (InputStream answer = this.transferData(ADD_CUSTOMER, params);){
                    if (answer == null) {
                        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0433\u0435\u043d\u0442\u0430");
                    }
                    Document doc = XMLUtils.parseDocument((InputSource)new InputSource(answer));
                    int errorCode = this.checkError(doc);
                    if (errorCode == 0) {
                        agent = new AgentAVD();
                        agent.setAgentUUID(XMLUtils.selectText((Node)doc, (String)"//customers/customer/id/text()"));
                        agent.setName(XMLUtils.selectText((Node)doc, (String)"//customers/customer/description/text()"));
                        agent.setExpires(date.getTime());
                        break block12;
                    }
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0433\u0435\u043d\u0442\u0430");
                }
            }
            catch (Exception ex) {
                this.logError(ex);
                throw new BGException(ex.getMessage());
            }
        }
        return agent;
    }

    private String getDescription(int contractId) throws BGException, SQLException {
        ContractUtils cu = new ContractUtils(this.con);
        return cu.getContractTitle(contractId, false) + "_" + this.agentManager.getAgentCount(contractId);
    }

    private int checkError(Document doc) throws Exception {
        String codeElementTextContent = XMLUtils.selectText((Node)doc, (String)"//error/code/text()");
        if (Utils.isEmptyString((String)codeElementTextContent)) {
            return 0;
        }
        return Integer.parseInt(codeElementTextContent);
    }

    @Override
    public void sinchronizeAgent(int contractId) {
        try {
            List<AgentAVD> list = null;
            list = contractId == -1 ? this.agentManager.getListAll() : this.agentManager.getListById(contractId);
            for (AgentAVD agent : list) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", agent.getAgentUUID());
                InputStream xml = this.transferData(INFO_CUSTOMER, params);
                try {
                    if (xml == null) {
                        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c");
                    }
                    Document doc = XMLUtils.parseDocument((InputSource)new InputSource(xml));
                    int errorCode = this.checkError(doc);
                    if (errorCode == 0) {
                        agent.setName(XMLUtils.selectText((Node)doc, (String)"//customers/customer/description/text()"));
                        this.agentManager.updateNotLog(agent);
                        continue;
                    }
                    if (errorCode != 17 && errorCode != 6) continue;
                    this.getLogger().info("delete agent [" + agent.getId() + "](" + agent.getAgentUUID() + ")");
                    this.agentManager.delete(agent.getId());
                }
                finally {
                    if (xml == null) continue;
                    xml.close();
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private InputStream transferData(String command, Map<String, String> params) throws Exception {
        String userAndPswd = this.userName + ":" + this.userPswd;
        URL url = null;
        StringBuilder paramStr = new StringBuilder();
        for (String key : params.keySet()) {
            paramStr.append(this.urlEncode(key)).append("=").append(this.urlEncode(params.get(key))).append("&");
        }
        url = URI.create(this.urlString + command + (String)(paramStr.length() == 0 ? "" : "?" + paramStr.toString())).toURL();
        this.getLogger().debug("url = " + String.valueOf(url));
        try (HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(this.httpTimeout)).build();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.urlString + command + (String)(paramStr.length() == 0 ? "" : "?" + paramStr.toString()))).header("Content-type", "application/x-www-form-urlencoded").header("Authorization", "Basic " + Base64.encodeUTF8((String)userAndPswd)).GET().build();
            HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
            int code = response.statusCode();
            if (code == 200) {
                this.getLogger().debug("code={}", (Object)code);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(response.body());
                return byteArrayInputStream;
            }
            this.getLogger().error("code={}", (Object)code);
            InputStream inputStream = null;
            return inputStream;
        }
    }

    private String urlEncode(String inStr) {
        String outStr = "";
        if (inStr != null) {
            try {
                outStr = URLEncoder.encode(inStr, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return outStr;
    }

    @Override
    public void prolongAgentOnAVD(AgentAVD agent, Date date) throws BGException {
        block12: {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", agent.getAgentUUID());
                SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMddHHmmss");
                if (date == null) {
                    params.put("expires", "00000000");
                } else {
                    params.put("expires", yyyyMMdd.format(date));
                }
                try (InputStream answer = this.transferData(UPDATE_CUSTOMER, params);){
                    if (answer == null) {
                        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0430\u0433\u0435\u043d\u0442\u0430(\u043d\u0435\u0442 \u043e\u0442\u0432\u0435\u0442\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430)");
                    }
                    Document doc = XMLUtils.parseDocument((InputSource)new InputSource(answer));
                    int errorCode = this.checkError(doc);
                    if (errorCode == 0) {
                        agent = new AgentAVD();
                        agent.setAgentUUID(XMLUtils.selectText((Node)doc, (String)"//customers/customer/id/text()"));
                        agent.setName(XMLUtils.selectText((Node)doc, (String)"//customers/customer/description/text()"));
                        break block12;
                    }
                    this.getLogger().error("errorCode = " + errorCode);
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0430\u0433\u0435\u043d\u0442\u0430");
                }
            }
            catch (Exception ex) {
                this.logError(ex);
                throw new BGException(ex.getMessage());
            }
        }
    }

    @Override
    public void blockOnAVD(AgentAVD agent, Date dateFrom, Date dateTo) throws BGException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", agent.getAgentUUID());
            SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
            params.put("blockbeg", yyyyMMdd.format(dateFrom) + "000000");
            params.put("blockend", yyyyMMdd.format(dateTo) + "235959");
            try (InputStream answer = this.transferData(UPDATE_CUSTOMER, params);){
                if (answer == null) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u0430\u0433\u0435\u043d\u0442\u0430");
                }
                Document doc = XMLUtils.parseDocument((InputSource)new InputSource(answer));
                int errorCode = this.checkError(doc);
                if (errorCode != 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u0430\u0433\u0435\u043d\u0442\u0430");
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException(ex.getMessage());
        }
    }

    @Override
    public void changeTariffOnAVD(AgentAVD agent, String groupTitle) throws BGException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", agent.getAgentUUID());
            if (groupTitle != null) {
                params.put("group", groupTitle);
            }
            try (InputStream answer = this.transferData(UPDATE_CUSTOMER, params);){
                if (answer == null) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u0430");
                }
                Document doc = XMLUtils.parseDocument((InputSource)new InputSource(answer));
                int errorCode = this.checkError(doc);
                if (errorCode != 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u0430");
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException(ex.getMessage());
        }
    }
}

