/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.tariff;

import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.modules.drwebn.server.tariff.DrWebNTariffContext;
import ru.bitel.bgbilling.modules.drwebn.server.tariff.DrWebNTariffRequest;
import ru.bitel.common.ParameterMap;

public class MonthModeCostTariffTreeNode
extends DefaultTariffTreeNode<DrWebNTariffRequest, DrWebNTariffContext> {
    private final BigDecimal cost;
    private final int type;

    public MonthModeCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.cost = parameterMap.getBigDecimal("cost", BigDecimal.ZERO);
        this.type = parameterMap.getInt("type", 0);
    }

    protected int executeImpl(Long treeNodeId, DrWebNTariffRequest req, DrWebNTariffContext ctx) {
        req.addInfo("month mode");
        int monthDays = req.getAccountingMonthDays();
        int periodDays = ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getAccountingPeriodDays();
        BigDecimal cost = switch (this.type) {
            case 0 -> {
                if (periodDays > 0 && ctx.getAgentCost(req.getAgentId()) == null) {
                    yield this.cost;
                }
                req.addInfo("agent id=>" + req.getAgentId() + " alredy calc...");
                yield BigDecimal.ZERO;
            }
            case 1 -> this.cost.multiply(BigDecimal.valueOf(periodDays), ctx.mc).divide(BigDecimal.valueOf(monthDays), ctx.mc);
            default -> BigDecimal.ZERO;
        };
        ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).setCost(cost);
        req.setAccepted(true);
        req.addInfo("set cost " + String.valueOf(cost) + " for agent id=>" + req.getAgentId());
        ctx.setAgentCost(req.getAgentId(), cost);
        return 1;
    }
}

