/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionHistory;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionStatus;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscriptionSuspendReason;
import ru.bitel.bgbilling.modules.softline.server.bean.SubscriptionHistoryDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class SoftLineSubscriptionDao
extends AbstractIdDao<SoftLineSubscription> {
    public SoftLineSubscriptionDao(Connection con, int moduleId) {
        this(con, "softline_subscriptions", moduleId);
    }

    public SoftLineSubscriptionDao(Connection con, String tableName, int moduleId) {
        super(con, tableName, moduleId);
    }

    protected SoftLineSubscription getFromRS(ResultSet rs) throws SQLException {
        SoftLineSubscription subscription = new SoftLineSubscription();
        subscription.setId(rs.getInt("id"));
        subscription.setProductId(rs.getInt("productId"));
        subscription.setContractId(rs.getInt("contractId"));
        int status = rs.getInt("status");
        if (status == SoftLineSubscriptionStatus.SUSPEND.getCode()) {
            subscription.setSuspendReason(SoftLineSubscriptionSuspendReason.getReason((int)rs.getInt("suspendReason")));
        }
        subscription.setStatus(status);
        subscription.setStartDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("startDate")));
        subscription.setLastModifyDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("lastModifyDate")));
        subscription.setEndDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("endDate")));
        subscription.setSuspendReason(SoftLineSubscriptionSuspendReason.getReason((int)rs.getInt("suspendReason")));
        String downloadData = rs.getString("downloadData");
        if (Utils.notBlankString((String)downloadData)) {
            subscription.setDownloadData(downloadData);
        }
        return subscription;
    }

    protected void updateImpl(SoftLineSubscription subscription) throws SQLException {
        int status = subscription.getStatus();
        boolean statusSuspend = status == SoftLineSubscriptionStatus.SUSPEND.getCode();
        SoftLineSubscription oldSub = (SoftLineSubscription)this.get(subscription.getId());
        if (oldSub != null && oldSub.getStatus() != subscription.getStatus()) {
            try (SubscriptionHistoryDao historyDao = new SubscriptionHistoryDao(this.con, this.moduleId);){
                SoftLineSubscriptionHistory historyEntry = new SoftLineSubscriptionHistory();
                historyEntry.setDate(new Date());
                historyEntry.setProductId(subscription.getProductId());
                historyEntry.setContractId(subscription.getContractId());
                if (statusSuspend) {
                    historyEntry.setSuspendReason(subscription.getSuspendReason());
                }
                historyEntry.setStatus(status);
                historyEntry.setSubscriptionId(subscription.getId());
                historyDao.update(historyEntry);
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }
        String querySet = "productId=?, contractId=?, status=?, suspendReason=?, startDate=?, lastModifyDate=NOW(), endDate=?, downloadData=?";
        try (PreparedStatement ps = this.prepareStatement((Id)subscription, querySet);){
            int index = 1;
            ps.setInt(index++, subscription.getProductId());
            ps.setInt(index++, subscription.getContractId());
            ps.setInt(index++, status);
            ps.setInt(index++, statusSuspend ? subscription.getSuspendReason().ordinal() : 4);
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)subscription.getStartDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)subscription.getEndDate()));
            ps.setString(index++, subscription.getDownloadData());
            this.executeUpdate((Id)oldSub, index, ps);
        }
    }

    public void searchSubscriptions(SearchResult<SoftLineSubscription> searchResult, int contractId, int subscriptionId, SoftLineSubscriptionStatus status, int productId) throws BGException {
        if (searchResult != null) {
            StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE true");
            Page page = searchResult.getPage();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            if (subscriptionId > 0) {
                query.append(" AND id=?");
            }
            if (contractId > 0) {
                query.append(" AND contractId=?");
            }
            if (productId > 0) {
                query.append(" AND productId=?");
            }
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND createDate>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND createDate<=?");
                }
            }
            if (status != null) {
                query.append(" AND status=?");
            }
            query.append(this.sqlLimit(page));
            try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                int index = 1;
                if (subscriptionId > 0) {
                    ps.setInt(index++, subscriptionId);
                }
                if (contractId > 0) {
                    ps.setInt(index++, contractId);
                }
                if (productId > 0) {
                    ps.setInt(index++, productId);
                }
                if (period != null) {
                    Date dateTo;
                    Date dateFrom = period.getDateFrom();
                    if (dateFrom != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)dateFrom));
                    }
                    if ((dateTo = period.getDateTo()) != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)dateTo));
                    }
                }
                if (status != null) {
                    ps.setInt(index++, status.getCode());
                }
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                if (page != null) {
                    page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
                }
                rs.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }
}

