/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime.geocode;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneCostMapItem;

public class ZoneCostMapCache {
    private static final ConcurrentHashMap<Integer, ZoneCostMapCache> cache = new ConcurrentHashMap();
    private final int moduleId;
    private Map<Integer, Map<Integer, VoiceZoneCostMapItem>> zoneCostMaps = new HashMap<Integer, Map<Integer, VoiceZoneCostMapItem>>();

    public static synchronized ZoneCostMapCache getInstance(Connection con, int moduleId) throws BGException {
        ZoneCostMapCache zoneCostMapCache = cache.get(moduleId);
        if (zoneCostMapCache == null) {
            zoneCostMapCache = new ZoneCostMapCache(moduleId);
            zoneCostMapCache.load(con);
            cache.put(moduleId, zoneCostMapCache);
        }
        return zoneCostMapCache;
    }

    private ZoneCostMapCache(int moduleId) {
        this.moduleId = moduleId;
    }

    public void reset(int moduleId) {
        this.zoneCostMaps.remove(moduleId);
    }

    public void load(Connection con) throws BGException {
        String querySelect = " SELECT * FROM voice_zone_cost_map_item_" + this.moduleId;
        try (PreparedStatement psSelect = con.prepareStatement(querySelect);
             ResultSet rs = psSelect.executeQuery();){
            while (rs.next()) {
                int zoneCostMapId = rs.getInt("zone_cost_map_id");
                Map<Integer, VoiceZoneCostMapItem> items = this.zoneCostMaps.get(zoneCostMapId);
                if (items == null) {
                    items = new HashMap<Integer, VoiceZoneCostMapItem>();
                    this.zoneCostMaps.putIfAbsent(zoneCostMapId, items);
                }
                int zoneId = rs.getInt("zone_id");
                VoiceZoneCostMapItem item = new VoiceZoneCostMapItem();
                item.setVoiceZoneId(zoneId);
                item.setCost(rs.getBigDecimal("cost"));
                item.setCostSecond(rs.getInt("cost_second"));
                items.put(zoneId, item);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public VoiceZoneCostMapItem findZoneCost(int zoneCostMapId, int zoneId) {
        Map<Integer, VoiceZoneCostMapItem> items = this.zoneCostMaps.get(zoneCostMapId);
        return items == null ? null : items.get(zoneId);
    }
}

