/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.util.Date;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseCommonObject;
import ru.bitel.bgbilling.modules.license.common.bean.SpecificationTitle;
import ru.bitel.bgbilling.modules.license.common.bean.enums.LicenseComponentCategory;

public class LicenseComponent
extends LicenseCommonObject {
    public static final int TYPE_AVAILABLE = 0;
    public static final int TYPE_DEPRECATED = 1;
    private String title;
    private String name;
    private String comment;
    private LicenseComponentCategory category = LicenseComponentCategory.OTHER;
    private int type;
    private int unlimited;
    private int tariffGroupId = 0;
    private boolean availableOnWeb = true;

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @XmlAttribute
    public String getTitle() {
        return this.title;
    }

    @XmlAttribute
    public LicenseComponentCategory getCategory() {
        return this.category;
    }

    @XmlAttribute
    public int getType() {
        return this.type;
    }

    @XmlAttribute
    public String getComment() {
        return this.comment;
    }

    @XmlAttribute
    public int getTariffGroupId() {
        return this.tariffGroupId;
    }

    @XmlAttribute
    public int getUnlimited() {
        return this.unlimited;
    }

    @XmlAttribute
    public boolean isAvailableOnWeb() {
        return this.availableOnWeb;
    }

    public LicenseComponent setName(String name) {
        this.name = name;
        return this;
    }

    public LicenseComponent setTitle(String title) {
        this.title = title;
        return this;
    }

    public LicenseComponent setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public LicenseComponent setCategory(LicenseComponentCategory category) {
        this.category = category;
        return this;
    }

    public LicenseComponent setType(int type) {
        this.type = type;
        return this;
    }

    public LicenseComponent setUnlimited(int unlimited) {
        this.unlimited = unlimited;
        return this;
    }

    public LicenseComponent setAvailableOnWeb(boolean availableOnWeb) {
        this.availableOnWeb = availableOnWeb;
        return this;
    }

    public LicenseComponent setTariffGroupId(int tariffGroupId) {
        this.tariffGroupId = tariffGroupId;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LicenseComponent) {
            return ((LicenseComponent)((Object)obj)).getId() == this.id;
        }
        if (obj instanceof SpecificationTitle) {
            return ((SpecificationTitle)obj).getName().equals(this.name);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private LicenseComponent component = new LicenseComponent();

        private Builder() {
        }

        public Builder setId(int id) {
            this.component.id = id;
            return this;
        }

        public Builder setTitle(String title) {
            this.component.title = title;
            return this;
        }

        public Builder setName(String name) {
            this.component.name = name;
            return this;
        }

        public Builder setComment(String comment) {
            this.component.comment = comment;
            return this;
        }

        public Builder setType(int type) {
            this.component.type = type;
            return this;
        }

        public Builder setUnlimited(int unlimited) {
            this.component.unlimited = unlimited;
            return this;
        }

        public Builder setAvailableOnWeb(boolean availableOnWeb) {
            this.component.availableOnWeb = availableOnWeb;
            return this;
        }

        public Builder setLastUpdate(Date date) {
            this.component.lastUpdate = date;
            return this;
        }

        public Builder setCategory(LicenseComponentCategory category) {
            this.component.category = category;
            return this;
        }

        public Builder setTariffGroupId(int tariffGroupId) {
            this.component.tariffGroupId = tariffGroupId;
            return this;
        }

        public LicenseComponent build() {
            LicenseComponent a = this.component;
            this.component = null;
            return a;
        }
    }
}

