/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paymaster.server.worker;

import java.math.BigDecimal;
import java.sql.Connection;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.paymaster.common.bean.Transaction;
import ru.bitel.bgbilling.modules.paymaster.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.paymaster.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.paymaster.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.paymaster.server.event.PaymasterAutopaymentEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.sql.ConnectionSet;

public class PaymasterAutopaymentEventWorker
extends EventWorker {
    private final int moduleId;
    private TransactionManager transactionManager;
    private AutopaymentManager autopaymentManager;
    private ModuleSetup moduleSetup;

    public PaymasterAutopaymentEventWorker(int moduleId) throws BGException {
        super(EventProcessor.getInstance(), PaymasterAutopaymentEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.errorPause = 60000L;
        Setup setup = Setup.getSetup();
        this.context = new EventListenerContext(setup, moduleId, ConnectionSet.newInstance((DefaultServerSetup)setup, (boolean)true), SetupParam.getApplicationName());
        this.getLogger().info("Starting PaymasterAutopaymentEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "paymaster-autopayment-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.autopaymentManager = new AutopaymentManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        PaymasterAutopaymentEvent event = (PaymasterAutopaymentEvent)((Object)task);
        int contractId = event.getContractId();
        try {
            Contract contract;
            Autopayment autopayment = this.autopaymentManager.getCurrentAutopayment(contractId);
            BigDecimal sum = event.getSum();
            if (sum == null) {
                sum = autopayment.getSum();
            }
            if (autopayment != null && autopayment.getMode().getCode() == event.getMode() && (contract = ContractDao.getContract((Connection)((EventListenerContext)this.context).getConnection(), (int)contractId)) != null) {
                JSONObject resultJsonObject;
                String accessToken = autopayment.getAccessToken();
                String merchantId = this.moduleSetup.get("paymaster.merchant.id", "");
                String secret = this.moduleSetup.get("paymaster.direct.secret", "");
                String description = this.moduleSetup.get("paymaster.payment.desc", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle());
                Transaction transaction = this.transactionManager.directPaymentInit(this.moduleSetup.get("paymaster.direct.init.url", "https://paymaster.ru/direct/payment/init"), accessToken, merchantId, description, sum, secret, contract.getId());
                if (transaction != null && transaction.getStatus().equals(TransactionStatus.INPAY.getCode()) && (resultJsonObject = this.transactionManager.directPaymentComplete(this.moduleSetup.get("paymaster.direct.complete.url", "https://paymaster.ru/direct/payment/complete"), accessToken, merchantId, transaction, secret)) != null && resultJsonObject.has("status")) {
                    String status = resultJsonObject.getString("status");
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("status = " + status);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return null;
    }
}

