/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.datasource;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import ru.bitel.common.TimeUtils;

public class BGRSDataSource
implements JRDataSource {
    protected final ResultSet rs;
    protected final Map<String, Field> fieldMap = new HashMap<String, Field>();

    public BGRSDataSource(ResultSet rs) {
        this.rs = rs;
    }

    public Object getFieldValue(JRField f) throws JRException {
        try {
            return this.getField(f).getValue(this.rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                this.rs.last();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return null;
        }
    }

    protected Field getField(JRField f) throws SQLException {
        Field result = this.fieldMap.get(f.getName());
        if (result == null) {
            int columnIndex = this.searchColumnByName(f.getName());
            Class clazz = f.getValueClass();
            result = clazz.equals(String.class) || String.class.isAssignableFrom(clazz) ? new Field(this, columnIndex){

                @Override
                public Object getValue(ResultSet rs) throws SQLException {
                    return rs.getString(this.columnIndex);
                }
            } : (clazz.equals(BigDecimal.class) ? new Field(this, columnIndex){

                @Override
                public BigDecimal getValue(ResultSet rs) throws SQLException {
                    return rs.getBigDecimal(this.columnIndex);
                }
            } : (clazz.equals(Integer.class) ? new Field(this, columnIndex){

                @Override
                public Object getValue(ResultSet rs) throws SQLException {
                    int result = rs.getInt(this.columnIndex);
                    if (rs.wasNull()) {
                        return null;
                    }
                    return result;
                }
            } : (clazz.equals(Long.class) ? new Field(this, columnIndex){

                @Override
                public Object getValue(ResultSet rs) throws SQLException {
                    long result = rs.getLong(this.columnIndex);
                    if (rs.wasNull()) {
                        return null;
                    }
                    return result;
                }
            } : (clazz.equals(Float.class) ? new Field(this, columnIndex){

                @Override
                public Object getValue(ResultSet rs) throws SQLException {
                    float result = rs.getFloat(this.columnIndex);
                    if (rs.wasNull()) {
                        return null;
                    }
                    return Float.valueOf(result);
                }
            } : (clazz.equals(Double.class) ? new Field(this, columnIndex){

                @Override
                public Object getValue(ResultSet rs) throws SQLException {
                    double result = rs.getDouble(this.columnIndex);
                    if (rs.wasNull()) {
                        return null;
                    }
                    return result;
                }
            } : (clazz.equals(java.util.Date.class) || clazz.equals(Date.class) ? new Field(this, columnIndex){

                @Override
                public Object getValue(ResultSet rs) throws SQLException {
                    return rs.getObject(this.columnIndex);
                }
            } : (clazz.equals(Timestamp.class) ? new Field(this, columnIndex){

                @Override
                public Object getValue(ResultSet rs) throws SQLException {
                    return rs.getTimestamp(this.columnIndex);
                }
            } : (clazz.equals(Time.class) ? new Field(this, columnIndex){

                @Override
                public Object getValue(ResultSet rs) throws SQLException {
                    return rs.getTime(this.columnIndex);
                }
            } : (clazz.equals(Calendar.class) ? new Field(this, columnIndex){

                @Override
                public Object getValue(ResultSet rs) throws SQLException {
                    return TimeUtils.convertDateToCalendar((java.util.Date)rs.getTime(this.columnIndex));
                }
            } : new Field(this, columnIndex){

                @Override
                public Object getValue(ResultSet rs) throws SQLException {
                    return rs.getObject(this.columnIndex);
                }
            })))))))));
            this.fieldMap.put(f.getName(), result);
        }
        return result;
    }

    protected int searchColumnByName(String fieldName) throws SQLException {
        ResultSetMetaData metadata = this.rs.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String columnName = metadata.getColumnLabel(i);
            if (!fieldName.equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public final boolean next() throws JRException {
        try {
            boolean result = this.rs.next();
            if (result) {
                this.onNext();
            }
            return result;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void onNext() throws SQLException {
    }

    protected abstract class Field {
        public final int columnIndex;

        protected Field(BGRSDataSource this$0, int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public abstract Object getValue(ResultSet var1) throws SQLException;
    }
}

