/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.sender;

import java.util.concurrent.ConcurrentHashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.event.ScriptUpdatedEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.EmailSender;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.Sender;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.enterix.EnterixSmsSender;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.smsaero.SmsAeroSender;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.smsaero.SmsAeroV2Sender;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.smsassistent.SmsAssistentSender;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.smsc.SmscSender;

public class SenderFactory
extends BGLogger {
    private static ConcurrentHashMap<String, Sender> senderCache = new ConcurrentHashMap();

    public static Sender getSender(String clazz) throws Exception {
        Sender result = senderCache.get(clazz);
        if (result == null) {
            result = SenderFactory.isBuiltIn(clazz) ? (Sender)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]) : (Sender)DynamicClassManager.getInstance().newProxyInstance(Sender.class, clazz);
            senderCache.put(clazz, result);
        }
        return result;
    }

    private static boolean isBuiltIn(String className) {
        return EmailSender.class.getCanonicalName().equals(className) || SmsAeroSender.class.getCanonicalName().equals(className) || SmsAeroV2Sender.class.getCanonicalName().equals(className) || EnterixSmsSender.class.getCanonicalName().equals(className) || SmscSender.class.getCanonicalName().equals(className) || SmsAssistentSender.class.getCanonicalName().equals(className);
    }

    static {
        try {
            EventProcessor.getInstance().addListener((e, ctx) -> senderCache.clear(), ScriptUpdatedEvent.class);
        }
        catch (BGException ex) {
            BGLogger.error((Throwable)ex);
        }
    }
}

