/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import bitel.billing.server.contract.bean.ContractUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.bean.ConnectionLogEntryDao;
import ru.bitel.bgbilling.modules.inet.common.bean.AccessCodes;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAuthError;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.common.sql.ConnectionSet;

public class InetAuthErrorDao
extends BGLogger
implements AutoCloseable {
    private static final String TABLE_NAME_PREFIX = "inet_auth_error";
    private static final int MIN_ERROR_INTERVAL = 3600;
    private ConnectionSet connectionSet;
    private String tableName;
    private int moduleId;
    private Date date;
    private ConnectionLogEntryDao connectionLogEntryDao;
    private Connection con;
    private PreparedStatement selectPS1;
    private PreparedStatement selectPS2;
    private PreparedStatement updatePS1;
    private PreparedStatement updatePS2;
    private PreparedStatement insertPS;

    public InetAuthErrorDao(ConnectionSet connectionSet, int moduleId, Date date) {
        this.connectionSet = connectionSet;
        this.moduleId = moduleId;
        this.date = date;
        this.tableName = ServerUtils.getModuleMonthTableName((String)TABLE_NAME_PREFIX, (Date)date, (int)moduleId);
        this.connectionLogEntryDao = new ConnectionLogEntryDao(connectionSet, moduleId);
    }

    private static void partition(StringBuilder sb, Date date, int days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        calendar.set(5, 1);
        int last = ((Calendar)calendar).getActualMaximum(5);
        for (int i = calendar.get(5) + days; i < last; i += days) {
            String partitionName = TimeUtils.format((Calendar)calendar, (String)"yyyyMMdd");
            ((Calendar)calendar).add(5, days);
            sb.append("PARTITION p" + partitionName + " VALUES LESS THAN (TO_DAYS( '" + TimeUtils.formatSQLDate((Calendar)calendar) + "' )), \n");
        }
        String partitionName = TimeUtils.format((Calendar)calendar, (String)"yyyyMMdd");
        sb.append("PARTITION p" + partitionName + " VALUES LESS THAN MAXVALUE");
    }

    public void addError(InetAuthError error) throws BGException {
        this.addError(error, true);
    }

    @Override
    public void close() {
        try {
            if (this.selectPS1 != null) {
                this.selectPS1.close();
                this.selectPS1 = null;
            }
            if (this.selectPS2 != null) {
                this.selectPS2.close();
                this.selectPS2 = null;
            }
            if (this.insertPS != null) {
                this.insertPS.close();
                this.insertPS = null;
            }
            if (this.updatePS1 != null) {
                this.updatePS1.close();
                this.updatePS1 = null;
            }
            if (this.updatePS2 != null) {
                this.updatePS2.close();
                this.updatePS2 = null;
            }
            if (this.connectionLogEntryDao != null) {
                this.connectionLogEntryDao.close();
                this.connectionLogEntryDao = null;
            }
            this.con = null;
        }
        catch (SQLException ex) {
            this.getLogger().error("error close InetAuthErrorDao", (Throwable)ex);
        }
    }

    public void addError(InetAuthError error, boolean update) throws BGException {
        this.addError(error, null, update);
    }

    public void addError(InetAuthError error, ConnectionLogEntry logEntry, boolean update) throws BGException {
        if (this.con == null) {
            this.con = this.connectionSet.getTrashConnection(this.tableName, 1);
        }
        try {
            Statement st = this.con.createStatement();
            if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
                StringBuilder sb = new StringBuilder(100).append("CREATE TABLE IF NOT EXISTS " + this.tableName + "(id INT AUTO_INCREMENT NOT NULL, deviceId INT NOT NULL,deviceTitle CHAR(3) NOT NULL,contractId INT NOT NULL, contractTitle CHAR(3) NOT NULL,servId INT NOT NULL,hash INT NOT NULL DEFAULT '0',servTitle CHAR(60) NOT NULL,code INT NOT NULL,count INT NOT NULL DEFAULT 1,lastTime DATETIME NOT NULL,logCoordinateRecordId INT NOT NULL,PRIMARY KEY (id, lastTime),KEY lastTime(lastTime),KEY `time_dcsc` (`deviceId`,`contractId`,`servId`,`code`,`hash`) )");
                sb.append(" /*!50106 PARTITION BY RANGE (TO_DAYS(lastTime)) (");
                InetAuthErrorDao.partition(sb, this.date, 5);
                sb.append(")*/");
                st.executeUpdate(sb.toString());
            }
            st.close();
            long millis = System.currentTimeMillis();
            Timestamp now = TimeUtils.convertDateToTimestampSeconds((Date)new Date(millis));
            if (!update || !this.updateRecord(error, logEntry, update, millis, now)) {
                PreparedStatement ps;
                if (logEntry != null && logEntry.getId() <= 0) {
                    this.connectionLogEntryDao.update(logEntry, true);
                    error.setLogCoordinateRecordId(logEntry.getId());
                }
                if ((ps = this.insertPS) == null) {
                    ps = this.insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (deviceId, deviceTitle, contractId, contractTitle, servId, hash, servTitle, code, logCoordinateRecordId, lastTime, count) VALUES (?,?,?,?,?,?,?,?,?,?,1)");
                }
                ps.setInt(1, error.getDeviceId());
                ps.setString(2, "");
                ps.setInt(3, error.getContractId());
                ps.setString(4, "");
                ps.setInt(5, error.getServId());
                if (error.getServTitle() == null) {
                    ps.setInt(6, 0);
                } else {
                    ps.setInt(6, error.getServTitle().hashCode());
                }
                ps.setString(7, error.getServTitle());
                ps.setInt(8, error.getErrorCode());
                ps.setInt(9, error.getLogCoordinateRecordId());
                ps.setTimestamp(10, now);
                ps.executeUpdate();
                if (!this.con.getAutoCommit()) {
                    this.con.commit();
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private boolean updateRecord(InetAuthError error, ConnectionLogEntry logEntry, boolean update, long millis, Timestamp now) throws SQLException, BGException {
        int logCoordinateRecordId;
        int count;
        Date lastTime;
        int id;
        PreparedStatement ps;
        Timestamp borderTimeFrom = TimeUtils.convertDateToTimestampSeconds((Date)new Date(millis - 3600000L));
        Timestamp borderTimeTo = TimeUtils.convertDateToTimestampSeconds((Date)new Date(millis + 600000L));
        if (error.getErrorCode() == AccessCode.INVALID_ACCOUNT.getCode()) {
            ps = this.selectPS1;
            if (ps == null) {
                ps = this.selectPS1 = this.con.prepareStatement("SELECT id, lastTime, count, logCoordinateRecordId FROM " + this.tableName + " WHERE lastTime>? AND lastTime<? AND deviceId=? AND contractId=? AND servId=? AND code=? AND hash=? AND servTitle=? LIMIT 1");
            }
            ps.setTimestamp(1, borderTimeFrom);
            ps.setTimestamp(2, borderTimeTo);
            ps.setInt(3, error.getDeviceId());
            ps.setInt(4, error.getContractId());
            ps.setInt(5, error.getServId());
            ps.setInt(6, error.getErrorCode());
            int hashCode = error.getServTitle().hashCode();
            ps.setInt(7, hashCode);
            ps.setString(8, error.getServTitle());
        } else {
            ps = this.selectPS2;
            if (ps == null) {
                ps = this.selectPS2 = this.con.prepareStatement("SELECT id, lastTime, count, logCoordinateRecordId FROM " + this.tableName + " WHERE lastTime>? AND lastTime<? AND deviceId=? AND contractId=? AND servId=? AND code=? LIMIT 1");
            }
            ps.setTimestamp(1, borderTimeFrom);
            ps.setTimestamp(2, borderTimeTo);
            ps.setInt(3, error.getDeviceId());
            ps.setInt(4, error.getContractId());
            ps.setInt(5, error.getServId());
            ps.setInt(6, error.getErrorCode());
        }
        try (ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                id = rs.getInt(1);
                lastTime = TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(2));
                count = rs.getInt(3);
                logCoordinateRecordId = rs.getInt(4);
            } else {
                id = 0;
                lastTime = null;
                count = 0;
                logCoordinateRecordId = 0;
            }
        }
        if (id > 0) {
            long borderTime;
            if (logEntry != null && logEntry.getId() <= 0 && (count < 10 || count % 1000 == 0)) {
                this.connectionLogEntryDao.update(logEntry, true);
                error.setLogCoordinateRecordId(logCoordinateRecordId);
            }
            if (error.getLogCoordinateRecordId() <= 0) {
                error.setLogCoordinateRecordId(logCoordinateRecordId);
            }
            long l = borderTime = count > 100 ? 600000L : 180000L;
            if (now.getTime() - lastTime.getTime() > borderTime) {
                ps = this.updatePS1;
                if (ps == null) {
                    ps = this.updatePS1 = this.con.prepareStatement("UPDATE " + this.tableName + " SET lastTime=?, count=count+1, logCoordinateRecordId=? WHERE lastTime>? AND lastTime<? AND id=?");
                }
                ps.setTimestamp(1, now);
                ps.setInt(2, error.getLogCoordinateRecordId());
                ps.setTimestamp(3, borderTimeFrom);
                ps.setTimestamp(4, borderTimeTo);
                ps.setInt(5, id);
            } else {
                ps = this.updatePS2;
                if (ps == null) {
                    ps = this.updatePS2 = this.con.prepareStatement("UPDATE " + this.tableName + " SET count=count+1, logCoordinateRecordId=? WHERE lastTime>? AND lastTime<? AND id=?");
                }
                ps.setInt(1, error.getLogCoordinateRecordId());
                ps.setTimestamp(2, borderTimeFrom);
                ps.setTimestamp(3, borderTimeTo);
                ps.setInt(4, id);
            }
            ps.executeUpdate();
            if (!this.con.getAutoCommit()) {
                this.con.commit();
            }
            return true;
        }
        return false;
    }

    public Result<InetAuthError> errorList(Date timeFrom, Date timeTo, Set<Integer> deviceIds, Set<Integer> contractIds, Set<Integer> serviceIds, String contract, String login, Page page) throws Exception {
        ArrayList<InetAuthError> result;
        block25: {
            result = new ArrayList<InetAuthError>();
            Connection con = this.connectionSet.getTrashConnection(this.tableName, 2);
            try {
                if (!ServerUtils.tableExists((Connection)con, (String)this.tableName)) break block25;
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT SQL_CALC_FOUND_ROWS auth_error.* FROM " + this.tableName + " as auth_error");
                if (Utils.notBlankString((String)contract)) {
                    sb.append(" LEFT JOIN contract ON contract.id=auth_error.contractId");
                }
                if (Utils.notBlankString((String)login)) {
                    sb.append(" LEFT JOIN inet_serv_" + this.moduleId + " as serv ON serv.id=auth_error.servId");
                }
                sb.append(" WHERE auth_error.lastTime>=? AND auth_error.lastTime<?");
                if (contractIds != null && contractIds.size() > 0) {
                    sb.append(" AND auth_error.contractId IN (" + Utils.toString(contractIds) + ")");
                }
                if (deviceIds != null && deviceIds.size() > 0) {
                    sb.append(" AND auth_error.deviceId IN (" + Utils.toString(deviceIds) + ")");
                }
                if (serviceIds != null && serviceIds.size() > 0) {
                    sb.append(" AND auth_error.servId IN (" + Utils.toString(serviceIds) + ")");
                }
                if (Utils.notBlankString((String)contract)) {
                    sb.append(" AND contract.title LIKE ?");
                }
                if (Utils.notBlankString((String)login)) {
                    sb.append(" AND serv.login LIKE ?");
                }
                sb.append(" ORDER BY auth_error.lastTime DESC").append(page.sqlLimit());
                try (PreparedStatement ps = con.prepareStatement(sb.toString());){
                    int index = 1;
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)timeFrom));
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)timeTo));
                    if (Utils.notBlankString((String)contract)) {
                        ps.setString(index++, "%" + contract.trim() + "%");
                    }
                    if (Utils.notBlankString((String)login)) {
                        ps.setString(index++, "%" + login.trim() + "%");
                    }
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            result.add(this.getErrorFromRs(rs));
                        }
                    }
                }
                page.setRecordCount(ServerUtils.foundRows((Connection)con));
                if (result.size() <= 100) {
                    this.addInfo(result, con);
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return new Result(result, page);
    }

    private void addInfo(List<InetAuthError> result, Connection con) throws Exception {
        InetDeviceMap deviceMap = InetDeviceMap.getInstance(this.moduleId);
        ContractUtils contractUtils = new ContractUtils(con);
        for (InetAuthError error : result) {
            String title;
            InetDeviceMap.InetDeviceMapItem device = deviceMap.get(error.getDeviceId());
            if (device != null) {
                error.setDeviceTitle(device.device.getTitle());
            }
            if (error.getContractId() <= 0 || (title = contractUtils.getContractTitle(error.getContractId())) == null) continue;
            error.setContractTitle(title);
        }
    }

    private InetAuthError getErrorFromRs(ResultSet rs) throws SQLException {
        int errorCode = rs.getInt("code");
        return new InetAuthError(rs.getInt("id")).setDeviceId(rs.getInt("deviceId")).setDeviceTitle("").setContractId(rs.getInt("contractId")).setContractTitle("").setServId(rs.getInt("servId")).setServTitle(rs.getString("servTitle")).setErrorCode(errorCode).setErrorText(AccessCodes.toString((ParameterMap)Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)), (int)errorCode)).setLastErrorTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("lastTime"))).setErrorCount(rs.getInt("count")).setLogCoordinateRecordId(rs.getInt("logCoordinateRecordId"));
    }
}

