/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetInterface;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceTypeDao;

public class InetDeviceTypeDao
extends DeviceTypeDao<InetDeviceType> {
    private String interfaceTable;

    public InetDeviceTypeDao(Connection con, int moduleId) {
        super(con, moduleId, "inet_device_type");
        this.interfaceTable = "inet_interface_" + moduleId;
    }

    protected InetDeviceType newDeviceType() {
        return new InetDeviceType();
    }

    protected InetDeviceType getFromRS(ResultSet rs) throws SQLException, BGException {
        InetDeviceType result = new InetDeviceType(rs.getInt("id"), rs.getString("title"));
        result.setDeviceEntitySpecId(rs.getInt("entitySpecId"));
        result.setComment(rs.getString("comment"));
        result.setSaHandlerClass(rs.getString("saHandlerClass"));
        result.setProtocolHandlerClass(rs.getString("protocolHandlerClass"));
        result.setDeviceManagerClass(rs.getString("deviceManagerClass"));
        result.setConfigId(rs.getInt("configId"));
        result.setConfig(rs.getString("config"));
        result.setScriptId(rs.getInt("scriptId"));
        result.setSource(rs.getBoolean("source"));
        result.setUniqueInterfaces(rs.getBoolean("uniqueInterfaces"));
        return result;
    }

    protected void loadData(List<InetDeviceType> types) throws SQLException {
        Objects.requireNonNull(types, "types must be not null");
        if (types.isEmpty()) {
            return;
        }
        String ids = types.stream().map(a -> String.valueOf(a.getId())).collect(Collectors.joining(", "));
        String query = "SELECT id, title, deviceTypeId FROM " + this.interfaceTable + " WHERE deviceTypeId IN ( " + ids + " ) ORDER BY deviceTypeId, id";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                InetInterface inetInterface = new InetInterface(rs.getInt("id"), rs.getString("title")).setDeviceTypeId(rs.getInt("deviceTypeId"));
                types.stream().filter(a -> a.getId() == inetInterface.getDeviceTypeId()).findFirst().ifPresent(a -> a.getInterfaceList().add(inetInterface));
            }
        }
    }

    protected void updateImpl(InetDeviceType b) throws SQLException {
        boolean insert = b.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET entitySpecId=?, configId=?, config=?, saHandlerClass=?, protocolHandlerClass=?, deviceManagerClass=?, scriptId=?, title=?, comment=?, source=?, uniqueInterfaces=? " + (insert ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setInt(1, b.getDeviceEntitySpecId());
            ps.setInt(2, b.getConfigId());
            ps.setString(3, b.getConfig());
            ps.setString(4, b.getSaHandlerClass());
            ps.setString(5, b.getProtocolHandlerClass());
            ps.setString(6, b.getDeviceManagerClass());
            ps.setInt(7, b.getScriptId());
            ps.setString(8, b.getTitle());
            ps.setString(9, b.getComment());
            ps.setBoolean(10, b.isSource());
            ps.setBoolean(11, b.isUniqueInterfaces());
            if (!insert) {
                ps.setInt(12, b.getId());
            }
            ps.executeUpdate();
            if (insert) {
                b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        query = "DELETE FROM " + this.interfaceTable + " WHERE deviceTypeId=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, b.getId());
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        query = "INSERT INTO " + this.interfaceTable + " SET deviceTypeId=?, id=?, title=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, b.getId());
            for (InetInterface iface : b.getInterfaceList()) {
                ps.setInt(2, iface.getId());
                ps.setString(3, iface.getTitle());
                ps.executeUpdate();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public int delete(int id) throws Exception {
        String query = "DELETE FROM " + this.interfaceTable + " WHERE deviceTypeId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
            int n = super.delete(id);
            return n;
        }
    }
}

