/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarValue;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.SearchResult;

public class TariffVarValueDao
extends AbstractDao<TariffVarValue> {
    public TariffVarValueDao(Connection con) {
        super(con, "tariff_vars_value");
    }

    public List<TariffVarValue> list() throws SQLException {
        return this.listImpl(null, null, "tariff_var_id", new Object[0]);
    }

    public void searchTariffVarValue(SearchResult<TariffVarValue> searchResult, int tariffVarId) throws SQLException {
        List list = searchResult.getList();
        list.addAll(this.listImpl(searchResult.getPage(), "SQL_CALC_FOUND_ROWS *", null, "tariff_var_id=?", "date_from desc", new Object[]{tariffVarId}));
    }

    public int deleteTariffVarValues(int tariffVarId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE tariff_var_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, tariffVarId);
            int n = ps.executeUpdate();
            return n;
        }
    }

    public int deleteTariffVarValue(TariffVarValue tariffVarValue) throws SQLException {
        Objects.requireNonNull(tariffVarValue);
        String query = "DELETE FROM " + this.tableName + " WHERE tariff_var_id=?" + (tariffVarValue.getDateFrom() == null ? " AND date_from IS NULL" : " AND date_from=?") + (tariffVarValue.getDateTo() == null ? " AND date_to IS NULL" : " AND date_to=?");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, tariffVarValue.getTariffVarId());
            if (tariffVarValue.getDateFrom() != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)tariffVarValue.getDateFrom()));
            }
            if (tariffVarValue.getDateTo() != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)tariffVarValue.getDateTo()));
            }
            int n = ps.executeUpdate();
            return n;
        }
    }

    protected TariffVarValue getFromRS(ResultSet rs) throws SQLException {
        return (TariffVarValue)this.ormFromResultSet(rs, TariffVarValue.class);
    }

    protected void updateImpl(TariffVarValue tariffVarValue) throws SQLException {
        Objects.requireNonNull(tariffVarValue);
        LocalDate f1 = TimeUtils.convertDateToLocalDate((Date)tariffVarValue.getDateFrom());
        LocalDate f2 = TimeUtils.convertDateToLocalDate((Date)tariffVarValue.getDateTo());
        if (f1 == null && f2 == null) {
            this.deleteTariffVarValues(tariffVarValue.getTariffVarId());
        } else {
            if (f1 == null && f2 != null) {
                String queryDelete = "DELETE FROM " + this.tableName + " WHERE tariff_var_id=? AND date_to<=?";
                try (PreparedStatement psDelete = this.con.prepareStatement(queryDelete);){
                    int index = 1;
                    psDelete.setInt(index++, tariffVarValue.getTariffVarId());
                    psDelete.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f2));
                    psDelete.executeUpdate();
                }
                String queryUpdate = "UPDATE " + this.tableName + " SET date_from=? WHERE tariff_var_id=? AND ( date_from IS NULL OR date_from<=?) AND (date_to IS NULL OR date_to>?)";
                try (PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
                    int index = 1;
                    psUpdate.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f2.plusDays(1L)));
                    psUpdate.setInt(index++, tariffVarValue.getTariffVarId());
                    psUpdate.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f2));
                    psUpdate.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f2));
                    psUpdate.executeUpdate();
                }
            }
            if (f1 != null && f2 == null) {
                String queryDelete = "DELETE FROM " + this.tableName + " WHERE tariff_var_id=? AND date_from>=?";
                try (PreparedStatement psDelete = this.con.prepareStatement(queryDelete);){
                    int index = 1;
                    psDelete.setInt(index++, tariffVarValue.getTariffVarId());
                    psDelete.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f1));
                    psDelete.executeUpdate();
                }
                String queryUpdate = "UPDATE " + this.tableName + " SET date_to=? WHERE tariff_var_id=? AND ( date_from IS NULL OR date_from<=?) AND (date_to IS NULL OR date_to>?)";
                try (PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
                    int index = 1;
                    psUpdate.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f1.minusDays(1L)));
                    psUpdate.setInt(index++, tariffVarValue.getTariffVarId());
                    psUpdate.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f1));
                    psUpdate.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f1));
                    psUpdate.executeUpdate();
                }
            }
            if (f1 != null && f2 != null) {
                int index;
                int index2;
                String query = "DELETE FROM " + this.tableName + " WHERE tariff_var_id=? AND date_to<=? AND date_from>=?";
                try (PreparedStatement psDelete = this.con.prepareStatement(query);){
                    index2 = 1;
                    psDelete.setInt(index2++, tariffVarValue.getTariffVarId());
                    psDelete.setDate(index2++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f2));
                    psDelete.setDate(index2++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f1));
                    psDelete.executeUpdate();
                }
                query = "UPDATE " + this.tableName + " SET date_from=? WHERE tariff_var_id=? AND date_from IS NOT NULL AND date_from<=? AND date_from>=? AND (date_to IS NULL OR date_to>?)";
                try (PreparedStatement psUpdate = this.con.prepareStatement(query);){
                    index2 = 1;
                    psUpdate.setDate(index2++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f2.plusDays(1L)));
                    psUpdate.setInt(index2++, tariffVarValue.getTariffVarId());
                    psUpdate.setDate(index2++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f2));
                    psUpdate.setDate(index2++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f1));
                    psUpdate.setDate(index2++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f2));
                    psUpdate.executeUpdate();
                }
                query = "UPDATE " + this.tableName + " SET date_to=? WHERE tariff_var_id=? AND ( date_from IS NULL OR date_from<=?) AND date_to IS NOT NULL AND date_to<=? AND date_to>=?";
                psUpdate = this.con.prepareStatement(query);
                try {
                    index2 = 1;
                    psUpdate.setDate(index2++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f1.minusDays(1L)));
                    psUpdate.setInt(index2++, tariffVarValue.getTariffVarId());
                    psUpdate.setDate(index2++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f1));
                    psUpdate.setDate(index2++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f2));
                    psUpdate.setDate(index2++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f1));
                    psUpdate.executeUpdate();
                }
                finally {
                    if (psUpdate != null) {
                        psUpdate.close();
                    }
                }
                String value = null;
                java.sql.Date from = null;
                java.sql.Date to = null;
                query = "SELECT * FROM " + this.tableName + " WHERE tariff_var_id=? AND ( date_from IS NULL OR date_from<? ) AND ( date_to IS NULL OR date_to>? )";
                try (PreparedStatement psSelect = this.con.prepareStatement(query);){
                    index = 1;
                    psSelect.setInt(index++, tariffVarValue.getTariffVarId());
                    psSelect.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f1));
                    psSelect.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f2));
                    try (ResultSet rs = psSelect.executeQuery();){
                        while (rs.next()) {
                            value = rs.getString("value");
                            from = rs.getDate("date_from");
                            to = rs.getDate("date_to");
                        }
                    }
                }
                if (value != null) {
                    query = "DELETE FROM " + this.tableName + " WHERE tariff_var_id=? AND ( date_from IS NULL OR date_from<? ) AND ( date_to IS NULL OR date_to>? )";
                    try (PreparedStatement psUpdate = this.con.prepareStatement(query);){
                        index = 1;
                        psUpdate.setInt(index++, tariffVarValue.getTariffVarId());
                        psUpdate.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f1));
                        psUpdate.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)f2));
                        psUpdate.executeUpdate();
                    }
                    this.insertValue(tariffVarValue.getTariffVarId(), TimeUtils.convertDateToSqlDate((Date)from), TimeUtils.convertLocalDateToSqlDate((LocalDate)f1.minusDays(1L)), value);
                    this.insertValue(tariffVarValue.getTariffVarId(), TimeUtils.convertLocalDateToSqlDate((LocalDate)f2.plusDays(1L)), TimeUtils.convertDateToSqlDate((Date)to), value);
                }
            }
        }
        this.insertValue(tariffVarValue.getTariffVarId(), TimeUtils.convertDateToSqlDate((Date)tariffVarValue.getDateFrom()), TimeUtils.convertDateToSqlDate((Date)tariffVarValue.getDateTo()), tariffVarValue.getValue());
    }

    private void insertValue(int id, java.sql.Date from, java.sql.Date to, String value) throws SQLException {
        String query = "INSERT INTO " + this.tableName + " SET tariff_var_id=?, date_from=?, date_to=?, value=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, id);
            if (from == null) {
                ps.setNull(index++, 91);
            } else {
                ps.setDate(index++, from);
            }
            if (to == null) {
                ps.setNull(index++, 91);
            } else {
                ps.setDate(index++, to);
            }
            ps.setString(index++, value);
            ps.executeUpdate();
        }
    }
}

