/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class Pool<O> {
    private volatile WeakReference<ConcurrentLinkedQueue<O>> queueRef;

    private ConcurrentLinkedQueue<O> getPoolQueue() {
        ConcurrentLinkedQueue d;
        WeakReference<ConcurrentLinkedQueue<O>> q = this.queueRef;
        if (q != null && (d = (ConcurrentLinkedQueue)q.get()) != null) {
            return d;
        }
        d = new ConcurrentLinkedQueue();
        this.queueRef = new WeakReference<ConcurrentLinkedQueue>(d);
        return d;
    }

    public O take() {
        O t = this.getPoolQueue().poll();
        if (t == null) {
            return this.create();
        }
        return t;
    }

    public void recycle(O t) {
        this.getPoolQueue().offer(t);
    }

    protected abstract O create();
}

