/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.admin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponentPrice;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class LicenseProductPricePanel
extends BGUPanel {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private BGUList<IdTitle> productList = new BGUList();
    private BGDataSourceTableModel tariffGroupTableModel = new BGDataSourceTableModel("TariffGroupPrice");
    private BGDataSourceTableModel componentTableModel = new BGDataSourceTableModel("ProductComponentPrice");
    private BGUPanel.WebServiceHolder<LicenseService> licenseService = new BGUPanel.WebServiceHolder((BGUPanel)this, LicenseService.class);

    protected void jbInit() throws Exception {
        this.tabbedPane.add("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b", this.getPriceTablePanel());
        this.tabbedPane.add("\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u0433\u0440\u0443\u043f\u043f\u044b", this.getTariffGroupTablePanel());
        this.setLayout(new GridBagLayout());
        this.add(this.getProductPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.tabbedPane, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getProductPanel() {
        this.productList.setSelectionMode(0);
        this.productList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                this.selectProduct();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.productList, (int)300, (int)200), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getTariffGroupTablePanel() {
        BGUTable table = new BGUTable((TableModel)this.tariffGroupTableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getPriceTablePanel() {
        BGUTable table = new BGUTable((TableModel)this.componentTableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private void selectProduct() {
        IdTitle product = (IdTitle)this.productList.getSelectedValue();
        if (product == null) {
            return;
        }
        BGUTableParams tableParams = new BGUTableParams().addParam("productId", String.valueOf(product.getId()));
        this.componentTableModel.loadData((ClientContext)this.getContext(), tableParams);
        this.tariffGroupTableModel.loadData((ClientContext)this.getContext(), tableParams);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.productList.setData(((LicenseService)this.licenseService.get()).productTitles()));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            Id id = (Id)this.componentTableModel.getSelectRow(Id.class);
            if (id != null) {
                new PriceEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430", id).open();
            }
        });
    }

    class PriceEditorDialog
    extends BGEditorDialog<Id> {
        private BGTextField unlimPrice;
        private PriceRangeTableModel tableModel;
        private BGUTable table;

        public PriceEditorDialog(String title, Id data) {
            super(title, (Object)data);
            this.unlimPrice = new BGTextField(40);
            this.tableModel = new PriceRangeTableModel();
            this.table = new BGUTable((TableModel)((Object)this.tableModel));
        }

        public void doDialogPanel() {
            this.unlimPrice.setHorizontalAlignment(0);
            this.panel.add((Component)this.getRangePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.addFieldV("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0431\u0435\u0437\u043b\u0438\u043c\u0438\u0442\u0430:", (JComponent)this.unlimPrice);
            this.panel.getActionMap().put("edit", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PriceEditorDialog.this.tableModel.optSelectedRow().ifPresentOrElse(a -> new PriceRangeEditor(LicenseProductPricePanel.this, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430", (PriceRange)a, PriceEditorDialog.this.tableModel).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d"));
                }
            });
            this.tryCall(() -> {
                ArrayList<PriceRange> list = new ArrayList<PriceRange>();
                String unlimPriceText = "";
                LicenseComponentPrice price = ((LicenseService)LicenseProductPricePanel.this.licenseService.get()).licenseComponentPriceGet(((IdTitle)LicenseProductPricePanel.this.productList.getSelectedValue()).getId(), ((Id)this.data).getId());
                if (price != null) {
                    JSONObject json = new JSONObject(price.getPrice());
                    unlimPriceText = json.optBigDecimal("unlim", BigDecimal.ZERO).toPlainString();
                    JSONArray array = json.optJSONArray("ranges");
                    for (int index = 0; index < array.length(); ++index) {
                        JSONObject rangeJson = array.getJSONObject(index);
                        PriceRange priceRange = new PriceRange(LicenseProductPricePanel.this);
                        priceRange.range = rangeJson.optInt("range");
                        priceRange.cost = rangeJson.optBigDecimal("cost", BigDecimal.ZERO);
                        list.add(priceRange);
                    }
                }
                this.unlimPrice.setText(unlimPriceText);
                this.tableModel.setData(list);
            });
        }

        private JPanel getRangePanel() {
            BGSwingUtilites.handleEdit((JTable)this.table, (JPanel)this.panel, (String)"edit");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getToolbarPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.table, (int)600, (int)400), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getToolbarPanel() {
            BGButton addButton = new BGButton();
            addButton.setIcon((Icon)ClientUtils.getIcon((String)"add"));
            addButton.addActionListener(e -> new PriceRangeEditor(LicenseProductPricePanel.this, "\u041d\u043e\u0432\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d", new PriceRange(LicenseProductPricePanel.this), this.tableModel).open());
            BGButton editButton = new BGButton();
            editButton.setAction(this.panel.getActionMap().get("edit"));
            editButton.setIcon((Icon)ClientUtils.getIcon((String)"edit"));
            BGButton deleteButton = new BGButton();
            deleteButton.setIcon((Icon)ClientUtils.getIcon((String)"delete"));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u044b:"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)addButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)editButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)deleteButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            BigDecimal unlim = null;
            try {
                unlim = new BigDecimal(this.unlimPrice.getText());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0431\u0435\u0437\u043b\u0438\u043c\u0438\u0442\u0430");
                return false;
            }
            JSONArray ranges = new JSONArray();
            this.tableModel.getRows().forEach(a -> ranges.put((Object)new JSONObject().put("range", a.getRange()).put("cost", (Object)a.getCost())));
            JSONObject json = new JSONObject().put("unlim", (Object)unlim).put("ranges", (Object)ranges);
            return this.tryCallBoolean(() -> {
                ((LicenseService)LicenseProductPricePanel.this.licenseService.get()).licenseComponentPriceUpdate(((IdTitle)LicenseProductPricePanel.this.productList.getSelectedValue()).getId(), ((Id)this.data).getId(), json.toString());
                LicenseProductPricePanel.this.selectProduct();
            });
        }
    }

    public class PriceRange
    implements Comparable<PriceRange> {
        private int range = 0;
        private BigDecimal cost;

        public PriceRange(LicenseProductPricePanel this$0) {
        }

        public int getRange() {
            return this.range;
        }

        public BigDecimal getCost() {
            return this.cost;
        }

        @Override
        public int compareTo(PriceRange o) {
            return this.range < o.range ? -1 : (this.range == o.range ? 0 : 1);
        }
    }

    class PriceRangeTableModel
    extends BGTableModel<PriceRange> {
        public PriceRangeTableModel() {
            super(PriceRangeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d", 300, 300, 300, "range", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", -1, -1, -1, "cost", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }
    }

    class PriceRangeEditor
    extends BGEditorDialog<PriceRange> {
        private PriceRangeTableModel tableModel;
        private BGTextField range = new BGTextField(30);
        private BGTextField cost = new BGTextField(30);

        public PriceRangeEditor(LicenseProductPricePanel this$0, String title, PriceRange data, PriceRangeTableModel tableModel) {
            super(title, (Object)data);
            this.tableModel = tableModel;
        }

        public void doDialogPanel() {
            this.range.setHorizontalAlignment(0);
            this.cost.setHorizontalAlignment(0);
            this.addFieldV("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d:", (JComponent)this.range);
            this.addFieldV("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c:", (JComponent)this.cost);
            this.range.setText(String.valueOf(((PriceRange)this.data).range));
            this.cost.setText(((PriceRange)this.data).cost == null ? "" : ((PriceRange)this.data).cost.toPlainString());
        }

        public boolean doApply() throws Exception {
            if (!this.range.getText().matches("\\d+") || Utils.parseInt((String)this.range.getText()) < 1) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d (\u0446\u0435\u043b\u043e\u0435 \u0447\u0438\u0441\u043b\u043e \u0431\u043e\u043b\u044c\u0448\u0435 0)");
                return false;
            }
            try {
                new BigDecimal(this.cost.getText());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c");
                return false;
            }
            boolean newRange = ((PriceRange)this.data).cost == null;
            ((PriceRange)this.data).range = Utils.parseInt((String)this.range.getText());
            ((PriceRange)this.data).cost = new BigDecimal(this.cost.getText());
            if (newRange) {
                this.tableModel.getRows().add((PriceRange)this.data);
            }
            ArrayList list = new ArrayList(this.tableModel.getRows());
            Collections.sort(list);
            this.tableModel.setData(list);
            return true;
        }
    }
}

