/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.sql.Connection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.OSMPAbstractTransactionManager;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class KaspiTransactionManager
extends OSMPAbstractTransactionManager {
    public KaspiTransactionManager() {
        super(null, null, null, null, "kaspi_txn_id", null);
    }

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            mpsResponse.setAction(mpsRequest.getAction());
            mpsResponse.setTransId(mpsRequest.getTransId());
            mpsResponse.getParameters().put("request", mpsRequest);
            switch (mpsRequest.getAction()) {
                case 1: {
                    Contract contract = this.actionCheck(mpsRequest);
                    mpsResponse.setContract(contract);
                    mpsResponse.setMessage(this.getComment(system, conf, con, contract));
                    break;
                }
                case 2: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction != null && transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        throw new MPSException(4);
                    }
                    if (transaction != null) break;
                    Contract contract = this.actionCheck(mpsRequest);
                    transaction = this.addTransaction(-1, con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getRawNumber(), mpsRequest.getType(), system.title);
                    mpsResponse.setContract(contract);
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setSum(transaction.getSum());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1, e.getMessage()), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) {
        MPSRequest mpsRequest = super.parseRequest(con, moduleId, mpsId, system, request);
        if ("payment".equals(request.getParameter(this.nameCommand))) {
            mpsRequest.setAction(2);
        }
        return mpsRequest;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        Document doc = this.documentBuilder.newDocument();
        Element responseElement = XMLUtils.createElement((Document)doc, (String)"response");
        this.processResponseEvent(response, responseElement);
        XMLUtils.createElement((Element)responseElement, (String)"result").setTextContent(String.valueOf(response.getResult()));
        if (response.getSum() != null) {
            XMLUtils.createElement((Element)responseElement, (String)"sum").setTextContent(Utils.formatCost((BigDecimal)response.getSum()));
        }
        if (response.getMessage() != null) {
            XMLUtils.createElement((Element)responseElement, (String)"comment").setTextContent(response.getMessage());
        }
        if (response.getTransId() != null) {
            XMLUtils.createElement((Element)responseElement, (String)this.resultTxnID).setTextContent(response.getTransId());
        }
        if (response.getAction() == 2) {
            XMLUtils.createElement((Element)responseElement, (String)this.resultPrvTxnID).setTextContent(String.valueOf(response.getId()));
        }
        this.setResponseParameters(response, responseElement);
        return this.xmlSerialize(doc);
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        if (response.getAction() == 1) {
            switch (ex.error) {
                case 3: {
                    response.setResult(1);
                    break;
                }
                default: {
                    response.setResult(5);
                    break;
                }
            }
        } else if (response.getAction() == 2) {
            switch (ex.error) {
                case 4: {
                    response.setResult(2);
                    break;
                }
                default: {
                    response.setResult(4);
                }
            }
        }
        response.setMessage(ex.getMessage());
    }
}

