/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;

public abstract class EmailServiceActivator
extends BGLogger
implements AutoCloseable {
    public void create(Account account) throws Exception {
        this.getLogger().debug("Create service " + account.getAccount());
        try {
            this.createImpl(account);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw ex;
        }
    }

    public void cancel(Account account) throws Exception {
        this.getLogger().debug("Cancel service " + account.getAccount());
        try {
            this.cancelImpl(account);
        }
        catch (BGException ex) {
            this.logError(ex);
            throw ex;
        }
    }

    public void modify(Account account) throws Exception {
        this.getLogger().debug("Modify service " + account.getAccount());
        try {
            this.modifyImpl(account);
        }
        catch (BGException ex) {
            this.logError(ex);
            throw ex;
        }
    }

    protected abstract void createImpl(Account var1) throws Exception;

    protected abstract void cancelImpl(Account var1) throws Exception;

    protected abstract void modifyImpl(Account var1) throws Exception;

    @Override
    public void close() {
    }

    public void updateDomain(Domain domain) throws Exception {
        this.getLogger().debug("Update domain " + domain.getId());
        try {
            this.updateDomainImpl(domain);
        }
        catch (BGException ex) {
            this.logError(ex);
            throw ex;
        }
    }

    public void removeDomain(Domain domain) throws Exception {
        this.getLogger().debug("Remove domain - {}", (Object)domain.getId());
        try {
            this.removeDomainImpl(domain);
        }
        catch (Exception ex) {
            this.logError(ex);
            throw ex;
        }
    }

    protected abstract void updateDomainImpl(Domain var1) throws Exception;

    protected abstract void removeDomainImpl(Domain var1) throws Exception;
}

