/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.database.server.service;

import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.database.common.service.DatabaseService;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.database.common.service.DatabaseService")
public class DatabaseServiceImpl
extends AbstractService
implements DatabaseService {
    @Override
    public List<String> getModulePluginList() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        JSONObject jsonObject = new JSONObject().put("id", 0).put("title", (Object)"\u042f\u0434\u0440\u043e");
        list.add(jsonObject.toString());
        ModuleManager moduleManager = new ModuleManager(this.getConnection());
        moduleManager.getModules(null).forEach(e -> {
            JSONObject json = new JSONObject();
            json.put("id", e.getId());
            json.put("title", (Object)e.getTitle());
            list.add(json.toString());
        });
        return list;
    }

    @Override
    public SearchResult<String> searchTableNames(int moduleId, String tableNameMask, String[] sort, Page page) throws Exception {
        Connection con = this.getConnection();
        SearchResult searchResult = new SearchResult(page);
        ArrayList<String> list = new ArrayList<String>();
        String tableSchema = this.getSetup().get("database.table.schema", "bgbilling");
        String query = "SELECT SQL_CALC_FOUND_ROWS table_name AS `name`, ROUND((data_length + index_length) / 1024 / 1024, 2) `size` FROM information_schema.TABLES WHERE table_schema=? ORDER BY `size` DESC, table_name ASC";
        ArrayList<TableData> tables = new ArrayList<TableData>();
        try (PreparedStatement psSelect = con.prepareStatement(query);){
            int parameterIndex = 1;
            psSelect.setString(parameterIndex++, tableSchema);
            try (ResultSet resultSet = psSelect.executeQuery();){
                while (resultSet.next()) {
                    TableData tableData = new TableData(this);
                    tableData.name = resultSet.getString("name");
                    tableData.size = resultSet.getBigDecimal("size");
                    tables.add(tableData);
                }
            }
            for (TableData tableData : tables) {
                JSONObject json;
                String name = tableData.name;
                if (name.matches(".*_\\d{6}")) {
                    name = name.substring(0, name.length() - 7);
                }
                if (Utils.notBlankString((String)tableNameMask) && !name.matches(tableNameMask)) continue;
                if (moduleId == 0) {
                    if (name.matches(".*_\\d+")) continue;
                    json = new JSONObject().put("name", (Object)tableData.name).put("subsystem", (Object)"\u044f\u0434\u0440\u043e").put("size", (Object)tableData.size);
                    list.add(json.toString());
                    continue;
                }
                if (!name.matches(".*_" + moduleId)) continue;
                json = new JSONObject().put("name", (Object)tableData.name).put("subsystem", (Object)(ModuleCache.getInstance().getModule(moduleId).getGuiTitle() + " [ID#" + moduleId + "]")).put("size", (Object)tableData.size);
                list.add(json.toString());
            }
            Page.setRecordCount((Page)page, (int)list.size());
            ArrayList pageList = new ArrayList(list);
            searchResult.setList(pageList.stream().skip(page.indexStart()).limit(page.getPageSize()).toList());
        }
        return searchResult;
    }

    @Override
    public List<String> getTableInfo(String tableName) throws Exception {
        Connection con = this.getConnection();
        int tableRows = 0;
        Object query = "SELECT COUNT(*) FROM " + tableName;
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery((String)query);){
            while (rs.next()) {
                tableRows = rs.getInt(1);
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        String tableSchema = this.getSetup().get("database.table.schema", "bgbilling");
        query = "SELECT * FROM information_schema.TABLES WHERE table_schema=? AND table_name=?";
        try (PreparedStatement ps = con.prepareStatement((String)query);){
            int parameterIndex = 1;
            ps.setString(parameterIndex++, tableSchema);
            ps.setString(parameterIndex++, tableName);
            try (ResultSet resultSet = ps.executeQuery();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                while (resultSet.next()) {
                    for (int column = 1; column <= resultSetMetaData.getColumnCount(); ++column) {
                        String columnName = resultSetMetaData.getColumnName(column);
                        String value = "TABLE_ROWS".equals(columnName) ? String.valueOf(tableRows) : resultSet.getString(column);
                        JSONObject json = new JSONObject().put("name", (Object)columnName).put("value", (Object)value);
                        list.add(json.toString());
                    }
                }
            }
        }
        return list;
    }

    @Override
    public List<String> getTableDataRecord(String tableName, int recordIndex) throws Exception {
        Connection con = this.getConnection();
        ArrayList<String> list = new ArrayList<String>();
        String query = "SELECT * FROM " + tableName + " LIMIT 1 OFFSET ?";
        try (PreparedStatement psSelect = con.prepareStatement(query);){
            int parameterIndex = 1;
            psSelect.setInt(parameterIndex++, recordIndex);
            try (ResultSet resultSet = psSelect.executeQuery();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                while (resultSet.next()) {
                    for (int column = 1; column <= resultSetMetaData.getColumnCount(); ++column) {
                        JSONObject json = new JSONObject();
                        json.put("name", (Object)resultSetMetaData.getColumnName(column));
                        json.put("value", (Object)resultSet.getString(column));
                        list.add(json.toString());
                    }
                }
            }
        }
        return list;
    }

    @Override
    public List<String> getTableDataHeaders(String tableName) throws Exception {
        Connection con = this.getConnection();
        ArrayList<String> list = new ArrayList<String>();
        String query = "SELECT * FROM " + tableName + " LIMIT 1";
        try (PreparedStatement psSelect = con.prepareStatement(query);
             ResultSet resultSet = psSelect.executeQuery();){
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (int column = 1; column <= resultSetMetaData.getColumnCount(); ++column) {
                list.add(resultSetMetaData.getColumnName(column));
            }
        }
        return list;
    }

    @Override
    public List<String> getTableData(String tableName, Page page) throws Exception {
        Connection con = this.getConnection();
        ArrayList<String> list = new ArrayList<String>();
        String query = "SELECT * FROM " + tableName + Page.toSqlLimit((Page)page);
        try (PreparedStatement psSelect = con.prepareStatement(query);
             ResultSet resultSet = psSelect.executeQuery();){
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                JSONObject json = new JSONObject();
                for (int column = 1; column <= resultSetMetaData.getColumnCount(); ++column) {
                    json.put(resultSetMetaData.getColumnName(column), (Object)resultSet.getString(column));
                }
                list.add(json.toString());
            }
        }
        return list;
    }

    @Override
    public void dropTables(List<String> tableNames) throws Exception {
        if (this.userId != 1) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f 'admin'");
        }
        Connection con = this.getConnection();
        for (String tableName : tableNames) {
            ServerUtils.dropExistTable(con, tableName);
            con.commit();
        }
    }

    class TableData {
        String name;
        BigDecimal size;

        TableData(DatabaseServiceImpl this$0) {
        }
    }
}

