/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.report.csv;

import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport;

public class ReportHouses
extends BGCSVReport {
    @Override
    public void fillReportToStream(OutputStream out) {
        try {
            this.fillCSVReportToStream(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void writeCsvLines(int fieldCount) throws Exception {
        long time = System.currentTimeMillis();
        String query = "SELECT c.title, q.title, s.title, CONCAT(h.house, h.frac), h.amount, d.value, h.comment FROM address_house AS h LEFT JOIN address_street AS s ON h.streetid=s.id LEFT JOIN address_quarter AS q ON q.id=h.quarterid LEFT JOIN address_city AS c ON c.id=s.cityid LEFT JOIN address_config AS d ON h.id=d.record_id WHERE d.table_id='address_house' AND d.key='dateConnecting'";
        PreparedStatement preparedStatement = this.con.prepareStatement(query);
        ResultSet resultSet = preparedStatement.executeQuery();
        int columnCount = resultSet.getMetaData().getColumnCount();
        if (columnCount >= fieldCount) {
            String[] fieldLine = new String[fieldCount];
            while (resultSet.next()) {
                for (int index = 0; index < fieldCount; ++index) {
                    fieldLine[index] = resultSet.getString(index + 1);
                }
                this.csvWriter.writeNext(fieldLine);
            }
        }
        resultSet.close();
        preparedStatement.close();
        long processTime = System.currentTimeMillis() - time;
        this.getLogger().info("Process time => " + processTime);
    }
}

