/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client.tariff;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.bgbilling.modules.hd.common.bean.EventConst;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class EventTypeTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon((String)"bank.gif");
    private JLabel view;
    private JPanel editor;
    private BGComboBox<IdTitle> eventTypeCB;
    private BGComboBox<IdTitle> periodCB;
    private int eventType;
    private int periodId;
    private Directory actPeriodDir;
    private Directory prolPeriodDir;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.actPeriodDir = this.getDirManager().getDirectory("act_period");
        this.prolPeriodDir = this.getDirManager().getDirectory("prol_period");
    }

    protected JPanel getEditorPanel() throws Exception {
        if (this.editor == null) {
            this.editor = new JPanel();
            this.eventTypeCB = new BGComboBox();
            this.eventTypeCB.addItem((Object)new IdTitle(1, "\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f"));
            this.eventTypeCB.addItem((Object)new IdTitle(2, "\u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435"));
            this.periodCB = new BGComboBox();
            this.editor.add((Component)this.eventTypeCB);
            this.editor.add(new JLabel(" \u043d\u0430 "));
            this.editor.add((Component)this.periodCB);
            this.rebuildPeriodDir();
            this.eventTypeCB.addActionListener(e -> {
                this.eventType = this.getIdFromDirectoryCombo((JComboBox)this.eventTypeCB);
                this.rebuildPeriodDir();
            });
        }
        return this.editor;
    }

    public Component getView() throws Exception {
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.extractData();
        StringBuilder sb = new StringBuilder();
        sb.append(EventConst.typeToString((int)this.eventType));
        sb.append(" \u043d\u0430 ");
        String periodTitle = null;
        periodTitle = this.eventType == 1 ? this.actPeriodDir.getValue(this.periodId) : this.prolPeriodDir.getValue(this.periodId);
        if (periodTitle != null) {
            sb.append(periodTitle);
        }
        this.view.setText(sb.toString());
        return this.view;
    }

    protected void loadData() throws Exception {
        this.extractData();
        this.rebuildPeriodDir();
        this.setDirectoryItemSelection((JComboBox)this.eventTypeCB, this.eventType);
        this.setDirectoryItemSelection((JComboBox)this.periodCB, this.periodId);
    }

    protected void serializeData() {
        this.eventType = this.getIdFromDirectoryCombo((JComboBox)this.eventTypeCB);
        this.periodId = this.getIdFromDirectoryCombo((JComboBox)this.periodCB);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("type", String.valueOf(this.eventType));
        data.put("period", String.valueOf(this.periodId));
        this.setDataInHash(data);
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.eventType = Utils.parseInt((String)((String)data.get("type")));
        this.periodId = Utils.parseInt((String)((String)data.get("period")));
    }

    private void rebuildPeriodDir() {
        this.periodCB.removeAllItems();
        try {
            if (this.eventType == 1) {
                this.buildDirectoryCombo(this.actPeriodDir, (JComboBox)this.periodCB);
            } else {
                this.buildDirectoryCombo(this.prolPeriodDir, (JComboBox)this.periodCB);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }
}

