/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.service;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.FileNotFoundException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Reserve;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ReserveType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ReserveService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.system.HelpDeskMessageForContractEvent;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.ChangeManager;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.FileInfo;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.HelpDeskLinks;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Package;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.PackageContract;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.common.dto.ContractModeDTO;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.HelpDeskDirectoryManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.ManagerChangeManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.PackageManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.ParamManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicListFilter;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.event.TopicWillBeCreated;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;
import ru.bitel.bgbilling.plugins.helpdesk.server.mail.MailMessageNotification;
import ru.bitel.bgbilling.plugins.helpdesk.server.notification.EmailNotification;
import ru.bitel.bgbilling.plugins.helpdesk.server.notification.TelegramNotification;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService")
public class HelpdeskServiceImpl
extends AbstractService
implements HelpdeskService {
    private static BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
    @Resource
    private ReserveService reserveService;
    private BalanceDao balanceDao;
    private TopicManager topicManager;

    private TopicManager getTopicManager() {
        if (this.topicManager == null) {
            this.topicManager = new TopicManager(this.getConnection(), BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk"));
        }
        return this.topicManager;
    }

    private BalanceDao getBalanceDao() {
        if (this.balanceDao == null) {
            this.balanceDao = new BalanceDao(this.getConnection());
        }
        return this.balanceDao;
    }

    private HelpDeskDirectoryManager getHelpDeskDirectoryManager() {
        return new HelpDeskDirectoryManager(this.getConnection(), plugin);
    }

    @PreDestroy
    private void destroy() {
        try {
            if (this.balanceDao != null) {
                this.balanceDao.close();
                this.balanceDao = null;
            }
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public int reservStatusUpdate(int topicId, int reserveStatus) throws Exception, BGMessageException {
        Topic topic = this.getTopicManager().getTopic(topicId);
        if (topic.isClosed()) {
            throw new BGMessageException("\u0423 \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0445 \u0442\u0435\u043c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043e\u0432 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430.");
        }
        Reserve reserveOld = this.getTopicManager().getReserveOnTopic(topicId);
        int reserveStatusOld = this.getTopicManager().getReserveStatus(topicId);
        if (reserveStatusOld == reserveStatus && reserveOld != null && reserveOld.getSum().compareTo(topic.getCost()) == 0 || reserveOld == null && reserveStatusOld == reserveStatus && (reserveStatus == 0 || reserveStatus == 1)) {
            return 0;
        }
        if (!(ReserveDao.flagReserve || reserveStatus != 2 && reserveStatus != 1)) {
            throw new BGMessageException("\u0412\u043b\u0438\u044f\u043d\u0438\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043e\u0432 \u043d\u0430 \u0431\u0430\u043b\u0430\u043d\u0441 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e! \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043e\u0432 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.");
        }
        if (reserveStatus == 2) {
            Contract contract = this.getContract(topic.getContractId());
            if (contract.isDependSub()) {
                contract = this.getContract(contract.getSuperCid());
            }
            Calendar calendar = Calendar.getInstance();
            BigDecimal balance = this.getBalanceDao().getBalance(contract.getId(), calendar.get(1), calendar.get(2) + 1);
            BigDecimal sumChange = reserveOld != null ? topic.getCost().subtract(reserveOld.getSum()) : topic.getCost();
            if (contract.getBalanceLimit().compareTo(balance.subtract(sumChange)) == -1) {
                Reserve reserve;
                if (reserveOld != null) {
                    reserveOld.setSum(topic.getCost());
                    reserve = reserveOld;
                } else {
                    int reserveTypeId = this.getSetup().getInt("topic.reserve.type.id", -1);
                    if (reserveTypeId < 1) {
                        List list = this.reserveService.reserveTypeList(true);
                        int n = reserveTypeId = list.size() > 0 ? ((ReserveType)list.get(0)).getId() : -1;
                    }
                    if (reserveTypeId < 1) {
                        throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u0440\u0435\u0437\u0435\u0440\u0432\u0430 \u0434\u043b\u044f \u0442\u0435\u043c\u044b \u0438 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u044e\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0442\u0438\u043f\u044b \u0440\u0435\u0437\u0435\u0440\u0432\u043e\u0432");
                    }
                    reserve = Reserve.builder().setId(0).setContractId(topic.getContractId()).setTypeId(reserveTypeId).setSum(topic.getCost()).setComment("\u0421\u043e\u0437\u0434\u0430\u043d \u0432 \u0442\u0435\u043c\u0435 - \"" + topic.getTitle() + "\" c \u043d\u043e\u043c\u0435\u0440\u043e\u043c - " + topic.getId()).build();
                }
                return this.getTopicManager().updateTopicReservStatus(topicId, reserveStatus, this.reserveService.updateReserve(reserve));
            }
            reserveStatus = 1;
        }
        if (reserveStatus == 1 || reserveStatus == 0) {
            if (reserveOld != null) {
                String statusStr = reserveStatus == 1 ? "\"\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435\"" : "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d";
                reserveOld.setComment(reserveOld.getComment() + " || \u0417\u0430\u043a\u0440\u044b\u0442 \u043f\u043e \u043f\u0440\u0438\u0447\u0438\u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u043d\u0430 " + statusStr);
                this.reserveService.updateReserve(reserveOld);
                this.reserveService.closeReserve(reserveOld.getId());
            }
            return this.getTopicManager().updateTopicReservStatus(topicId, reserveStatus, null);
        }
        return 0;
    }

    public int reserveStatusGet(int topicId) throws Exception {
        return this.getTopicManager().getReserveStatus(topicId);
    }

    public int topicCostUpdate(int topicId, BigDecimal sum) throws Exception {
        if (sum.compareTo(BigDecimal.ZERO) == -1) {
            throw new BGMessageException("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
        }
        Topic topic = this.getTopicManager().getTopic(topicId);
        BigDecimal oldSum = topic.getCost();
        if (oldSum.compareTo(sum) == 0) {
            return 0;
        }
        topic.setCost(sum);
        return this.getTopicManager().updateTopic(topic);
    }

    public int topicNotificationUpdate(int topicId, int mode, String value) throws Exception {
        Topic topic = this.getTopicManager().getTopic(topicId);
        topic.setComm(mode);
        topic.setCommValue(value);
        return this.getTopicManager().updateTopic(topic);
    }

    public void fileDelete(int fileId) throws Exception {
        if (fileId <= 0) {
            throw new BGIllegalArgumentException();
        }
        new HelpdeskFileStorage(this.getConnection()).deleteFile(fileId);
    }

    public FileDto fileDownload(int fileId, int contractId) throws Exception {
        if (fileId <= 0) {
            throw new BGIllegalArgumentException();
        }
        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.getConnection());
        BGServerFile serverFile = fileStorage.getFileById(fileId);
        if (serverFile == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (1)");
        }
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        Message message = topicManager.getMessage(serverFile.getOwnerId());
        if (message != null) {
            serverFile.setContractId(topicManager.getTopicOwnerId(message.getTopicId()));
        }
        if (serverFile.getContractId() != contractId) {
            throw new BGMessageException("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0438 OwnerId \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442! fileId = " + fileId + "; contractId = " + contractId + "; file_contractId = " + serverFile.getContractId());
        }
        try {
            FileDto fileDto = FileDto.fromDataSource((DataSource)fileStorage.getDataSource(fileId));
            fileDto.setServerFile(serverFile);
            return fileDto;
        }
        catch (FileNotFoundException e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (2).\n" + e.getLocalizedMessage());
        }
    }

    public FileInfo fileUpload(String ownerId, String uuid, String filename, long size, Holder<DataHandler> inclusion) throws Exception {
        int iownerId = Utils.parseInt((String)ownerId, (int)-1);
        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.getConnection());
        BGServerFile messageFile = new BGServerFile();
        messageFile.setOwnerId(iownerId);
        messageFile.setTitle(filename);
        messageFile.setSize(size);
        messageFile.setComment("");
        messageFile.setUuid(uuid);
        messageFile.setDate(new Date());
        messageFile.setUserId(this.userId);
        fileStorage.updateFile(messageFile);
        if (messageFile.getId() > 0) {
            try {
                fileStorage.saveStream(messageFile.getId(), ((DataHandler)inclusion.value).getInputStream());
                FileInfo fileInfo = new FileInfo();
                fileInfo.setId(messageFile.getId());
                fileInfo.setTitle(messageFile.getTitle());
                fileInfo.setSize(new BigDecimal(messageFile.getSize()));
                return fileInfo;
            }
            catch (Exception e) {
                fileStorage.deleteFile(messageFile.getId());
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.\n\u0418\u043b\u0438 \u043f\u0440\u0438\u0448\u043b\u0438 \u0431\u0438\u0442\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u0430.\n" + e.getMessage());
            }
        }
        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0411\u0414");
    }

    public int messageUpdate(Message message) throws Exception {
        if (Utils.isBlankString((String)message.getBody())) {
            throw new BGIllegalArgumentException();
        }
        Topic topic = this.topicGet(0, message.getTopicId(), false);
        if (topic.isClosed() && message.getUserIdFrom() == 0) {
            throw new BGMessageException("\u0422\u0435\u043c\u0430 \u0443\u0436\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0430", "topic.closed");
        }
        this.getTopicManager().updateMessage(message.getId() > 0 ? message.getId() : 0, message);
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(connection);
        List files = fileStorage.getFilesListByOwner(-1, message.getUuid());
        this.setMessageAsOwnerOfTopicFiles((FileStorage)fileStorage, message, files);
        if (message.getId() <= 0) {
            return message.getId();
        }
        if (message.getUserIdFrom() == 0) {
            this.sendNotificationToUser(topic, message, files);
        } else {
            this.sendNotificationToAbonent(topic, message);
        }
        return message.getId();
    }

    public int messagePrevId(int topicId, int id) throws Exception {
        int prevId = this.getTopicManager().getPrevMessageId(id, topicId);
        if (prevId == -1) {
            throw new BGMessageException("\u042d\u0442\u043e \u043f\u0435\u0440\u0432\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c.");
        }
        return prevId;
    }

    public int messageNextId(int topicId, int id) throws Exception {
        int nextId = this.getTopicManager().getNextMessageId(id, topicId);
        if (nextId == -1) {
            throw new BGMessageException("\u042d\u0442\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0437\u0430\u043f\u0438\u0441\u044c.");
        }
        return nextId;
    }

    private void sendNotificationToUser(Topic topic, Message message, List<BGServerFile> files) throws Exception {
        TelegramNotification telegramNotification = new TelegramNotification();
        int userId = topic.getUserId();
        if (userId > 0) {
            User user = (User)new UserManager(this.getConnection()).get(userId);
            if (user != null) {
                EmailNotification.sendMessage(user.getConfigSetup().get("helpdesk.mail", null), topic, message.getBody());
                telegramNotification.sendMessage(user.getConfigSetup().get("telegram.user.id", null), user.getId(), topic, message, telegramNotification.getMessageText(topic, message, files, true));
            }
        } else {
            telegramNotification.sendMessage(topic, message, telegramNotification.getMessageText(topic, message, files, false));
        }
    }

    private void sendNotificationToAbonent(Topic topic, Message message) throws Exception {
        boolean notificationIsEnable;
        int commMode = topic.getComm();
        String commValue = topic.getCommValue();
        boolean bl = notificationIsEnable = commValue != null && commValue.trim().length() > 0;
        if (!notificationIsEnable) {
            return;
        }
        String msgTitle = plugin.getSetup().get("default.comm.email.subject", "HelpDesk => \u041e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u043d \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0412\u0430\u0448\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0432 \u0442\u0435\u043c\u0435: [{id}] {title}");
        msgTitle = msgTitle.replaceAll("\\{id\\}", String.valueOf(topic.getId()));
        msgTitle = msgTitle.replaceAll("\\{title\\}", topic.getTitle());
        if (commMode == 2) {
            String text = message.getBody();
            String url = plugin.getSetup().get("url.reference.topic", null);
            if (url != null && !url.equals("")) {
                StringBuilder sb = new StringBuilder();
                sb.append("ID: ");
                sb.append(topic.getId());
                sb.append("\n\u0422\u0435\u043c\u0430: ");
                sb.append(topic.getTitle());
                sb.append("\n\n");
                sb.append(message.getBody());
                sb.append("\n\n\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0442\u0435\u043c\u0443 \u0432 HelpDesk: ");
                sb.append(url);
                sb.append("action=HelpDeskAJAX&module=ru.bitel.bgbilling.plugins.helpdesk&mid=0&topicId=");
                sb.append(message.getTopicId());
                sb.append("&contractId=");
                sb.append(topic.getContractId());
                text = sb.toString();
            }
            new MailMsg((Preferences)this.getSetup()).sendMessage(new MailMessageNotification().setRecipients(commValue).setSubject(msgTitle).addTextPart("text", text));
        } else if (commMode == 4) {
            SendMessage sendMessage = new SendMessage();
            sendMessage.setText(msgTitle + "\n\n" + message.getBody());
            new TelegramNotification().sendMessage(commValue.trim(), 0, topic, message, sendMessage);
        }
        HelpDeskMessageForContractEvent event = new HelpDeskMessageForContractEvent(plugin.getPluginUID(), topic.getContractId(), this.userId);
        event.setTopicId(message.getTopicId());
        event.setMsgTitle(msgTitle);
        event.setMessageId(message.getId());
        event.setBody(message.getBody());
        EventProcessor.getInstance().request((QueueEvent)event);
    }

    private void setMessageAsOwnerOfTopicFiles(FileStorage fileStorage, Message message, List<BGServerFile> topicFiles) throws Exception {
        for (BGServerFile topicFile : topicFiles) {
            topicFile.setOwnerId(message.getId());
            fileStorage.updateFile(topicFile);
        }
    }

    public Topic topicGet(int contractId, int id, boolean loadMessages) throws Exception {
        Topic topic = this.getTopicManager().getTopic(id, loadMessages);
        if (topic == null) {
            return null;
        }
        if (contractId > 0 && topic.getContractId() != contractId) {
            return null;
        }
        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.getConnection());
        StringBuilder sb = new StringBuilder();
        if (topic.getMessages() != null) {
            for (Message message : topic.getMessages()) {
                message.setBody(HelpdeskServiceImpl.escapeXmlNotValid(sb, message.getBody()));
                message.setFileList(fileStorage.getFilesListByOwner(message.getId(), null));
            }
        }
        return topic;
    }

    private static String escapeXmlNotValid(StringBuilder buf, String value) {
        boolean was = false;
        buf.setLength(0);
        for (int j = 0; j < value.length(); ++j) {
            char ch = value.charAt(j);
            char ich = ch;
            if (ich >= ' ' && ich <= '\ud7ff' || ich == '\t' || ich == '\n' || ich == '\r' || ich >= '\ue000' && ich <= '\ufffd' || ich >= '\u10000' && ich <= '\u10ffff') {
                if (!was) continue;
                buf.append(ch);
                continue;
            }
            if (!was) {
                was = true;
                buf.append(value, 0, j);
            }
            buf.append("\\u");
            buf.append((int)ich);
        }
        if (!was) {
            return value;
        }
        return buf.toString();
    }

    public Result<Topic> topicList(int contractId, int id, Boolean history, Date dateFrom, Date dateTo, String title, String message, Page page) {
        TopicManager topicManager = this.getTopicManager();
        TopicListFilter filter = new TopicListFilter();
        filter.setContractId(contractId);
        filter.setTopicId(id);
        filter.setClosed(history);
        if (dateFrom != null || dateTo != null) {
            Period period = new Period(dateFrom, dateTo);
            filter.setPeriod(period);
        }
        filter.setTitle(title);
        filter.setMessage(message);
        filter.setPage(page);
        filter.setNewManagerMessage(true);
        List<Topic> list = topicManager.getTopicList(filter);
        Page.setRecordCount((Page)page, (int)topicManager.getTopicCount(filter));
        return new Result(list, page);
    }

    public MapHolder<IdTitle, List<IdTitle>> categoryMapForContract(int contractId) throws Exception {
        HelpDeskDirectoryManager manager = this.getHelpDeskDirectoryManager();
        int groupId = manager.getContractGroupId(contractId);
        HashMap<IdTitle, List<IdTitle>> result = new HashMap<IdTitle, List<IdTitle>>();
        Map<Integer, List<Integer>> map = manager.getSubCategoryIds(groupId);
        for (Map.Entry<Integer, List<Integer>> entry : map.entrySet()) {
            int idCategory = entry.getKey();
            List<IdTitle> subList = manager.getSubcategory((Collection<Integer>)entry.getValue());
            subList.sort(Comparator.comparing(IdTitle::getTitle));
            result.put(new IdTitle(idCategory, manager.getCategoryTitle(idCategory)), subList);
        }
        return new MapHolder(result);
    }

    public void topicMarkReadByCustomer(int contractId, int topicId) throws Exception {
        Topic topic = this.getTopicManager().getTopic(topicId);
        if (topic == null || topic.getContractId() != contractId) {
            throw new BGIllegalArgumentException();
        }
        this.getTopicManager().setTopicClientRead(topicId);
    }

    public void topicUpdateState(int contractId, int id, boolean stateClosed) throws Exception {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        Topic topic = topicManager.getTopic(id);
        if (topic.getContractId() != contractId) {
            throw new BGIllegalArgumentException();
        }
        int stateMode = plugin.getSetup().getInt("state.mode", 1);
        ParamManager paramManager = new ParamManager(this.getConnection(), plugin);
        Properties properties = paramManager.getProperties(contractId);
        String currentId = properties.getProperty("mode.id", plugin.getSetup().get("mode.default.id", "on"));
        boolean packetMode = currentId.equals("package");
        if (topic.getStatus() <= 0 && stateClosed && (stateMode == 1 || currentId.equals("package"))) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0442\u0435\u043c\u0443, \u0443 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441!", "state.close.noStatus");
        }
        if (topic.isClosed() == stateClosed) {
            throw new BGMessageException("\u0422\u0435\u043c\u0430 \u0443\u0436\u0435 " + (stateClosed ? "\u0437\u0430\u043a\u0440\u044b\u0442\u0430" : "\u043e\u0442\u043a\u0440\u044b\u0442\u0430"), stateClosed ? "state.close.already" : "state.open.already");
        }
        topicManager.setTopicClosed(id, stateClosed, packetMode, this.userId);
    }

    public int[] topicCreate(Topic topic, Message message) throws Exception {
        if (topic.getId() > 0) {
            throw new BGIllegalArgumentException();
        }
        int contractId = topic.getContractId();
        if (Utils.isBlankString((String)topic.getTitle())) {
            throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0442\u0435\u043c\u0443 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044f.", "topic.title.empty");
        }
        if (Utils.isBlankString((String)message.getBody())) {
            throw new BGMessageException("C\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.", "message.empty");
        }
        MapHolder<IdTitle, List<IdTitle>> categoryMap = this.categoryMapForContract(contractId);
        if (categoryMap.getMap() == null || categoryMap.getMap().size() == 0) {
            if (topic.getCategoryId() > 0) {
                throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f/\u043f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f");
            }
        } else {
            if (topic.getCategoryId() <= 0) {
                throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f/\u043f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f");
            }
            List subCategoryList = (List)categoryMap.getMap().get(new IdTitle(topic.getCategoryId(), ""));
            if (subCategoryList == null) {
                throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f/\u043f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f");
            }
            if (subCategoryList.size() == 0 ? topic.getCategoryId() > 0 : !subCategoryList.contains(new IdTitle(topic.getSubcategoryId(), ""))) {
                throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f/\u043f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f");
            }
        }
        String packageMode = this.getContractCurrentMode(contractId);
        PackageManager packageManager = new PackageManager(this.getConnection(), plugin);
        boolean packageEnabled = "package".equals(packageMode);
        if (packageEnabled && !packageManager.hasActivePackage(contractId)) {
            throw new BGMessageException("\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.", "package.activeNotFound");
        }
        BigDecimal cost = plugin.getSetup().getBigDecimal("topic.default.cost." + contractId, null);
        if (cost == null) {
            cost = plugin.getSetup().getBigDecimal("topic.default.cost", new BigDecimal("0.00"));
        }
        topic.setCost(cost);
        topic.setAutoClose(plugin.getSetup().getBoolean("topic.avto.closed.default", false));
        topic.setClosed(false);
        topic.setDate(new Date());
        TopicWillBeCreated event = new TopicWillBeCreated(topic, 2, plugin.getPluginUID(), message.getBody());
        if (!event.isAllowCreate()) {
            throw new BGMessageException(event.getErrorMessage() != null ? event.getErrorMessage() : "\u0421\u043a\u0440\u0438\u043f\u0442 \u043d\u0435 \u0434\u0430\u0435\u0442 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0442\u0435\u043c\u0443");
        }
        this.getTopicManager().updateTopic(topic);
        while (packageEnabled) {
            PackageContract pkg = packageManager.getActivePackageContract(contractId);
            if (pkg == null) {
                throw new BGMessageException("\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.", "package.activeNotFound");
            }
            if (packageManager.updatePackageContractCount(pkg.getId(), pkg.getCountUse(), 1) != 1) continue;
            this.getTopicManager().updateTopicPackage(topic.getId(), pkg.getId());
            break;
        }
        message.setTopicId(topic.getId());
        message.setDateFrom(new Date());
        this.messageUpdate(message);
        return new int[]{topic.getId(), message.getId()};
    }

    public int messageNewCount() throws Exception, BGMessageException {
        return new TopicManager(this.getConnection(), plugin).getClientNewMessageCount();
    }

    public SearchResult<Topic> topicSearch(int topicId, String title, String message, int status, String userSelect, boolean onlynew, boolean closed, Period period, Page page) throws Exception, BGMessageException {
        SearchResult searchResult = new SearchResult(period, page);
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        TopicListFilter topicListFilter = new TopicListFilter();
        topicListFilter.setContractId(-1);
        topicListFilter.setClosed(closed);
        topicListFilter.setPeriod(period);
        topicListFilter.setTitle(title);
        topicListFilter.setPage(page);
        topicListFilter.setOnlyNew(onlynew);
        topicListFilter.setUserselect(userSelect);
        topicListFilter.setUserId(this.userId);
        topicListFilter.setTopicId(topicId);
        topicListFilter.setMessage(message);
        topicListFilter.setStatus(status);
        searchResult.getList().addAll(topicManager.getTopicList(topicListFilter));
        Page.setRecordCount((Page)page, (int)topicManager.getTopicCount(topicListFilter));
        return searchResult;
    }

    public List<IdTitle> topicStatusList() throws Exception, BGMessageException {
        ArrayList<IdTitle> statusList = new ArrayList<IdTitle>();
        statusList.add(new IdTitle(0, "\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d"));
        String query = "SELECT id, title FROM helpdesk_topic_statuses_" + plugin.getPluginUID() + " ORDER BY title";
        try (Statement st = this.getConnection().createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                statusList.add(new IdTitle(rs.getInt(1), rs.getString(2)));
            }
        }
        return statusList;
    }

    public SearchResult<IdTitle> categoryList(Page page) throws Exception, BGMessageException {
        SearchResult searchResult = new SearchResult(page);
        this.getHelpDeskDirectoryManager().getCategoryList((SearchResult<IdTitle>)searchResult);
        return searchResult;
    }

    public void categoryUpdate(int categoryId, String title) throws Exception, BGMessageException {
        this.getHelpDeskDirectoryManager().updateCategoryTitle(new IdTitle(categoryId, title));
    }

    public void categoryDelete(int categoryId) throws Exception, BGMessageException {
        int countCategory = this.getHelpDeskDirectoryManager().inspectionCategory(categoryId);
        if (countCategory > 0) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e. \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0435\u043c \u0441 \u0442\u0430\u043a\u043e\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0435\u0439 " + countCategory + ". \u0418\u0437\u043c\u0435\u043d\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u043f\u0435\u0440\u0435\u0434 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u043c.");
        }
        this.getHelpDeskDirectoryManager().deleteCategeryTitle(categoryId);
    }

    public List<IdTitle> categoryGroupList() throws Exception, BGMessageException {
        SearchResult searchResultGroup = new SearchResult();
        this.getHelpDeskDirectoryManager().getGroupList((SearchResult<IdTitle>)searchResultGroup);
        return searchResultGroup.getList();
    }

    public HelpDeskLinks categoryGroupLinks(int groupId) throws Exception, BGMessageException {
        HelpDeskDirectoryManager manager = this.getHelpDeskDirectoryManager();
        SearchResult searchResultGroup = new SearchResult();
        manager.getGroupList((SearchResult<IdTitle>)searchResultGroup);
        if (groupId == -1 && searchResultGroup.getList().size() > 0) {
            groupId = ((IdTitle)searchResultGroup.getList().get(0)).getId();
        }
        SearchResult searchResultSelectCategory = new SearchResult();
        SearchResult searchResultAvailableCategory = new SearchResult();
        manager.getCategoryListSelectAndAvailable((SearchResult<IdTitle>)searchResultSelectCategory, (SearchResult<IdTitle>)searchResultAvailableCategory, groupId);
        return new HelpDeskLinks().setGroupList(searchResultGroup.getList()).setSelectCategoryList(searchResultSelectCategory.getList()).setAvailableCategoryList(searchResultAvailableCategory.getList());
    }

    public void categoryToGroupAdd(int groupId, List<Integer> categoryIds) throws Exception, BGMessageException {
        HelpDeskDirectoryManager manager = this.getHelpDeskDirectoryManager();
        for (int categoryId : categoryIds) {
            manager.addCategoryToGroup(groupId, categoryId);
        }
    }

    public void categoryToGroupDelete(int groupId, List<Integer> categoryIds) throws Exception, BGMessageException {
        HelpDeskDirectoryManager manager = this.getHelpDeskDirectoryManager();
        for (int categoryId : categoryIds) {
            manager.deleteCategoryToGroup(groupId, categoryId);
        }
    }

    public SearchResult<IdTitle> subcategoryList(Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        this.getHelpDeskDirectoryManager().getSubCategoryList((SearchResult<IdTitle>)searchResult);
        return searchResult;
    }

    public void subcategoryUpdate(int subCategoryId, String title) throws Exception {
        this.getHelpDeskDirectoryManager().updateSubCategoryTitle(new IdTitle(subCategoryId, title));
    }

    public void subcategoryDelete(int subcategoryId) throws Exception, BGMessageException {
        int countSubcategory = this.getHelpDeskDirectoryManager().inspectionSubcategory(subcategoryId);
        if (countSubcategory > 0) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e. \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0435\u043c \u0441 \u0442\u0430\u043a\u043e\u0439 \u043f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0435\u0439 " + countSubcategory + ". \u0418\u0437\u043c\u0435\u043d\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u043f\u0435\u0440\u0435\u0434 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u043c.");
        }
        this.getHelpDeskDirectoryManager().deleteSubCategeryTitle(subcategoryId);
    }

    public List<String> categorySubcategoryIdsForGroup(int contractId) throws Exception, BGMessageException {
        ArrayList<String> list = new ArrayList<String>();
        HelpDeskDirectoryManager manager = this.getHelpDeskDirectoryManager();
        manager.getSubCategoryIds(manager.getContractGroupId(contractId)).forEach((a, b) -> list.add(a + "," + Utils.toString((Iterable)b)));
        return list;
    }

    public List<IdTitle> managerList() throws Exception, BGMessageException {
        ArrayList<IdTitle> managers = new ArrayList<IdTitle>();
        UserMap.getMap().values().forEach(a -> managers.add(new IdTitle(a.getId(), a.getName() + " [" + a.getLogin() + "]")));
        Collections.sort(managers, new Comparator<IdTitle>(this){

            @Override
            public int compare(IdTitle o1, IdTitle o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        });
        return managers;
    }

    public List<ChangeManager> topicManagerChangeList(int topicId) throws Exception, BGMessageException {
        return new ManagerChangeManager(this.getConnection(), plugin).getListOfChange(topicId);
    }

    public void topicManagerChange(int topicId, int managerId, String comment) throws Exception, BGMessageException {
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        topicManager.setBindTopic(topicId, managerId, comment);
        User user = (User)new UserManager(this.getConnection()).get(managerId);
        if (user != null) {
            Topic topic = topicManager.getTopic(topicId);
            String email = user.getConfigSetup().get("helpdesk.mail", null);
            String text = topic.getMessages() != null && topic.getMessages().size() > 0 ? ((Message)topic.getMessages().get(0)).getBody() : "";
            EmailNotification.sendMessage(email, topic, "HelpDesk => \u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0430 \u0442\u0435\u043c\u0430: [{id}] {title}", text);
        }
    }

    public void topicCategorySubcategoryUpdate(int topicId, int categoryId, int subcategoryId) throws Exception, BGMessageException {
        if (categoryId > -1 && subcategoryId > -1 && topicId > -1) {
            this.getHelpDeskDirectoryManager().setCategorySubcategory(categoryId, subcategoryId, topicId);
        }
    }

    public void topicStatusUpdate(int topicId, int status) throws Exception, BGMessageException {
        new TopicManager(this.getConnection(), plugin).setTopicStatus(topicId, status);
    }

    public void topicStateUpdate(int topicId, boolean state, boolean packageMode) throws Exception, BGMessageException {
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        Topic topic = topicManager.getTopic(topicId);
        int stateMode = plugin.getSetup().getInt("state.mode", 1);
        ParamManager paramManager = new ParamManager(this.getConnection(), plugin);
        Properties properties = paramManager.getProperties(topic.getContractId());
        String currentId = properties.getProperty("mode.id", plugin.getSetup().get("mode.default.id", "on"));
        if (topic.getStatus() <= 0 && state && (stateMode == 1 || currentId.equals("package"))) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0442\u0435\u043c\u0443, \u0443 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441!");
        }
        if (topic.isClosed() == state) {
            throw new BGMessageException("\u0422\u0435\u043c\u0430 \u0443\u0436\u0435 " + (state ? "\u0437\u0430\u043a\u0440\u044b\u0442\u0430" : "\u043e\u0442\u043a\u0440\u044b\u0442\u0430"));
        }
        topicManager.setTopicClosed(topicId, state, packageMode, this.userId);
    }

    public void topicBindSet(int topicId, String userId) throws Exception, BGMessageException {
        new TopicManager(this.getConnection(), plugin).setBindTopic(topicId, "me".equals(userId) ? this.userId : Utils.parseInt((String)userId, (int)-1), null);
    }

    public void topicAutocloseUpdate(int topicId, boolean autoclose) throws Exception, BGMessageException {
        new TopicManager(this.getConnection(), plugin).setTopicAutoclose(topicId, autoclose);
    }

    public void messageCommentUpdate(int messageId, String comment) throws Exception, BGMessageException {
        new TopicManager(this.getConnection(), plugin).updateMessageComment(messageId, comment);
    }

    public void messageAdminReadSet(int messageId) throws Exception, BGMessageException {
        new TopicManager(this.getConnection(), plugin).setMessageAdminRead(messageId, this.userId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void topicPackageStateSet(int contractId, int topicId, Boolean include) throws Exception, BGMessageException {
        String mode = this.getMode(contractId);
        if (!"package".equals(mode)) {
            throw new BGMessageException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u043d\u0435\u043f\u0430\u043a\u0435\u0442\u043d\u043e\u043c \u0440\u0435\u0436\u0438\u043c\u0435.");
        }
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        Topic topic = topicManager.getTopic(topicId);
        if (topic == null || topic.getContractId() != contractId) return;
        PackageManager packageManager = new PackageManager(this.getConnection(), plugin);
        if (include.booleanValue() && topic.getContractPackageId() < 1) {
            PackageContract packageContract = packageManager.getActivePackageContract(contractId);
            if (packageContract == null) throw new BGMessageException("\u041d\u0435\u0442 \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0439 \u0432 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u0430\u0445");
            int updateRows = packageManager.updatePackageContractCount(packageContract.getId(), packageContract.getCountUse(), 1);
            if (updateRows <= 0) return;
            topicManager.updateTopicPackage(topicId, packageContract.getId());
            return;
        } else {
            if (include.booleanValue() || topic.getContractPackageId() <= 0) return;
            PackageContract packageContract = packageManager.getPackageContract(topic.getContractPackageId());
            if (packageContract != null) {
                int updateRows = packageManager.updatePackageContractCount(packageContract.getId(), packageContract.getCountUse(), -1);
                if (updateRows <= 0) return;
                topicManager.updateTopicPackage(topicId, -1);
                return;
            } else {
                topicManager.updateTopicPackage(topicId, -1);
            }
        }
    }

    public ContractModeDTO contractModeGet(int contractId) throws Exception, BGMessageException {
        ParamManager paramManager = new ParamManager(this.getConnection(), plugin);
        ContractModeDTO contractModeDTO = new ContractModeDTO();
        contractModeDTO.getModeList().addAll(paramManager.getModeList());
        contractModeDTO.setCurrentMode(paramManager.getContractCurrentMode(contractId));
        return contractModeDTO;
    }

    public void contractModeUpdate(int contractId, String currentModeId) throws Exception, BGMessageException {
        ParamManager paramManager = new ParamManager(this.getConnection(), plugin);
        Properties properties = paramManager.getProperties(contractId);
        properties.setProperty("mode.id", currentModeId != null ? currentModeId : properties.getProperty("mode.id", plugin.getSetup().get("mode.default.id", "off")));
        paramManager.setProperties(contractId, properties);
    }

    public void contractGroupUpdate(int contractId, int groupId) throws Exception {
        new HelpDeskDirectoryManager(this.getConnection(), plugin).updateContractGroup(contractId, groupId);
    }

    public MapHolder<String, String> getParams(int contractId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        ParamManager paramManager = new ParamManager(this.getConnection(), BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk"));
        Properties properties = paramManager.getProperties(contractId);
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return new MapHolder(map);
    }

    public void setParams(int contractId, MapHolder<String, String> _params) throws Exception {
        String trueStr = "true";
        Map params = _params.getMap();
        int mode = Utils.parseInt((String)((String)params.get("comm.mode")), (int)0);
        if (!"true".equals(plugin.getSetup().get("default.comm.telegram.enable", "true"))) {
            params.remove("comm.telegram.value");
            if (mode == 4) {
                mode = 0;
            }
        }
        if (!"true".equals(plugin.getSetup().get("default.comm.phone.enable", "true"))) {
            params.remove("comm.phone.value");
            if (mode == 1) {
                mode = 0;
            }
        }
        if (!"true".equals(plugin.getSetup().get("default.comm.email.enable", "true"))) {
            params.remove("comm.email.value");
            if (mode == 2) {
                mode = 0;
            }
        }
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                mode = 0;
            }
        }
        params.put("comm.mode", String.valueOf(mode));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)params);
        this.getParamManager().setProperties(contractId, properties);
    }

    public List<KeyValue> getModeList() throws Exception {
        return this.getParamManager().getModeList();
    }

    public String getContractCurrentMode(int contractId) throws Exception {
        return this.getParamManager().getContractCurrentMode(contractId);
    }

    public SearchResult<IdTitle> groupList(boolean groupForDirectory, int contractId, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        HelpDeskDirectoryManager groupManager = this.getHelpDeskDirectoryManager();
        groupManager.getGroupList((SearchResult<IdTitle>)searchResult);
        if (!groupForDirectory && contractId > 0) {
            int selectGroupId = -2;
            if (groupManager.hasContractGroup(contractId)) {
                selectGroupId = groupManager.getContractGroupId(contractId);
            }
            searchResult.setAttribute("selectGroupId", String.valueOf(selectGroupId));
        }
        return searchResult;
    }

    public void groupUpdate(int groupId, String title) throws Exception {
        this.getHelpDeskDirectoryManager().updateGroupTitle(new IdTitle(groupId, title));
    }

    public Message messageGet(int contractId, int topicId, int messageId) throws Exception {
        Message message = null;
        if (topicId > 0 && messageId > 0) {
            TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
            Topic topic = topicManager.getTopic(topicId, false);
            message = topicManager.getMessage(messageId);
            if (topic != null && message != null) {
                if (topic.getId() != message.getTopicId()) {
                    message = null;
                } else {
                    message.setFileList(new HelpdeskFileStorage(this.getConnection()).getFilesListByOwner(message.getId()));
                }
            } else {
                message = null;
            }
        }
        return message;
    }

    public SearchResult<Message> searchTopicMessages(int contractId, int topicId, String[] sort, Page page) throws Exception {
        TopicManager topicManager = new TopicManager(this.getConnection(), plugin);
        Topic topic = topicManager.getTopic(topicId, false);
        if (topic.getContractId() != contractId) {
            topic = null;
        }
        SearchResult searchResult = null;
        if (topic != null) {
            if (page == null) {
                page = new Page(1, Integer.MAX_VALUE);
            }
            searchResult = new SearchResult(page, sort);
            topicManager.searchTopicMessages((SearchResult<Message>)searchResult, topicId);
        }
        return searchResult;
    }

    public List<FileInfo> getMessageFileList(int messageId) throws Exception {
        ArrayList<FileInfo> list = new ArrayList<FileInfo>();
        List messageFileList = new HelpdeskFileStorage(this.getConnection()).getFilesListByOwner(messageId);
        for (BGServerFile messageFile : messageFileList) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setId(messageFile.getId());
            fileInfo.setTitle(messageFile.getTitle());
            fileInfo.setSize(new BigDecimal(messageFile.getSize()));
            list.add(fileInfo);
        }
        return list;
    }

    private ParamManager getParamManager() {
        return new ParamManager(this.getConnection(), BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk"));
    }

    private String getMode(int contractId) throws Exception {
        ParamManager paramManager = new ParamManager(this.getConnection(), plugin);
        Properties properties = paramManager.getProperties(contractId);
        return properties.getProperty("mode.id", plugin.getSetup().get("mode.default.id", "on"));
    }

    public void subcategoryToCategoryAdd(int groupId, Set<Integer> categoriesIds, Set<Integer> subCategoriesIds) throws Exception, BGMessageException {
        HelpDeskDirectoryManager manager = this.getHelpDeskDirectoryManager();
        for (Integer categoryId : categoriesIds) {
            for (Integer subCategoryId : subCategoriesIds) {
                manager.addSubcategoryToCategory(groupId, categoryId, subCategoryId);
            }
        }
    }

    public void subcategoryToCategoryDelete(int groupId, Set<Integer> categoriesIds, Set<Integer> subCategoriesIds) throws Exception, BGMessageException {
        HelpDeskDirectoryManager manager = this.getHelpDeskDirectoryManager();
        for (Integer categoryId : categoriesIds) {
            for (Integer subCategoryId : subCategoriesIds) {
                manager.deleteSubcategoryToCategory(groupId, categoryId, subCategoryId);
            }
        }
    }

    public SearchResult<Package> packageList(Boolean status, Page page) throws Exception, BGMessageException {
        SearchResult searchResult = new SearchResult(page);
        new PackageManager(this.getConnection(), plugin).findPackageList((SearchResult<Package>)searchResult, status);
        return searchResult;
    }
}

