/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeSpec;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;

public class TrafficRangeSpecDao
extends AbstractDirectoryIdDao<TrafficRangeSpec> {
    public TrafficRangeSpecDao(Connection con, int moduleId) {
        super(con, moduleId, "inet_tariff_traffic_range_spec");
    }

    protected TrafficRangeSpec getFromRS(ResultSet rs) throws SQLException, BGException {
        TrafficRangeSpec result = new TrafficRangeSpec();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setTitleForCustomer(rs.getString("titleForCustomer"));
        result.setMode(rs.getInt("mode"));
        result.setType(rs.getInt("type"));
        result.setTariffOptionId(rs.getInt("tariffOptionId"));
        result.setMaxAmount(rs.getLong("maxAmount"));
        result.setMaxAmountType(rs.getInt("maxAmountType"));
        result.setTariffOptionDeactivate(rs.getBoolean("tariffOptionDeactivate"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    protected void updateImpl(TrafficRangeSpec b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, titleForCustomer, mode, type, tariffOptionId, maxAmount, maxAmountType, tariffOptionDeactivate, comment) VALUES (?,?,?,?,?,?,?,?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, titleForCustomer=?, mode=?, type=?, tariffOptionId=?, maxAmount=?, maxAmountType=?, tariffOptionDeactivate=?, comment=? WHERE id=?");
            ps.setInt(10, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.setString(2, b.getTitleForCustomer());
        ps.setInt(3, b.getMode());
        ps.setInt(4, b.getType());
        ps.setInt(5, b.getTariffOptionId());
        ps.setLong(6, b.getMaxAmount());
        ps.setInt(7, b.getMaxAmountType());
        ps.setBoolean(8, b.isTariffOptionDeactivate());
        ps.setString(9, b.getComment());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
    }

    public TrafficRangeSpec get(String title) throws BGException {
        return (TrafficRangeSpec)this.get("title=?", new Object[]{title});
    }

    public List<TrafficRangeSpec> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    public int delete(int id) throws Exception {
        String query = "SELECT contractId FROM inet_tariff_traffic_range_" + this.moduleId + " WHERE treeNodeId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d, \u0442.\u043a. \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438", "trafficRangeSpec.deleteError.dataExists");
                }
            }
        }
        return super.delete(id);
    }
}

