/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.io;

import java.nio.ByteBuffer;

public class ByteBufferFactory {
    public static int defaultCapacity = 4000000;
    private final boolean direct;
    private final int capacity;
    private ByteBuffer byteBuffer;
    private static final ByteBufferFactory instance = new ByteBufferFactory(true);

    public ByteBufferFactory(boolean direct) {
        this(defaultCapacity, direct);
    }

    public ByteBufferFactory(int capacity, boolean direct) {
        this.capacity = capacity;
        this.direct = direct;
    }

    public ByteBuffer allocateView(int size) {
        if (this.byteBuffer == null || this.byteBuffer.capacity() - this.byteBuffer.limit() < size) {
            this.byteBuffer = this.direct ? ByteBuffer.allocateDirect(this.capacity) : ByteBuffer.allocate(this.capacity);
        }
        this.byteBuffer.limit(this.byteBuffer.position() + size);
        ByteBuffer view = this.byteBuffer.slice();
        this.byteBuffer.position(this.byteBuffer.limit());
        return view;
    }

    public synchronized ByteBuffer allocateViewSync(int size) {
        if (this.byteBuffer == null || this.byteBuffer.capacity() - this.byteBuffer.limit() < size) {
            this.byteBuffer = this.direct ? ByteBuffer.allocateDirect(this.capacity) : ByteBuffer.allocate(this.capacity);
        }
        this.byteBuffer.limit(this.byteBuffer.position() + size);
        ByteBuffer view = this.byteBuffer.slice();
        this.byteBuffer.position(this.byteBuffer.limit());
        return view;
    }

    public ByteBufferFactory getInstance() {
        return instance;
    }
}

