/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;

public class ActionFindQueryLog
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        int userId = this.getIntParameter("userId", -1);
        Date date1 = this.getDateParameter("date1", null);
        Date date2 = this.getDateParameter("date2", null);
        GregorianCalendar cal1 = new GregorianCalendar();
        if (date1 != null) {
            cal1.setTime(date1);
        }
        int mm = cal1.get(2) + 1;
        int yy = cal1.get(1);
        String actionList = this.getParameter("actionList", null);
        String cidList = this.getParameter("contractList", null);
        Page page = this.getPage();
        StringBuffer buf = new StringBuffer();
        HashMap<String, ArrayList<Element>> contractElement = new HashMap<String, ArrayList<Element>>();
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        String tableName = "query_log_" + yy + (mm < 10 ? "0" : "") + mm;
        StringBuffer query = new StringBuffer();
        query.append("SELECT SQL_CALC_FOUND_ROWS t2.name, t1.ip, t1.dt, t1.query, t1.cid, ");
        query.append("concat( t1.module, ' + ', t1.action ) FROM ");
        query.append(tableName);
        query.append(" AS t1, user AS t2");
        if (actionList != null && actionList.length() > 0) {
            query.append(", user_module_action AS t3 ");
            query.append("WHERE t1.action=t3.action AND t1.module=t3.module AND");
        } else {
            query.append(" WHERE");
        }
        query.append(" t1.user=t2.id");
        this.buildWhereString(userId, actionList, cidList, query);
        query.append(" ORDER BY t1.dt" + Page.toSqlLimit((Page)page));
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date1));
        ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date2));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String cid = rs.getString(5);
            String queryStr = rs.getString(4);
            StringBuffer buf1 = new StringBuffer();
            if (queryStr != null) {
                StringTokenizer st = new StringTokenizer(queryStr, "\n");
                while (st.hasMoreTokens()) {
                    buf1.append(st.nextToken());
                    if (!st.hasMoreTokens()) continue;
                    buf1.append("; ");
                }
            }
            Element element = this.createElement(data, "row");
            element.setAttribute("f0", buf1.toString());
            element.setAttribute("f1", rs.getString(3));
            element.setAttribute("f2", rs.getString(1));
            element.setAttribute("f3", rs.getString(2));
            element.setAttribute("f4", cid);
            element.setAttribute("f5", rs.getString(6));
            if (rs.getInt(5) <= 0) continue;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(cid);
            ArrayList<Element> list = (ArrayList<Element>)contractElement.get(cid);
            if (list == null) {
                list = new ArrayList<Element>();
                contractElement.put(cid, list);
            }
            list.add(element);
        }
        rs.close();
        ps.close();
        Page.setRecordCount((Page)page, (int)ServerUtils.foundRows(this.con));
        this.setPageAttribute(table, page);
        table.setAttribute("allRecord", String.valueOf(page.getRecordCount()));
        if (buf.length() > 0) {
            query = new StringBuffer();
            query.append("SELECT id, title FROM contract WHERE id IN ( ");
            query.append(buf.toString());
            query.append(" )");
            ps = this.con.prepareStatement(query.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                String contractTitle = rs.getString(2);
                List list = (List)contractElement.get(rs.getString(1));
                for (Element element : list) {
                    element.setAttribute("f4", contractTitle);
                }
            }
            rs.close();
            ps.close();
        }
    }

    private void buildWhereString(int userId, String actionList, String cidList, StringBuffer query) {
        if (userId > -1) {
            query.append(" AND t1.user=");
            query.append(userId);
        }
        if (cidList != null && cidList.length() > 0) {
            query.append(" AND t1.cid IN ( ");
            query.append(cidList);
            query.append(" )");
        }
        if (actionList != null && actionList.length() > 0) {
            query.append(" AND t3.id IN ( ");
            query.append(actionList);
            query.append(" )");
        }
        query.append(" AND t1.dt>=? AND t1.dt<DATE_ADD( ?, INTERVAL 1 DAY )");
    }
}

