/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.server;

import bitel.billing.server.contract.bean.ContractParameterManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccount;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccountProduct;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccountStatus;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoPhone;
import ru.bitel.bgbilling.modules.mangooffice.server.bean.MangoAccountDao;
import ru.bitel.bgbilling.modules.mangooffice.server.bean.MangoAccountProductDao;
import ru.bitel.bgbilling.modules.mangooffice.server.bean.MangoPhoneDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.server.bean.CityDao;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;

public class MangoApi
extends BGLogger {
    private static final Object mutexTokenRequest = new Object();
    private int userId;
    private int mid;
    private Connection con;
    private ModuleSetup moduleSetup = null;
    private String apiDomen = null;
    private static String jwtKey = null;

    public MangoApi(int mid, int userId, Connection con) throws BGException {
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(mid));
        this.con = con;
        this.userId = userId;
        this.mid = mid;
        this.apiDomen = this.getStringParam("apiDomenMango");
    }

    public MangoAccount createAccount(int contractId) throws Exception {
        MangoAccountDao accountDao = new MangoAccountDao(this.con, this.mid);
        MangoAccount account = accountDao.getByContractId(contractId);
        if (account != null) {
            throw new BGMessageException("\u0423 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 Mango!");
        }
        Contract contract = ContractDao.getContract((Connection)this.con, (int)contractId);
        if (contract == null) {
            throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
        }
        this.requestToken();
        account = contract.getPersonType() == 0 ? this.createIndividualAccountRequest(contractId) : this.createUrikAccountRequest(contractId);
        MangoAccount duplicate = accountDao.getByAccountId(account.getAccountId());
        if (duplicate != null) {
            this.getLogger().error("Duplicate accountId From Mango - " + String.valueOf(account) + " conflicts with current - " + String.valueOf(duplicate));
            throw new BGMessageException("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043d\u0435 \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 accountId \u043e\u0442 Mango!  " + String.valueOf(account));
        }
        accountDao.update(account);
        return account;
    }

    public MangoAccount bindAccount(int contractId, int accountId) throws Exception {
        MangoAccountDao accountDao = new MangoAccountDao(this.con, this.mid);
        MangoAccount account = accountDao.getByContractId(contractId);
        if (account != null) {
            throw new BGMessageException("\u0423 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 Mango!");
        }
        account = accountDao.getByAccountId(accountId);
        if (account != null) {
            throw new BGMessageException("\u0414\u0430\u043d\u043d\u044b\u0439 accountId \u0443\u0436\u0435 \u0437\u0430\u043d\u044f\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c cid=" + account.getContractId());
        }
        Contract contract = ContractDao.getContract((Connection)this.con, (int)contractId);
        if (contract == null) {
            throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
        }
        this.requestToken();
        String urlStr = this.apiDomen + "/mango_billing_ext_api/api/account/" + accountId;
        HttpGet httpGet = new HttpGet(urlStr);
        httpGet.addHeader("Host", this.apiDomen.replaceFirst("http://", "").replaceFirst("https://", ""));
        httpGet.addHeader("Authorization", "Bearer " + jwtKey);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        int responseCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String answer = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
        this.getLogger().info("Answer: " + answer);
        if (responseCode / 100 == 2) {
            if (entity == null) {
                throw new BGException("Http Entity is null");
            }
            JSONObject data = new JSONObject(answer);
            String control = data.getString("control");
            String password = data.getString("password");
            account = new MangoAccount(contractId, accountId, control, password);
            accountDao.update(account);
            return account;
        }
        this.getLogger().error("Create Account response http code = " + responseCode + " Answer: " + answer);
        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0432\u044f\u0437\u044b\u0432\u0430\u043d\u0438\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430! http code = " + responseCode + this.parseErrorAnswer(responseCode, answer));
    }

    private boolean tokenIsValid(String jwtSigned) {
        if (Utils.isBlankString((String)jwtSigned)) {
            return false;
        }
        String[] jwtSplit = jwtSigned.split("\\.");
        try {
            String jwt = jwtSplit[0] + "." + jwtSplit[1] + ".";
            Date expDate = ((Claims)Jwts.parser().parseClaimsJwt(jwt).getBody()).getExpiration();
            this.getLogger().info("Token valid to - " + TimeUtils.format((Date)expDate, (String)"dd.MM.yyyy HH:mm:ss"));
        }
        catch (ExpiredJwtException ex) {
            if (ex.getClaims() != null) {
                this.getLogger().info("Expired token - " + TimeUtils.format((Date)ex.getClaims().getExpiration(), (String)"dd.MM.yyyy HH:mm:ss"));
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MangoAccount createUrikAccountRequest(int contractId) throws BGException {
        String urlStr = this.apiDomen + "/mango_billing_ext_api/api/account";
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);
             ContractParameterManager cpManager = new ContractParameterManager(this.con);
             HouseDao houseDao = new HouseDao(this.con);
             CityDao cityDao = new CityDao(this.con);){
            String answer;
            EntityAttrAddress actualAddress;
            House invoiceHouse;
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.putData(map, cpManager, contractId, "u.personName", "personName", "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435", 100);
            this.putData(map, cpManager, contractId, "u.legalName", "legalName", "\u041e\u0444\u0438\u0446.\u043d\u0430\u0438\u043c-\u0435 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435", 200);
            this.putData(map, cpManager, contractId, "u.inn", "inn", "\u0418\u043d\u043d", 14);
            this.putData(map, cpManager, contractId, "u.contactName", "contactName", "\u041b\u0438\u0446\u043e(\u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a \u0444\u0438\u0440\u043c\u044b-\u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430) \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435", 100);
            this.putData(map, cpManager, contractId, "u.contactPhone", "contactPhone", "\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435", 50);
            EntityAttrAddress legalAddress = contractDao.getContractParameterAddress(contractId, this.getIntParam("u.legalAddress")).orElse(null);
            EntityAttrAddress invoiceAddress = contractDao.getContractParameterAddress(contractId, this.getIntParam("u.invoiceAddress")).orElse(null);
            String email = this.getEmail(contractId, this.getIntParam("u.email"), cpManager, contractDao);
            if (legalAddress == null) throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u042e\u0440. \u0430\u0434\u0440\u0435\u0441 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435");
            if (Utils.isBlankString((String)legalAddress.getTitle())) {
                throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u042e\u0440. \u0430\u0434\u0440\u0435\u0441 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435");
            }
            if (invoiceAddress == null) throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0410\u0434\u0440\u0435\u0441 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0447\u0435\u0442\u0430 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435");
            if (Utils.isBlankString((String)invoiceAddress.getTitle())) {
                throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0410\u0434\u0440\u0435\u0441 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0447\u0435\u0442\u0430 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435");
            }
            if (Utils.isBlankString((String)email)) {
                throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d email \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435");
            }
            if (legalAddress.getTitle().length() > 256) {
                throw new BGMessageException("\u042e\u0440 \u0430\u0434\u0440\u0435\u0441 > 256 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            }
            if (invoiceAddress.getTitle().length() > 256) {
                throw new BGMessageException("\u0410\u0434\u0440\u0435\u0441 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0447\u0435\u0442\u0430 > 256 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            }
            map.put("creditLimit", this.getIntParam("u.creditLimit"));
            map.put("legalAddressAddress", legalAddress.getTitle());
            map.put("invoiceAddressAddress", invoiceAddress.getTitle());
            map.put("email", email);
            this.putDataIfHave(map, cpManager, contractId, "u.kpp", "kpp", "\u041a\u043f\u043f", 25);
            this.putDataIfHave(map, cpManager, contractId, "u.ogrn", "ogrn", "\u041e\u0433\u0440\u043d", 15);
            this.putDataIfHave(map, cpManager, contractId, "u.directorTitle", "directorTitle", "\u0418\u043c\u044f \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f", 50);
            this.putDataIfHave(map, cpManager, contractId, "u.directorTitleGenitive", "directorTitleGenitive", "\u0418\u043c\u044f \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f \u0432 \u0440\u043e\u0434. \u043f\u0430\u0434\u0435\u0436\u0435", 50);
            this.putDataIfHave(map, cpManager, contractId, "u.directorFullName", "directorFullName", "\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f", 80);
            this.putDataIfHave(map, cpManager, contractId, "u.directorFullNameGenitive", "directorFullNameGenitive", "\u0414\u043e\u043b\u0436\u043d\u043e\u0441\u0442\u044c \u0440\u0443\u043a\u043e\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044f \u0432 \u0440\u043e\u0434. \u043f\u0430\u0434\u0435\u0436\u0435", 80);
            this.putDataIfHave(map, cpManager, contractId, "u.bankName", "bankName", "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u0430", 100);
            this.putDataIfHave(map, cpManager, contractId, "u.bankCity", "bankCity", "\u0413\u043e\u0440\u043e\u0434 \u0431\u0430\u043d\u043a\u0430", 64);
            this.putDataIfHave(map, cpManager, contractId, "u.bankBic", "bankBic", "\u0411\u0438\u043a", 11);
            this.putDataIfHave(map, cpManager, contractId, "u.bankCurrentAccount", "bankCurrentAccount", "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0447\u0435\u0442 \u0432 \u0431\u0430\u043d\u043a\u0435", 34);
            this.putDataIfHave(map, cpManager, contractId, "u.bankCorrAccount", "bankCorrAccount", "\u041a\u043e\u0440. \u0441\u0447\u0435\u0442", 24);
            House legalHouse = houseDao.get(legalAddress.getHouseId());
            if (legalHouse != null) {
                String legalZip;
                String cityTitle = legalHouse.optCity().map(IdTitle::getTitle).orElse("");
                if (Utils.notBlankString((String)cityTitle) && cityTitle.length() <= 50) {
                    map.put("legalAddressCity", cityTitle);
                }
                if (Utils.notBlankString((String)(legalZip = legalHouse.getPostIndex())) && legalZip.length() <= 20) {
                    map.put("legalAddressZip", legalZip);
                }
            }
            if ((invoiceHouse = houseDao.get(invoiceAddress.getHouseId())) != null) {
                String invoiceZip;
                String cityTitle = invoiceHouse.optCity().map(IdTitle::getTitle).orElse("");
                if (Utils.notBlankString((String)cityTitle) && cityTitle.length() <= 50) {
                    map.put("invoiceAddressCity", cityTitle);
                }
                if (Utils.notBlankString((String)(invoiceZip = invoiceHouse.getPostIndex())) && invoiceZip.length() <= 20) {
                    map.put("invoiceAddressZip", invoiceZip);
                }
            }
            if ((actualAddress = (EntityAttrAddress)contractDao.getContractParameterAddress(contractId, this.moduleSetup.getInt("u.actualAddress", -1)).orElse(null)) != null) {
                House actualHouse;
                String addressTitle = actualAddress.getTitle();
                if (Utils.notBlankString((String)addressTitle) && addressTitle.length() <= 256) {
                    map.put("actualAddressAddress", addressTitle);
                }
                if ((actualHouse = houseDao.get(actualAddress.getHouseId())) != null) {
                    String actualZip;
                    String cityTitle = actualHouse.optCity().map(IdTitle::getTitle).orElse("");
                    if (Utils.notBlankString((String)cityTitle) && cityTitle.length() <= 50) {
                        map.put("actualAddressCity", cityTitle);
                    }
                    if (Utils.notBlankString((String)(actualZip = actualHouse.getPostIndex()))) {
                        map.put("actualAddressZip", actualZip);
                    }
                }
            }
            HttpResponse response = this.httpPostRequest(urlStr, map);
            int responseCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String string = answer = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
            if (responseCode / 100 == 2) {
                if (entity == null) {
                    throw new BGException("Http Entity is null");
                }
                JSONObject data = new JSONObject(answer);
                int accountId = data.getInt("accountId");
                String control = data.getString("control");
                String password = data.getString("password");
                MangoAccount mangoAccount = new MangoAccount(contractId, accountId, control, password);
                return mangoAccount;
            }
            this.getLogger().error("Create Account response http code = " + responseCode + " Answer: " + answer);
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430! http code = " + responseCode + this.parseErrorAnswer(responseCode, answer));
        }
        catch (IOException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MangoAccount createIndividualAccountRequest(int contractId) throws BGException {
        String urlStr = this.apiDomen + "/mango_billing_ext_api/api/account/phis";
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);
             ContractParameterManager cpManager = new ContractParameterManager(this.con);){
            String answer;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("creditLimit", this.getIntParam("f.creditLimit"));
            this.putData(map, cpManager, contractId, "f.personName", "personName", "\u0418\u043c\u044f \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435", 100);
            this.putData(map, cpManager, contractId, "f.psptseries", "psptseries", "\u0421\u0435\u0440\u0438\u044f \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430", 10);
            this.putData(map, cpManager, contractId, "f.psptnumber", "psptnumber", "\u041d\u043e\u043c\u0435\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430", 10);
            this.putData(map, cpManager, contractId, "f.psptissuedby", "psptissuedby", "\u041a\u0435\u043c \u0432\u044b\u0434\u0430\u043d \u043f\u0430\u0441\u043f\u043e\u0440\u0442", 255);
            this.putData(map, cpManager, contractId, "f.psptissueddt", "psptissueddt", "\u0414\u0430\u0442\u0430 \u0432\u044b\u0434\u0430\u0447\u0438 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430", 10);
            this.putData(map, cpManager, contractId, "f.psptissuedcode", "psptissuedcode", "\u041a\u043e\u0434 \u043f\u043e\u0434\u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430", 50);
            this.putData(map, cpManager, contractId, "f.contactPhone", "contactPhone", "\u0422\u0435\u043b\u0435\u0444\u043e\u043d", 50);
            String email = this.getEmail(contractId, this.moduleSetup.getInt("f.email", -1), cpManager, contractDao);
            if (Utils.notBlankString((String)email)) {
                map.put("email", email);
            }
            HttpResponse response = this.httpPostRequest(urlStr, map);
            int responseCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String string = answer = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
            if (responseCode / 100 == 2) {
                if (entity == null) {
                    throw new BGException("Http Entity is null");
                }
                JSONObject data = new JSONObject(answer);
                MangoAccount mangoAccount = new MangoAccount(contractId, data.getInt("accountId"), data.getString("control"), data.getString("password"));
                return mangoAccount;
            }
            this.getLogger().error("Create Account response http code = " + responseCode + " Answer: " + answer);
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430! http code = " + responseCode + this.parseErrorAnswer(responseCode, answer));
        }
        catch (IOException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public MangoAccountStatus getMangoStatus(String control) throws BGException {
        return this.getMangoStatuses(new HashSet<String>(Arrays.asList(control))).get(control);
    }

    public Map<String, MangoAccountStatus> getMangoStatuses(Set<String> controls) throws BGException {
        HashMap<String, MangoAccountStatus> result;
        block6: {
            String urlStr = this.apiDomen + "/mango_billing_ext_api/api/account/status";
            result = new HashMap<String, MangoAccountStatus>();
            if (controls == null || controls.size() == 0) {
                return result;
            }
            this.requestToken();
            try {
                String answer;
                HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
                map.put("controls", controls);
                HttpResponse response = this.httpPostRequest(urlStr, map);
                int responseCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                String string = answer = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
                if (responseCode / 100 == 2) {
                    JSONObject data;
                    if (entity == null) {
                        throw new BGException("Http Entity is null");
                    }
                    JSONObject d = new JSONObject(answer);
                    JSONArray array = d.getJSONArray("controls");
                    for (int i = 0; i < array.length() && (data = array.optJSONObject(i)) != null; ++i) {
                        String control = data.getString("control");
                        int status = data.getInt("currentStatus");
                        int blockType = data.optInt("currentBlockType", -1);
                        BigDecimal balance = data.getBigDecimal("balance");
                        MangoAccountStatus mangoSatatus = new MangoAccountStatus();
                        mangoSatatus.setControl(control);
                        mangoSatatus.setStatus(status);
                        mangoSatatus.setBlockType(blockType);
                        mangoSatatus.setBalance(balance);
                        result.put(control, mangoSatatus);
                    }
                    break block6;
                }
                this.getLogger().error("Create Account response http code = " + responseCode + " Answer: " + answer);
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430! http code = " + responseCode + this.parseErrorAnswer(responseCode, answer));
            }
            catch (IOException e) {
                throw new BGException(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public BigDecimal changeBalance(int contractId, BigDecimal sum, String comment) throws Exception {
        String answer;
        String urlStr = this.apiDomen + "/mango_billing_ext_api/api/account/recharge";
        this.requestToken();
        MangoAccountDao accountDao = new MangoAccountDao(this.con, this.mid);
        MangoAccount account = accountDao.getByContractId(contractId);
        if (account == null) {
            throw new BGMessageException("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("control", account.getControl());
        map.put("sum", sum);
        if (Utils.notBlankString((String)comment)) {
            map.put("description", comment);
        }
        HttpResponse response = this.httpPostRequest(urlStr, map);
        int responseCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String string = answer = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
        if (responseCode / 100 == 2) {
            if (entity == null) {
                throw new BGException("Http Entity is null");
            }
            JSONObject data = new JSONObject(answer);
            BigDecimal balance = data.getBigDecimal("balance");
            this.getLogger().info("Balance after change: " + Utils.formatBigDecimalSumm((BigDecimal)balance));
            return balance;
        }
        this.getLogger().error("Change balance response http code = " + responseCode + " Answer: " + answer);
        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0431\u0430\u043b\u0430\u043d\u0441\u0430! http code = " + responseCode + this.parseErrorAnswer(responseCode, answer));
    }

    public MangoAccountProduct productAdd(int accountId, int planId, int linkedProductId) throws Exception {
        String answer;
        String urlStr = this.apiDomen + "/mango_billing_ext_api/api/product";
        this.requestToken();
        MangoAccountProductDao productDao = new MangoAccountProductDao(this.con, this.mid);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("accountId", accountId);
        map.put("planId", planId);
        if (linkedProductId > 0) {
            map.put("linkedProductId", linkedProductId);
        }
        HttpResponse response = this.httpPostRequest(urlStr, map);
        int responseCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String string = answer = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
        if (responseCode / 100 == 2) {
            if (entity == null) {
                throw new BGException("Http Entity is null");
            }
            JSONObject data = new JSONObject(answer);
            int productId = data.getInt("productId");
            int productStatus = data.getInt("productStatus");
            MangoAccountProduct product = new MangoAccountProduct();
            product.setAccountId(accountId);
            product.setPlanId(planId);
            product.setProductId(productId);
            product.setProductStatus(productStatus);
            product.setDateFrom(new Date());
            productDao.update(product);
            return product;
        }
        this.getLogger().error("Add product response http code = " + responseCode + " Answer: " + answer);
        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430! http code = " + responseCode + this.parseErrorAnswer(responseCode, answer));
    }

    public void productRemove(int productId) throws Exception {
        String answer;
        MangoAccountProductDao productDao = new MangoAccountProductDao(this.con, this.mid);
        MangoAccountDao accountDao = new MangoAccountDao(this.con, this.mid);
        MangoAccountProduct product = (MangoAccountProduct)productDao.get(productId);
        if (product == null) {
            throw new BGMessageException("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        MangoAccount account = accountDao.getByAccountId(product.getAccountId());
        if (account == null) {
            throw new BGMessageException("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        String urlStr = this.apiDomen + "/mango_billing_ext_api/api/product/" + account.getAccountId() + "/close";
        this.requestToken();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("accountid", account.getAccountId());
        map.put("accdtlid", product.getProductId());
        HttpResponse response = this.httpPostRequest(urlStr, map);
        int responseCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String string = answer = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
        if (responseCode / 100 == 2) {
            if (entity == null) {
                throw new BGException("Http Entity is null");
            }
        } else {
            this.getLogger().error("Remove product response http code = " + responseCode + " Answer: " + answer);
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430! http code = " + responseCode + this.parseErrorAnswer(responseCode, answer));
        }
        product.setProductStatus(400);
        product.setDateTo(new Date());
        productDao.update(product);
    }

    public MangoPhone phoneAdd(int contractId, MangoAccountProduct product, String phoneNumber) throws Exception {
        String answer;
        String urlStr = this.apiDomen + "/mango_billing_ext_api/api/abonent";
        if (Utils.isBlankString((String)phoneNumber)) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440");
        }
        String phone = phoneNumber.replaceAll(" ", "");
        if (phone.length() != 11) {
            throw new BGMessageException("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c 11 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
        }
        String prefix = phone.substring(0, 4);
        this.requestToken();
        MangoPhoneDao mangoPhoneDao = new MangoPhoneDao(this.con, this.mid);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("productId", "" + product.getProductId());
        map.put("didNumber", phone);
        map.put("didPrefix", prefix);
        HttpResponse response = this.httpPostRequest(urlStr, map);
        int responseCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String string = answer = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
        if (responseCode / 100 == 2) {
            if (entity == null) {
                throw new BGException("Http Entity is null");
            }
            JSONObject data = new JSONObject(answer);
            int abonentId = data.getInt("abonentId");
            int abonentStatus = data.getInt("abonentStatus");
            this.getLogger().info("Phone added. abonenctId = " + abonentId + " abonentStatus = " + abonentStatus);
            MangoPhone mangoPhone = new MangoPhone();
            mangoPhone.setContractId(contractId);
            mangoPhone.setAccountProductId(product.getId());
            mangoPhone.setPhone(phone);
            mangoPhone.setDateFrom(new Date());
            mangoPhone.setStatus(0);
            mangoPhoneDao.update(mangoPhone);
            return mangoPhone;
        }
        this.getLogger().error("Add phone, response http code = " + responseCode + " Answer: " + answer);
        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430! http code = " + responseCode + this.parseErrorAnswer(responseCode, answer));
    }

    public void phoneRemove(int phoneId) throws Exception {
        String answer;
        MangoPhoneDao mangoPhoneDao = new MangoPhoneDao(this.con, this.mid);
        MangoAccountProductDao productDao = new MangoAccountProductDao(this.con, this.mid);
        MangoPhone phone = (MangoPhone)mangoPhoneDao.get(phoneId);
        if (phone == null) {
            throw new BGMessageException("\u041d\u043e\u043c\u0435\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        if (phone.getStatus() == 1) {
            throw new BGMessageException("\u041d\u043e\u043c\u0435\u0440 \u0443\u0436\u0435 \u0443\u0434\u0430\u043b\u0435\u043d");
        }
        MangoAccountProduct product = (MangoAccountProduct)productDao.get(phone.getAccountProductId());
        if (product == null) {
            throw new BGMessageException("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        String urlStr = this.apiDomen + "/mango_billing_ext_api/api/abonent/" + phone.getPhone() + "/close";
        this.requestToken();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accdtlid", "" + product.getProductId());
        map.put("didnumber", phone.getPhone());
        HttpResponse response = this.httpPostRequest(urlStr, map);
        int responseCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String string = answer = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
        if (responseCode / 100 == 2) {
            if (entity == null) {
                throw new BGException("Http Entity is null");
            }
        } else {
            this.getLogger().error("Remove phone, response http code = " + responseCode + " Answer: " + answer);
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430! http code = " + responseCode + this.parseErrorAnswer(responseCode, answer));
        }
        JSONObject data = new JSONObject(answer);
        int abonentId = data.getInt("abonentId");
        int abonentStatus = data.getInt("abonentStatus");
        this.getLogger().info("Phone delete. abonenctId = " + abonentId + " abonentStatus = " + abonentStatus);
        phone.setDateTo(new Date());
        phone.setStatus(1);
        mangoPhoneDao.update(phone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestToken() throws BGException {
        Object object = mutexTokenRequest;
        synchronized (object) {
            if (!this.tokenIsValid(jwtKey)) {
                String urlStr = this.apiDomen + "/mango_billing_ext_api/api/auth";
                try {
                    String token;
                    String answer;
                    CloseableHttpClient httpclient = HttpClientBuilder.create().build();
                    HttpPost httppost = new HttpPost(urlStr);
                    httppost.setHeader("Content-Type", "application/json;charset=UTF-8");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("username", this.getStringParam("apiLogin"));
                    map.put("password", this.getStringParam("apiPassword"));
                    ObjectMapper mapper = new ObjectMapper();
                    String sendJsonData = mapper.writeValueAsString(map);
                    httppost.setEntity((HttpEntity)new StringEntity(sendJsonData, "UTF-8"));
                    HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                    int responseCode = response.getStatusLine().getStatusCode();
                    HttpEntity entity = response.getEntity();
                    String string = answer = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
                    if (responseCode / 100 == 2) {
                        if (entity == null) {
                            throw new BGException("Http Entity is null");
                        }
                        JSONObject data = new JSONObject(answer);
                        token = data.getString("token");
                        if (!this.tokenIsValid(token)) {
                            throw new BGMessageException("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0439 \u0442\u043e\u043a\u0435\u043d \u043d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u0435\u043d!");
                        }
                    } else {
                        this.getLogger().error("Token request http code = " + responseCode + " Answer = " + answer);
                        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0442\u043e\u043a\u0435\u043d\u0430! http code = " + responseCode + this.parseErrorAnswer(responseCode, answer));
                    }
                    jwtKey = token;
                }
                catch (IOException e) {
                    throw new BGException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private String parseErrorAnswer(int httpCode, String answer) {
        if (httpCode == 404) {
            return " Not Found";
        }
        Object result = "";
        if (Utils.notBlankString((String)answer)) {
            try {
                JSONArray errors;
                JSONObject data = new JSONObject(answer);
                JSONObject errorType = data.getJSONObject("errorType");
                if (errorType != null && errorType.length() > 0) {
                    String errorMessage;
                    int errorCode = errorType.optInt("errorCode", -1);
                    if (errorCode > 0) {
                        result = (String)result + "\nMango error code: " + errorCode;
                    }
                    if ((errorMessage = errorType.optString("errorMessage", null)) != null) {
                        result = (String)result + "\nMango error message: " + errorMessage;
                    }
                }
                if ((errors = data.getJSONArray("errors")) != null && errors.length() > 0) {
                    result = (String)result + "\nErrors: " + String.valueOf(errors);
                }
            }
            catch (Exception ex) {
                this.logError(ex);
                return "\n" + answer;
            }
        }
        return result;
    }

    private HttpResponse httpPostRequest(String urlStr, Map map) throws ClientProtocolException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        String sendJsonData = mapper.writeValueAsString((Object)map);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpPost httppost = new HttpPost(urlStr);
        httppost.setHeader("Content-Type", "application/json;charset=UTF-8");
        httppost.addHeader("Host", this.apiDomen.replaceFirst("http://", "").replaceFirst("https://", ""));
        httppost.addHeader("Authorization", "Bearer " + jwtKey);
        httppost.setEntity((HttpEntity)new StringEntity(sendJsonData, "UTF-8"));
        return httpclient.execute((HttpUriRequest)httppost);
    }

    private String putData(Map<String, Object> map, ContractParameterManager cpManager, int contractId, String paramName, String mangoParamName, String description, int limit) throws BGMessageException {
        return this.putDataUn(map, cpManager, contractId, paramName, mangoParamName, description, limit, true);
    }

    private String putDataIfHave(Map<String, Object> map, ContractParameterManager cpManager, int contractId, String paramName, String mangoParamName, String description, int limit) throws BGMessageException {
        return this.putDataUn(map, cpManager, contractId, paramName, mangoParamName, description, limit, false);
    }

    private String putDataUn(Map<String, Object> map, ContractParameterManager cpManager, int contractId, String paramName, String mangoParamName, String description, int limit, boolean isChecked) throws BGMessageException {
        String sendText = null;
        String billRef = this.moduleSetup.get("bill." + paramName);
        if (Utils.notBlankString((String)billRef)) {
            String[] midKey = billRef.split(":", 2);
            if (midKey.length != 2) {
                throw new BGMessageException("\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442 \u043c\u043e\u0434\u0443\u043b\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438");
            }
            int midBill = Utils.parseInt((String)midKey[0], (int)0);
            String key = midKey[1];
            if (!ServerUtils.tableExists((Connection)this.con, (String)("bill_attribute_" + midBill))) {
                throw new BGMessageException("\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0438\u0438 = " + midBill);
            }
            try (PreparedStatement ps = this.con.prepareStatement("SELECT value FROM bill_attribute_" + midBill + " WHERE cid=? AND name=?");){
                ps.setInt(1, contractId);
                ps.setString(2, key);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    sendText = rs.getString("value");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            int pid = isChecked ? this.getIntParam(paramName) : this.moduleSetup.getInt(paramName, -1);
            sendText = cpManager.getTextlikeParam(contractId, pid);
        }
        if (Utils.notBlankString((String)sendText)) {
            if (sendText.length() > limit) {
                throw new BGMessageException(description + " > " + limit + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            }
            map.put(mangoParamName, sendText);
        } else if (isChecked) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e: " + description);
        }
        return sendText;
    }

    private String getStringParam(String paramName) throws BGMessageException {
        String value = this.moduleSetup.get(paramName);
        if (Utils.isBlankString((String)value)) {
            throw new BGMessageException(paramName + " \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043c\u043e\u0434\u0443\u043b\u044f!");
        }
        return value.trim();
    }

    private int getIntParam(String paramName) throws BGMessageException {
        int value = this.moduleSetup.getInt(paramName, Integer.MIN_VALUE);
        if (value == Integer.MIN_VALUE) {
            throw new BGMessageException(paramName + " \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043c\u043e\u0434\u0443\u043b\u044f \u043b\u0438\u0431\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435!");
        }
        return value;
    }

    private String getEmail(int contractId, int emailPid, ContractParameterManager cpManager, ContractDao contractDao) throws BGException {
        String emailPattern;
        Pattern regexp;
        Matcher m;
        String emailStr;
        String result = contractDao.optContractParameterEmailFirst(contractId, emailPid).orElse(null);
        if (result == null && Utils.notBlankString((String)(emailStr = cpManager.getTextlikeParam(contractId, emailPid))) && (m = (regexp = Pattern.compile(emailPattern = "(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", 2)).matcher(emailStr)).find()) {
            result = m.group();
        }
        return result;
    }
}

