/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff;

import java.util.Set;
import ru.bitel.bgbilling.common.bean.RangeParser;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.PrefixPartTariffTreeNode;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.common.ParameterMap;

public class NPrefixTariffTreeNode
extends DefaultTariffTreeNode<VoiceTariffRequest, TariffContext> {
    private final RangeParser rangeParser;
    private final int dest;
    private final int zone;

    public NPrefixTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        RangeParser rangeParser = null;
        try {
            rangeParser = new RangeParser(parameterMap.get("prefix", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rangeParser = rangeParser;
        this.dest = parameterMap.getInt("dest", 0);
        this.zone = parameterMap.getInt("zone", 0);
    }

    protected int executeImpl(Long treeNodeId, VoiceTariffRequest req, TariffContext context) {
        Set prefixAcceptedSet = req.getAcceptedSet(PrefixPartTariffTreeNode.class);
        if (req.phoneTo != null && this.rangeParser != null && prefixAcceptedSet.size() == 0) {
            String phoneRest = req.phoneToRest;
            if (phoneRest == null) {
                phoneRest = req.phoneTo;
            }
            RangeParser.CheckResult result = this.rangeParser.checkPrefixWithResult(phoneRest);
            if (result.result) {
                req.phoneToRest = phoneRest = phoneRest.substring(result.length);
                if (this.dest > 0) {
                    req.destId = this.dest;
                }
                if (this.zone > 0) {
                    req.zoneId = this.zone;
                }
                return 1;
            }
        }
        return 0;
    }

    protected int postExecuteImpl(Long treeNodeId, VoiceTariffRequest req, TariffContext ctx, int executeResult) {
        Set prefixAcceptedSet = req.getAcceptedSet(PrefixPartTariffTreeNode.class);
        if (executeResult == 1) {
            prefixAcceptedSet.add(1L);
        }
        return executeResult;
    }
}

