/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.dba.server.bean.TableConfigItem;
import ru.bitel.common.Utils;

public class TableConfigManager
extends AbstarctDaoConstant {
    public TableConfigManager(Connection con, int moduleId) {
        super(con, "dba_table_config", moduleId);
    }

    public List<TableConfigItem> getConfigItemList() throws SQLException {
        ArrayList<TableConfigItem> result = new ArrayList<TableConfigItem>();
        String query = "SELECT * FROM " + this.tableName;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                TableConfigItem item = new TableConfigItem();
                item.setModuleId(rs.getInt("mid"));
                item.setTableId(rs.getInt("tid"));
                item.setData(rs.getString("data"));
                result.add(item);
            }
        }
        return result;
    }

    public Map<String, String> getConfigItemMap() throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        String query = "SELECT * FROM " + this.tableName;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.put(rs.getInt("mid") + "_" + rs.getInt("tid"), rs.getString("data"));
            }
        }
        return result;
    }

    public void updateConfigItem(TableConfigItem item) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE mid=? AND tid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, item.getModuleId());
            ps.setInt(2, item.getTableId());
            ps.executeUpdate();
        }
        if (Utils.notBlankString((String)item.getData())) {
            query = "INSERT INTO " + this.tableName + " (mid, tid, data) VALUES (?, ?, ?)";
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, item.getModuleId());
                ps.setInt(2, item.getTableId());
                ps.setString(3, item.getData());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }
}

