/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.enaza.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.enaza.common.bean.EnazaTransaction;
import ru.bitel.common.TimeUtils;

public class EnazaTransactionDao
extends AbstarctDaoConstant {
    public EnazaTransactionDao(Connection con, int moduleId) {
        super(con, "enaza_transaction", moduleId);
    }

    public EnazaTransaction get(long orderId) throws SQLException {
        EnazaTransaction result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE order_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, orderId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        return result;
    }

    private EnazaTransaction getFromRS(ResultSet rs) throws SQLException {
        EnazaTransaction transaction = new EnazaTransaction();
        transaction.setContractId(rs.getInt("contract_id"));
        transaction.setAmount(rs.getBigDecimal("amount"));
        transaction.setContractGroupId(rs.getBigDecimal("contract_group_id"));
        transaction.setDescription(rs.getString("descr"));
        transaction.setServiceId(rs.getString("service_id"));
        transaction.setVat(rs.getInt("vat"));
        transaction.setProductType(rs.getBigDecimal("product_type"));
        transaction.setPriceCategory(rs.getBigDecimal("price_category"));
        transaction.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dt")));
        transaction.setChargeId(rs.getInt("charge_id"));
        transaction.setStatus(rs.getInt("status"));
        transaction.setOrderId(rs.getBigDecimal("order_id"));
        return transaction;
    }

    public void update(EnazaTransaction enazaTransaction) throws SQLException {
        boolean needInsert = false;
        String setFields = " SET contract_id=?, amount=?, contract_group_id=?, descr=?, service_id=?, vat=?, product_type=?, price_category=?, dt=?, charge_id=?, status=?";
        String query = "UPDATE " + this.tableName + setFields + " WHERE order_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            this.setPsParams(enazaTransaction, ps);
            needInsert = ps.executeUpdate() == 0;
        }
        if (needInsert) {
            query = "INSERT INTO " + this.tableName + setFields + ", order_id=?";
            ps = this.con.prepareStatement(query);
            try {
                this.setPsParams(enazaTransaction, ps);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    private void setPsParams(EnazaTransaction enazaTransaction, PreparedStatement ps) throws SQLException {
        int index = 1;
        ps.setInt(index++, enazaTransaction.getContractId());
        ps.setBigDecimal(index++, enazaTransaction.getAmount());
        ps.setBigDecimal(index++, enazaTransaction.getContractGroupId());
        ps.setString(index++, enazaTransaction.getDescription());
        ps.setString(index++, enazaTransaction.getServiceId());
        ps.setInt(index++, enazaTransaction.getVat());
        ps.setBigDecimal(index++, enazaTransaction.getProductType());
        ps.setBigDecimal(index++, enazaTransaction.getPriceCategory());
        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)enazaTransaction.getDate()));
        ps.setInt(index++, enazaTransaction.getChargeId());
        ps.setInt(index++, enazaTransaction.getStatus());
        ps.setBigDecimal(index++, enazaTransaction.getOrderId());
    }

    public void deleteForContract(int contractId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE contract_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
    }

    public List<EnazaTransaction> getList(int cid) throws SQLException {
        ArrayList<EnazaTransaction> result = new ArrayList<EnazaTransaction>();
        String query = "SELECT * FROM " + this.tableName + " WHERE contract_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cid);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        return result;
    }
}

