/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;

public class ParamManager
extends AbstarctDaoConstant {
    protected BGPluginServer plugin = null;

    public ParamManager(Connection con, BGPluginServer plugin) {
        super(con);
        this.plugin = plugin;
    }

    protected String getDBTableName(String name) {
        return name + "_" + this.plugin.getPluginUID();
    }

    public List<KeyValue> getModeList() {
        ArrayList<KeyValue> modeList = new ArrayList<KeyValue>();
        for (String item : this.plugin.getSetup().get("mode.list", "off:\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d;on:\u0432\u043a\u043b\u044e\u0447\u0435\u043d \u043e\u0431\u044b\u0447\u043d\u044b\u0439;package:\u0432\u043a\u043b\u044e\u0447\u0435\u043d \u043f\u0430\u043a\u0435\u0442\u043d\u044b\u0439").split(";")) {
            String[] value = item.split(":");
            if (value.length != 2) continue;
            modeList.add(new KeyValue(value[0], value[1]));
        }
        return modeList;
    }

    public String getContractCurrentMode(int contractId) throws BGException {
        return this.getProperties(contractId).getProperty("mode.id", this.plugin.getSetup().get("mode.default.id", "on"));
    }

    public Properties getProperties(int contractId) throws BGException {
        Properties properties = new Properties();
        StringBuilder query = new StringBuilder().append("SELECT * FROM ").append(this.getDBTableName("helpdesk_param")).append(" WHERE cid=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    properties.put(rs.getString("name"), rs.getString("value"));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return properties;
    }

    public void setProperties(int contractId, Properties properties) throws BGException {
        PreparedStatement ps;
        String query = "DELETE FROM " + this.getDBTableName("helpdesk_param") + " WHERE cid=?";
        try {
            ps = this.con.prepareStatement(query.toString());
            try {
                ps.setInt(1, contractId);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        if (properties != null && properties.size() > 0) {
            query = "INSERT INTO " + this.getDBTableName("helpdesk_param") + " SET cid=?, name=?, value=?";
            try {
                ps = this.con.prepareStatement(query.toString());
                try {
                    ps.setInt(1, contractId);
                    for (Object key : properties.keySet()) {
                        ps.setString(2, (String)key);
                        ps.setString(3, properties.getProperty((String)key, null));
                        ps.executeUpdate();
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }
}

