/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ListValue;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ListValueManager {
    private Connection con;
    private static final String TABLE_NAME = "object_list_value";

    public ListValueManager(Connection con) {
        this.con = con;
    }

    public Map<Integer, ListValue> getValuesMap() throws SQLException {
        HashMap<Integer, ListValue> result = new HashMap<Integer, ListValue>();
        String query = "SELECT * FROM object_list_value";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                ListValue value = this.getListValueFromRs(rs);
                result.put(value.getId(), value);
            }
        }
        return result;
    }

    public ListValue getValue(int id) throws SQLException {
        ListValue result = null;
        String query = "SELECT * FROM object_list_value WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = this.getListValueFromRs(rs);
                }
            }
        }
        return result;
    }

    public List<ListValue> getValues(int listParamId) throws SQLException {
        ArrayList<ListValue> result = new ArrayList<ListValue>();
        String query = "SELECT * FROM object_list_value WHERE param_id=? ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, listParamId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getListValueFromRs(rs));
                }
            }
        }
        return result;
    }

    public void updateValue(ListValue value) throws SQLException {
        Objects.requireNonNull(value);
        boolean update = value.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + "object_list_value SET param_id=?, title=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, value.getParamId());
            ps.setString(index++, value.getTitle());
            if (update) {
                ps.setInt(index++, value.getId());
            }
            ps.executeUpdate();
            if (!update) {
                value.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    public void deleteValue(int id) throws SQLException {
        String query = "DELETE FROM object_list_value WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    private ListValue getListValueFromRs(ResultSet rs) throws SQLException {
        return new ListValue(rs.getInt("id"), rs.getString("title")).setParamId(rs.getInt("param_id"));
    }
}

