/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.tariff.server.event.TariffTreeModifiedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffTreeBuilder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.worker.ThreadContext;

public class TariffTreeCache
extends AbstractTariffTreeBuilder {
    private static final TariffTreeCache instance = new TariffTreeCache();
    private final ConcurrentMap<Integer, ConcurrentMap<Integer, SoftReference<TariffModuleTreeRef>>> treeModuleMap = new ConcurrentHashMap<Integer, ConcurrentMap<Integer, SoftReference<TariffModuleTreeRef>>>();

    public static TariffTreeCache getInstance() {
        return instance;
    }

    private TariffTreeCache() {
        new Thread("tree-cache-reload"){

            @Override
            public void run() {
                try {
                    EventProcessor.getInstance().addListener(new EventListener<TariffTreeModifiedEvent>(){

                        @Override
                        public void notify(final TariffTreeModifiedEvent e, final EventListenerContext ctx) throws BGException {
                            new Thread("tree-cache-reload"){

                                @Override
                                public void run() {
                                    ServerContext context = new ServerContext(ctx.getSetup(), 0, 0);
                                    ServerContext.push((ThreadContext)context);
                                    try {
                                        TariffTreeCache.this.reloadTree(e.getModuleId(), e.getTreeId());
                                    }
                                    finally {
                                        ServerContext.pop((ThreadContext)context, null);
                                    }
                                }
                            }.start();
                        }
                    }, TariffTreeModifiedEvent.class);
                }
                catch (BGException e) {
                    TariffTreeCache.this.getLogger().error("error add EventProcessor listener to reloadTree", (Throwable)e);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadTree(int moduleId, int treeId) {
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            this.getLogger().debug("Reload tree in cache, moduleId: {}; treeId: {}", (Object)moduleId, (Object)treeId);
            ConcurrentMap moduleMap = (ConcurrentMap)this.treeModuleMap.get(treeId);
            if (moduleMap != null) {
                SoftReference treeRefRef = (SoftReference)moduleMap.get(moduleId);
                TariffModuleTreeRef treeRef = null;
                if (treeRefRef != null && (treeRef = (TariffModuleTreeRef)treeRefRef.get()) != null) {
                    TariffModuleTree tree = this.loadTariffModuleTree(con, treeId, moduleId, treeRef.module);
                    treeRef.set(tree);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("error reloadTree moduleId=" + moduleId + "; treeId=" + treeId, (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicReference<TariffModuleTree> getModuleTree(Connection con, int treeId, int moduleId, String module) {
        AtomicReference treeRef;
        ConcurrentMap moduleMap = this.treeModuleMap.computeIfAbsent(treeId, key -> new ConcurrentHashMap());
        SoftReference treeRefRef = (SoftReference)moduleMap.get(moduleId);
        if (treeRefRef != null && (treeRef = (AtomicReference)treeRefRef.get()) != null) {
            return treeRef;
        }
        ConcurrentMap concurrentMap = moduleMap;
        synchronized (concurrentMap) {
            AtomicReference treeRef2;
            treeRefRef = (SoftReference)moduleMap.get(moduleId);
            if (treeRefRef != null && (treeRef2 = (AtomicReference)treeRefRef.get()) != null) {
                return treeRef2;
            }
            treeRef2 = null;
            try {
                TariffModuleTree tree = this.loadTariffModuleTree(con, treeId, moduleId, module);
                if (tree == null) {
                    this.getLogger().debug("getModuleTree: Node not found: {}; moduleId: {}", (Object)treeId, (Object)moduleId);
                }
                treeRef2 = new TariffModuleTreeRef(module, tree);
                moduleMap.put(moduleId, new SoftReference<AtomicReference>(treeRef2));
            }
            catch (Exception e) {
                this.getLogger().error("getModuleTree: error loadTariffModuleTree moduleId=" + moduleId + "; treeId=" + treeId, (Throwable)e);
            }
            return treeRef2;
        }
    }

    final class TariffModuleTreeRef
    extends AtomicReference<TariffModuleTree> {
        final String module;

        public TariffModuleTreeRef(String module, TariffModuleTree initialValue) {
            super(initialValue);
            this.module = module.intern();
        }
    }
}

