/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server;

import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseCopy;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrder;
import ru.bitel.bgbilling.modules.license.common.bean.enums.LicenseOrderType;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.XMLUtils;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.license.server"};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void moduleAction(ServerContext ctx, int mid, Event event) throws Exception {
        ContractDeleteEvent cdEvent;
        super.moduleAction(ctx, mid, event);
        if (event instanceof ContractCreateEvent) {
            ContractPattern cp;
            Document doc;
            int cid = event.getContractId();
            ContractCreateEvent cce = (ContractCreateEvent)event;
            if (!cce.isCheck() && (doc = (cp = cce.getPattern()).getData()) != null) {
                Object orders;
                LicenseCopy copy;
                int pid;
                LicenseManager licenseManager = new LicenseManager(ctx.getConnection(), mid);
                HashMap<Integer, LicenseCopy> selectedProducts = new HashMap<Integer, LicenseCopy>();
                Element products = XMLUtils.selectElement((Node)doc, (String)("data/modules/license[@mid=" + mid + "]/selectedProducts"));
                if (products != null) {
                    Iterable productCopies = XMLUtils.selectElements((Node)products, (String)"product");
                    for (Element el : productCopies) {
                        pid = Integer.valueOf(el.getAttribute("id"));
                        copy = new LicenseCopy().setProductId(pid).setContractId(cid).setLicenseName("").setComment("");
                        licenseManager.updateCopy(copy);
                        selectedProducts.put(pid, copy);
                    }
                }
                if ((orders = XMLUtils.selectElement((Node)doc, (String)("data/modules/license[@mid=" + mid + "]/defaultOrders"))) != null) {
                    for (Element productEl : XMLUtils.selectElements((Node)orders, (String)"product")) {
                        pid = Integer.valueOf(productEl.getAttribute("id"));
                        copy = (LicenseCopy)selectedProducts.get(pid);
                        if (copy == null) continue;
                        for (Element orderEl : XMLUtils.selectElements((Node)productEl, (String)"order")) {
                            LicenseOrder order = new LicenseOrder();
                            order.setComponentId(Integer.valueOf(orderEl.getAttribute("componentId")).intValue());
                            order.setCount(Integer.valueOf(orderEl.getAttribute("count")).intValue());
                            order.setTerm(Integer.valueOf(orderEl.getAttribute("term")).intValue());
                            if (order.getTerm() == 0) {
                                order.setType(LicenseOrderType.BUY);
                                order.setStatus(2);
                            } else {
                                order.setType(LicenseOrderType.TEST);
                                order.setStatus(3);
                            }
                            order.setCopyId(copy.getId());
                            order.setUserId(0);
                            licenseManager.updateCopyItemOrder(order);
                        }
                    }
                }
            }
        }
        if (event instanceof ContractDeleteEvent && !(cdEvent = (ContractDeleteEvent)event).isCheck()) {
            Connection con = ctx.getConnection();
            String cidStr = String.valueOf(event.getContractId());
            List copyIds = ServerUtils.deleteRowsFromTable((Connection)con, (String)("lic_copy_" + mid), (String)"contract_id", (String)cidStr, (String)"id");
            for (String copyId : copyIds) {
                List orderIds = ServerUtils.deleteRowsFromTable((Connection)con, (String)("lic_copy_item_order_" + mid), (String)"copy_id", (String)copyId, (String)"id");
                for (String orderId : orderIds) {
                    ServerUtils.deleteRowsFromTable((Connection)con, (String)("lic_copy_item_" + mid), (String)"order_id", (String)orderId, (String)"id");
                }
                List packageIds = ServerUtils.deleteRowsFromTable((Connection)con, (String)("lic_copy_package_" + mid), (String)"copy_id", (String)copyId, (String)"id");
                for (String packageId : packageIds) {
                    ServerUtils.deleteRowsFromTable((Connection)con, (String)("lic_copy_package_item_" + mid), (String)"package_id", (String)packageId, (String)"id");
                }
            }
        }
    }
}

