/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.client;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.list.BGUList;

public class ServicePropertiesPanel
extends ServicePanel {
    private boolean loadList = true;
    private String sid = "0";
    private BGTable tableContractCard = new BGTable();
    private BGUList<BGUListItem> serviceList = new BGUList();

    public ServicePropertiesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.tableContractCard.setHeader(this.rb_name, "0");
    }

    private void jbInit() throws Exception {
        this.serviceList.addListSelectionListener(e -> this.serviceList_valueChanged(e));
        this.setLayout(new BorderLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.getCardTypePanel(), (Component)this.getCardTablePanel(), 300L), "Center");
    }

    private JPanel getCardTypePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(" \u0422\u0438\u043f\u044b \u043a\u0430\u0440\u0442: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 10, 2, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.serviceList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getCardTablePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(" \u041a\u0430\u0440\u0442\u044b: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 10, 2, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.tableContractCard), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    public void setData() throws Exception {
        if (this.getContractId() == -1 || this.getModuleId() == -1) {
            return;
        }
        Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("CardContractInfo").setContractId(this.getContractId()).setAttribute("sid", this.sid).setAttribute("list", this.loadList ? "1" : "0");
        this.setDocument(this.getDocument(request));
    }

    public void setDocument(Document doc) throws Exception {
        if (!ClientUtils.checkStatus((Document)doc)) {
            return;
        }
        if (this.loadList) {
            this.loadList = false;
            this.serviceList.setData(ClientUtils.toBGUListItemList((Iterable)XMLUtils.selectElements((Node)doc, (String)"//services/item")));
        }
        this.tableContractCard.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            if (this.serviceList.isSelectionEmpty()) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043a\u0430\u0440\u0442\u044b", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                return;
            }
            new CardActiveteDialog(" \u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0443 ", new KeyValue()).open();
        } else if ("refresh".equals(actionCommand)) {
            this.trySetData();
        }
    }

    private void serviceList_valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.serviceList.optSelectedValue().ifPresent(a -> {
            this.sid = String.valueOf(a.getId());
        });
        this.trySetData();
    }

    class CardActiveteDialog
    extends BGEditorDialog<KeyValue> {
        private JTextField cardCode;
        private JPasswordField cardPinCode;

        public CardActiveteDialog(String title, KeyValue data) {
            super(title, (Object)data);
            this.cardCode = new JTextField(30);
            this.cardPinCode = new JPasswordField();
        }

        public void doDialogPanel() {
            this.cardCode.setHorizontalAlignment(0);
            this.cardPinCode.setHorizontalAlignment(0);
            this.addFieldV("\u041a\u043e\u0434 \u043a\u0430\u0440\u0442\u044b (\u043b\u043e\u0433\u0438\u043d):", this.cardCode);
            this.addFieldV("PIN-\u043a\u043e\u0434 (\u043f\u0430\u0440\u043e\u043b\u044c):", this.cardPinCode);
            this.cardCode.setText(((KeyValue)this.data).getKey());
            this.cardPinCode.setText(((KeyValue)this.data).getValue());
        }

        public boolean doApply() throws Exception {
            if (this.cardCode.getText().trim().length() == 0) {
                BGToolTip.showErrorMessage((JComponent)this.cardCode, (String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b");
                return false;
            }
            String pinCode = new String(this.cardPinCode.getPassword());
            if (pinCode.trim().length() == 0) {
                BGToolTip.showErrorMessage((JComponent)this.cardPinCode, (String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 PIN-\u043a\u043e\u0434 \u043a\u0430\u0440\u0442\u044b");
                return false;
            }
            Request request = new Request().setModule(ServicePropertiesPanel.this.module).setAction("ActiveCard").setContractId(ServicePropertiesPanel.this.getContractId()).setModuleId(ServicePropertiesPanel.this.getModuleId()).setAttribute("sid", String.valueOf(ServicePropertiesPanel.this.sid)).setAttribute("cardCode", this.cardCode.getText().trim()).setAttribute("cardPinCode", pinCode.trim()).setAttribute("status", "3");
            if (ClientUtils.checkStatus((Document)ServicePropertiesPanel.this.getDocument(request))) {
                ServicePropertiesPanel.this.trySetData();
                return true;
            }
            return false;
        }
    }
}

