/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.api.webapi;

import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.bean.CDATA;
import ru.bitel.bgbilling.kernel.auth.AuthModes;
import ru.bitel.bgbilling.kernel.auth.ModuleUser;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractModuleManager;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentTypeDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameters;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.plugins.news.common.bean.News;
import ru.bitel.bgbilling.plugins.news.server.bean.NewsManager;
import ru.bitel.bgbilling.server.api.webapi.WebApiBase;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.sql.ConnectionSet;

public class WebApi
extends WebApiBase {
    @Resource
    private TariffOptionService tariffOptionService;

    public WebApi(HttpServletRequest request) {
        super(request);
    }

    public void login() {
        String login = this.request.getParameter("login");
        String password = this.request.getParameter("password");
        String authModuleId = this.request.getParameter("midAuth");
        HashMap<Integer, List<Integer>> authModes = new HashMap<Integer, List<Integer>>();
        AuthModes.loadConfig(this.setup, 0L, authModes);
        ModuleUser moduleUser = AuthModes.findModuleUserUserByLogin(login, authModuleId, authModes);
        if (moduleUser != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("moduleUser = [" + moduleUser.toString() + "]");
            }
            if (moduleUser.getPassword().equals(password) || moduleUser.getPassword().equals(Utils.getDigest((String)password, (String)"utf-8"))) {
                this.dataMap.put("contractId", moduleUser.getContractId());
                this.dataMap.put("contractTitle", moduleUser.getContractTitle());
            } else {
                this.setError(2, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u043e\u043b\u044f");
            }
        } else {
            this.setError(1, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
    }

    public void contractParameters() throws Exception {
        int contractId = Utils.parseInt((String)this.request.getParameter("contractId"), (int)0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            Contract contract = ContractDao.getContract(con, contractId);
            if (contract != null) {
                Set<Integer> parameterIds = ContractParameters.getContractParameterIdsInGroup(contract.getParamGroupId(), con);
                List<ContractParameterPref> paramList = ContractParameters.getContractParameterPrefList(parameterIds, con);
                Map<Integer, String> paramValues = ContractParameters.getContractParameterValue(paramList, contract.getId(), con);
                ArrayList list = new ArrayList();
                for (ContractParameterPref contractParameterPref : paramList) {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    map.put("id", String.valueOf(contractParameterPref.getId()));
                    map.put("typeId", String.valueOf(contractParameterPref.getType().getId()));
                    map.put("title", contractParameterPref.getTitle());
                    map.put("read", String.valueOf(contractParameterPref.isRead()));
                    map.put("write", String.valueOf(contractParameterPref.isWrite()));
                    map.put("value", paramValues.get(contractParameterPref.getId()));
                    map.put("alwaysVisible", String.valueOf(contractParameterPref.isAlwaysVisible()));
                    list.add(map);
                }
                this.dataMap.put("contractParameters", list);
            }
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void contractBalance() throws Exception {
        int contractId = Utils.parseInt((String)this.request.getParameter("contractId"), (int)0);
        if (contractId > 0) {
            try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);){
                Contract contract = ContractDao.getContract(connectionSet.getConnection(), contractId);
                if (contract != null) {
                    ConvergenceBalanceManager convergenceBalanceManager = ConvergenceBalanceManager.getInstance();
                    ConvergenceBalance convergenceBalance = convergenceBalanceManager.getBalance(connectionSet, contractId, System.currentTimeMillis());
                    DecimalFormat decimalFormat = new DecimalFormat(this.setup.get("web.api.contract.balance.format.pattern", "###,###,###,###.00"));
                    this.dataMap.put("sum", decimalFormat.format(convergenceBalance.getBalance()));
                    this.dataMap.put("currencyTitleMedium", this.setup.get("client.gui.currency.title.medium", "\u0440\u0443\u0431."));
                }
                this.setError(1, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void contractPayments() throws Exception {
        int contractId = Utils.parseInt((String)this.request.getParameter("contractId"), (int)0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            int members = Utils.parseInt((String)this.request.getParameter("members"), (int)1);
            SearchResult searchResult = new SearchResult();
            searchResult.setPeriod(Utils.parsePeriod((String)this.request.getParameter("date1"), (String)this.request.getParameter("date2"), (Period)new Period()));
            new PaymentDao(con).searchPaymentList((SearchResult<Payment>)searchResult, contractId, members);
            this.paymentList((SearchResult<Payment>)searchResult);
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void lastContractPayments() throws Exception {
        int contractId = Utils.parseInt((String)this.request.getParameter("contractId"), (int)0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            int members = Utils.parseInt((String)this.request.getParameter("members"), (int)1);
            int lastPayments = Utils.parseInt((String)this.request.getParameter("lastPayments"), (int)3);
            SearchResult searchResult = new SearchResult();
            new PaymentDao(con).searchLastPaymentList((SearchResult<Payment>)searchResult, contractId, members, lastPayments);
            this.paymentList((SearchResult<Payment>)searchResult);
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void contractTarifPlans() throws Exception {
        int contractId = Utils.parseInt((String)this.request.getParameter("contractId"), (int)0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            int emid = Utils.parseInt((String)this.request.getParameter("entityMid"), (int)-1);
            int eid = Utils.parseInt((String)this.request.getParameter("entityId"), (int)-1);
            List<ContractTariff> contractTariffList = new ContractTariffDao(con).list(contractId, LocalDate.now(), emid, eid);
            TariffPlanDao tariffPlanDao = new TariffPlanDao(con);
            Map<Integer, TariffPlan> tariffPlanMap = tariffPlanDao.getTariffPlanMap();
            tariffPlanDao.close();
            ArrayList list = new ArrayList();
            for (ContractTariff contractTariff : contractTariffList) {
                Period period = new Period(contractTariff.getPeriod().getDateFrom(), contractTariff.getPeriod().getDateTo());
                TariffPlan tariffPlan = tariffPlanMap.get(contractTariff.getTariffPlanId());
                String contractTariffTitle = tariffPlan == null ? "???" : tariffPlan.getTitleWeb();
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("id", String.valueOf(contractTariff.getId()));
                map.put("tariffPlanId", String.valueOf(contractTariff.getTariffPlanId()));
                map.put("title", contractTariffTitle);
                map.put("dateFrom", TimeUtils.formatDate((Date)period.getDateFrom()));
                map.put("dateTo", TimeUtils.formatDate((Date)period.getDateTo()));
                map.put("period", TimeUtils.formatPeriod((Period)period));
                map.put("comment", contractTariff.getComment());
                map.put("pos", String.valueOf(contractTariff.getPosition()));
                list.add(map);
            }
            this.dataMap.put("contractTarifPlans", list);
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void contractTariffOptions() throws Exception {
        int contractId = Utils.parseInt((String)this.request.getParameter("contractId"), (int)0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            Date now = new Date();
            ContractTariffOptionDao contractTariffOptionDao = new ContractTariffOptionDao(con);
            List<ContractTariffOption> contractTariffOptionList = contractTariffOptionDao.list(contractId, now);
            ArrayList list = new ArrayList();
            DecimalFormat decimalFormat = new DecimalFormat(this.setup.get("web.api.contract.tariff.option.sum.format.pattern", "###,###,###,###.00"));
            for (ContractTariffOption contractTariffOption : contractTariffOptionList) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("id", String.valueOf(contractTariffOption.getId()));
                map.put("timeFrom", TimeUtils.formatDate((Date)contractTariffOption.getTimeFrom()));
                map.put("timeTo", TimeUtils.formatDate((Date)contractTariffOption.getTimeTo()));
                map.put("title", contractTariffOption.getOptionTitle());
                map.put("optionId", String.valueOf(contractTariffOption.getOptionId()));
                map.put("sum", decimalFormat.format(contractTariffOption.getSum()));
                list.add(map);
            }
            this.dataMap.put("contractTariffOptions", list);
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void contractModules() throws Exception {
        int contractId = Utils.parseInt((String)this.request.getParameter("contractId"), (int)0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            ArrayList list = new ArrayList();
            for (BGModule bgModule : new ContractModuleManager(con).getContractModules(contractId)) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("id", String.valueOf(bgModule.getId()));
                map.put("title", String.valueOf(bgModule.getTitle()));
                list.add(map);
            }
            this.dataMap.put("contractModules", list);
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    public void newsList() throws Exception {
        int contractId = Utils.parseInt((String)this.request.getParameter("contractId"), (int)0);
        if (contractId > 0) {
            Connection con = this.setup.getDBConnection();
            Contract contract = ContractDao.getContract(con, contractId);
            if (contract != null) {
                ArrayList list = new ArrayList();
                for (News newsItem : new NewsManager(con).getNewsList(this.setup, null, contractId)) {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    map.put("id", String.valueOf(newsItem.getId()));
                    map.put("date", TimeUtils.format((Date)newsItem.getDate(), (String)"dd.MM.yyyy"));
                    map.put("title", (String)new CDATA(newsItem.getTitle()));
                    map.put("body", (String)new CDATA(newsItem.getBody()));
                    list.add(map);
                }
                this.dataMap.put("newsList", list);
            } else {
                this.setError(1, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
        } else {
            this.setError(3, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        }
    }

    protected void paymentList(SearchResult<Payment> searchResult) throws Exception {
        Connection con = this.setup.getDBConnection();
        PaymentTypeDao paymentTypeDao = new PaymentTypeDao(con);
        Map<Integer, PaymentType> paymentTypeMap = paymentTypeDao.getTypeMapByIds(null);
        paymentTypeDao.close();
        DecimalFormat decimalFormat = new DecimalFormat(this.setup.get("web.api.contract.payment.sum.format.pattern", "###,###,###,###.00"));
        ArrayList list = new ArrayList();
        for (Payment payment : searchResult.getList()) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("id", String.valueOf(payment.getId()));
            map.put("typeId", String.valueOf(payment.getTypeId()));
            PaymentType paymentType = paymentTypeMap.get(payment.getTypeId());
            map.put("typeTitle", paymentType == null ? "???" : paymentType.getTitle());
            map.put("date", TimeUtils.format((Date)payment.getDate(), (String)"dd.MM.yyyy"));
            map.put("comment", payment.getComment());
            map.put("sum", decimalFormat.format(payment.getSum()));
            list.add(map);
        }
        this.dataMap.put("contractPayments", list);
        this.dataMap.put("totalSum", decimalFormat.format(searchResult.getSum()));
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }
}

