/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax.ConaxRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax.ConaxSubscribeAddRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.conax.ConaxSubscribeCancelRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ConaxConnection {
    private String host;
    private int port;
    private String username;
    private String password;
    private String pwdroot;
    private FTPClient ftp = null;
    private static final String AUTREQ_REQ = "autreq/req";

    public ConaxConnection(ParameterMap preferences, int serverId) throws BGException {
        this.host = preferences.get("host", null);
        this.port = preferences.getInt("port", 21);
        this.username = preferences.get("username", "anonymous");
        this.password = preferences.get("password", "");
        this.pwdroot = preferences.get("pwdroot", ".");
        if (Utils.isEmptyString((String)this.host) || this.port <= 0) {
            throw new BGException("Host or port for server " + serverId + " undefined!");
        }
    }

    public void connect() throws IOException {
        this.ftp = new FTPClient();
        this.ftp.connect(this.host, this.port);
        int reply = this.ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            this.ftp.disconnect();
            throw new IOException("FTP server refused connection.");
        }
        if (!this.ftp.login(this.username, this.password)) {
            this.ftp.disconnect();
            throw new IOException("FTP server login attempt failed.");
        }
        if (!this.ftp.changeWorkingDirectory(this.pwdroot)) {
            String rs = this.ftp.getReplyString().trim();
            this.ftp.logout();
            this.ftp.disconnect();
            throw new IOException("FTP server change working directory '" + this.pwdroot + "' failed (" + rs + ").");
        }
        this.ftp.setFileType(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void request(ConaxRequest request) throws IOException {
        String filename = request.makeFileName();
        String body = request.makeRequest();
        try (InputStream local = null;){
            local = new ByteArrayInputStream(body.getBytes("ASCII"));
            String dstFileName = "autreq/req/" + filename;
            if (!this.ftp.storeFile(dstFileName + ".tmp", local)) {
                throw new IOException("FTP server store file failed (" + this.ftp.getReplyString().trim() + ").");
            }
            if (!this.ftp.rename(dstFileName + ".tmp", dstFileName)) {
                throw new IOException("FTP server rename file failed (" + this.ftp.getReplyString().trim() + ").");
            }
        }
    }

    public void disconnect() {
        if (this.ftp != null) {
            try {
                this.ftp.logout();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.ftp.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void cancelAllAuthorization(int transactionId, long cardCode) {
    }

    public void cancelAuthorization(int transactionId, long cardNumber, int packetId, Date startTime, Date endTime) throws IOException {
        ConaxSubscribeCancelRequest request = new ConaxSubscribeCancelRequest();
        request.setTransactionId(transactionId);
        request.setPacketId(packetId);
        request.setBegin(startTime);
        request.setEnd(endTime);
        request.setCards(Arrays.asList(cardNumber));
        this.request(request);
    }

    public void addAuthorization(int transactionId, long cardNumber, int packetId, Date startTime, Date endTime) throws IOException {
        ConaxSubscribeAddRequest request = new ConaxSubscribeAddRequest();
        request.setTransactionId(transactionId);
        request.setPacketId(packetId);
        request.setBegin(startTime);
        request.setEnd(endTime);
        request.setCards(Arrays.asList(cardNumber));
        this.request(request);
    }
}

