/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterGroup;
import ru.bitel.common.model.Id;

public class RegisterGroupManager
extends AbstractIdDao<RegisterGroup> {
    private static final String TABLE_REGISTER_GROUP = "register_group";

    public RegisterGroupManager(Connection con) {
        super(con, TABLE_REGISTER_GROUP);
    }

    public int deleteGroup(int id) throws SQLException {
        this.deleteGroupTaskTypes(id);
        return this.delete(id);
    }

    public void updateGroup(RegisterGroup registerGroup) throws SQLException {
        this.updateImpl(registerGroup);
    }

    public RegisterGroup getGroupById(int id) throws SQLException {
        return (RegisterGroup)this.get(id);
    }

    public List<RegisterGroup> getGroupList() throws SQLException {
        return this.getGroupList(0);
    }

    public List<RegisterGroup> getGroupList(int taskTypeId) throws SQLException {
        ArrayList<RegisterGroup> result = new ArrayList<RegisterGroup>();
        StringBuilder query = new StringBuilder("SELECT * FROM ").append(TABLE_REGISTER_GROUP);
        if (taskTypeId > 0) {
            query.append(" LEFT JOIN register_group_task_type AS tt ON id=tt.gid WHERE type_id=?");
        }
        query.append(" ORDER BY title");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (taskTypeId > 0) {
                ps.setInt(1, taskTypeId);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        return result;
    }

    public void updateGroupTaskTypes(int groupId, List<Integer> types) throws SQLException {
        String query = "INSERT INTO register_group_task_type SET gid=?, type_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            this.deleteGroupTaskTypes(groupId);
            ps.setInt(1, groupId);
            for (Integer typeId : types) {
                ps.setInt(2, typeId);
                ps.executeUpdate();
            }
        }
    }

    public void deleteGroupTaskTypes(int groupId) throws SQLException {
        String query = "DELETE FROM register_group_task_type WHERE gid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, groupId);
            ps.executeUpdate();
        }
    }

    public List<Integer> getGroupTaskTypes(int groupId) throws SQLException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String query = "SELECT type_id FROM register_group_task_type WHERE gid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, groupId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getInt(1));
                }
            }
        }
        return result;
    }

    public Map<Integer, RegisterGroup> getGroupMap() throws SQLException {
        HashMap<Integer, RegisterGroup> result = new HashMap<Integer, RegisterGroup>();
        String query = "SELECT * FROM register_group";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                RegisterGroup group = this.getFromRS(rs);
                result.put(group.getId(), group);
            }
        }
        return result;
    }

    protected RegisterGroup getFromRS(ResultSet rs) throws SQLException {
        return RegisterGroup.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setEmail(rs.getString("email")).build();
    }

    protected void updateImpl(RegisterGroup registerGroup) throws SQLException {
        String querySet = "title=?, email=?";
        try (PreparedStatement ps = this.prepareStatement((Id)registerGroup, querySet);){
            int index = 1;
            ps.setString(index++, registerGroup.getTitle());
            ps.setString(index++, registerGroup.getEmail());
            this.executeUpdate((Id)registerGroup, index, ps);
        }
    }
}

