/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.bean.condition;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.DispatchSaldoCondition;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.bgbilling.plugins.dispatch.server.bean.condition.base.DispatchConditionChecker;

public class DispatchSaldoConditionChecker
implements DispatchConditionChecker {
    @Override
    public boolean check(Connection con, DispatchCondition condition, Dispatch d, Subscription subscribe) throws Exception {
        boolean result = false;
        DispatchSaldoCondition saldoCondition = (DispatchSaldoCondition)condition;
        try (BalanceUtils bu = new BalanceUtils(con);){
            BigDecimal contractSaldo = bu.getSaldo(new Date(), subscribe.getContractId());
            result = !(saldoCondition.getSaldoFrom() != null && contractSaldo.compareTo(saldoCondition.getSaldoFrom()) < 0 || saldoCondition.getSaldoTo() != null && contractSaldo.compareTo(saldoCondition.getSaldoTo()) > 0);
        }
        return result;
    }
}

