/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.list;

import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.GuiTitlable;

public class BGUKeySelectionListener<I extends GuiTitlable>
extends KeyAdapter
implements KeyListener {
    private Popup popup = null;
    private String pattern = null;
    private final BGUList<I> list;
    private List<I> items;

    public BGUKeySelectionListener(BGUList<I> list, List<I> items) {
        this.list = list;
        this.items = items;
        list.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BGUKeySelectionListener.this.showPatternPopup();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BGUKeySelectionListener.this.hidePatternPopup();
            }
        });
    }

    void showPatternPopup() {
        this.hidePatternPopup();
        String pattern = this.getPattern();
        if (pattern != null) {
            Point p = this.list.getParent().getLocationOnScreen();
            JToolTip toolTip = new JToolTip();
            toolTip.setTipText(pattern);
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.popup = popupFactory.getPopup(this.list, toolTip, p.x, p.y - toolTip.getPreferredSize().height);
            this.popup.show();
        }
    }

    private void hidePatternPopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void keyTyped(KeyEvent e) {
        char ch = e.getKeyChar();
        if (ch == '\u001b') {
            this.pattern = null;
        } else {
            if (ch == '\n' || !Character.isDefined(ch)) {
                return;
            }
            if (ch == '\b') {
                if (this.pattern != null && this.pattern.length() > 1) {
                    this.pattern = this.pattern.substring(0, this.pattern.length() - 1);
                } else {
                    if (this.pattern == null || this.pattern.length() != 1) return;
                    this.pattern = null;
                }
            } else {
                this.pattern = this.pattern == null ? ("" + ch).toLowerCase() : (this.pattern + ch).toLowerCase();
            }
        }
        this.showPatternPopup();
        this.list.setFilterList(this.pattern);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int selectionForKey(char ch) {
        int currentSelection = 0;
        Object selectedItem = this.list.getSelectedValue();
        if (selectedItem != null) {
            int c = this.items.size();
            for (int i = 0; i < c; ++i) {
                if (selectedItem != this.items.get(i)) continue;
                currentSelection = i;
                break;
            }
        }
        if (ch == '\u001b') {
            this.pattern = null;
            return -1;
        }
        if (!Character.isDefined(ch)) {
            return -1;
        }
        if (ch == '\b') {
            if (this.pattern != null && this.pattern.length() > 1) {
                this.pattern = this.pattern.substring(0, this.pattern.length() - 1);
                return this.find(currentSelection);
            }
            if (this.pattern == null) return -1;
            if (this.pattern.length() != 1) return -1;
            this.pattern = null;
            return -1;
        }
        this.pattern = this.pattern == null ? ("" + ch).toLowerCase() : (this.pattern + ch).toLowerCase();
        return this.find(currentSelection);
    }

    public final int find(int currentSelection) {
        int i;
        int c = this.items.size();
        for (i = currentSelection; i < c; ++i) {
            String v;
            I elem = this.items.get(i);
            if (elem == null || elem.toString() == null || (v = elem.toString().toLowerCase()).length() <= 0 || v.indexOf(this.pattern) < 0) continue;
            return i;
        }
        for (i = 0; i <= currentSelection; ++i) {
            String v;
            I elem = this.items.get(i);
            if (elem == null || elem.toString() == null || (v = elem.toString().toLowerCase()).length() <= 0 || v.indexOf(this.pattern) < 0) continue;
            return i;
        }
        return -1;
    }

    public final int findNext(boolean down) {
        int i;
        int c;
        int currentSelection = -1;
        Object selectedItem = this.list.getSelectedValue();
        if (selectedItem != null) {
            c = this.items.size();
            for (i = 0; i < c; ++i) {
                if (selectedItem != this.items.get(i)) continue;
                currentSelection = i;
                break;
            }
        }
        if (down) {
            c = this.items.size();
            for (i = ++currentSelection; i < c; ++i) {
                String v;
                I elem = this.items.get(i);
                if (elem == null || elem.toString() == null || (v = elem.toString().toLowerCase()).length() <= 0 || v.indexOf(this.pattern) < 0) continue;
                return i;
            }
        } else {
            for (i = --currentSelection; i >= 0; --i) {
                String v;
                I elem = this.items.get(i);
                if (elem == null || elem.toString() == null || (v = elem.toString().toLowerCase()).length() <= 0 || v.indexOf(this.pattern) < 0) continue;
                return i;
            }
        }
        return -1;
    }

    public String getPattern() {
        return this.pattern;
    }
}

