/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import java.sql.Connection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.ConnectionHolder;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.common.worker.WorkerThreadFactory;

final class EventListenerThreadContext
extends EventListenerContext {
    protected EventListenerThreadContext(ServerContext parent, String applicationName) {
        super(parent, applicationName);
    }

    @Override
    public ConnectionSet getConnectionSet() {
        assert (this.connectionSet != null);
        if (this.connectionSet == null) {
            ThreadContext ctx = ThreadContext.get();
            if (ctx instanceof ConnectionHolder && ctx != this) {
                Connection con = ((ConnectionHolder)ctx).getConnection();
                this.connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (Connection)con, (boolean)true);
                return this.connectionSet;
            }
            this.connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
            return this.connectionSet;
        }
        return this.connectionSet;
    }

    public static ExecutorService newExecutorService(final EventProcessor ep, int count, int queue) {
        ThreadContextFactory<ThreadContext> threadContextFactory = new ThreadContextFactory<ThreadContext>(){

            public ThreadContext newThreadContext() {
                return new EventListenerContext(ep.setup, 0, ep.applicationName);
            }
        };
        RejectedExecutionHandler callerRuns = new RejectedExecutionHandler((ThreadContextFactory)threadContextFactory){
            final /* synthetic */ ThreadContextFactory val$threadContextFactory;
            {
                this.val$threadContextFactory = threadContextFactory;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                if (!e.isShutdown()) {
                    if (r instanceof WorkerTask) {
                        WorkerTask w = (WorkerTask)r;
                        ThreadContext context = this.val$threadContextFactory.newThreadContext();
                        context.init();
                        try {
                            w.setContext(context);
                            w.run();
                            w.setContext(null);
                        }
                        finally {
                            context.destroy();
                        }
                    } else {
                        r.run();
                    }
                }
            }
        };
        return WorkerTask.newFixedThreadPool((String)"event-proc", (String)"mq", (ThreadContextFactory)threadContextFactory, (int)count, (int)Math.max(queue, 8), (RejectedExecutionHandler)callerRuns);
    }

    public static WorkerThreadFactory<ThreadContext> newThreadFactory(final EventProcessor ep, String name) {
        ThreadContextFactory<ThreadContext> threadContextFactory = new ThreadContextFactory<ThreadContext>(){

            public ThreadContext newThreadContext() {
                return new EventListenerContext(ep.setup, 0, ep.applicationName);
            }
        };
        return new WorkerThreadFactory(name, "mq", (ThreadContextFactory)threadContextFactory);
    }

    public static ExecutorService newExecutorService(EventProcessor ep, String name, int count, int queue) {
        WorkerThreadFactory<ThreadContext> threadFactory = EventListenerThreadContext.newThreadFactory(ep, name);
        return new ThreadPoolExecutor(count, count, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new ArrayBlockingQueue<Runnable>(Math.max(queue, 8)), (ThreadFactory)threadFactory, (RejectedExecutionHandler)new WorkerTask.BlockingExecutionHandler());
    }
}

