/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.softline.common.bean.SotfLineProductCategory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ProductCategoryDao
extends AbstractIdDao<SotfLineProductCategory> {
    public ProductCategoryDao(Connection connection, int moduleId) {
        this(connection, "softline_product_category", moduleId);
    }

    public ProductCategoryDao(Connection con, String tableName, int moduleId) {
        super(con, tableName, moduleId);
    }

    public void getList(SearchResult<SotfLineProductCategory> searchResult) throws SQLException {
        List result = searchResult.getList();
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + Page.toSqlLimit((Page)page);
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
        }
    }

    protected SotfLineProductCategory getFromRS(ResultSet rs) throws SQLException {
        SotfLineProductCategory productCategory = new SotfLineProductCategory();
        productCategory.setId(rs.getInt("id"));
        productCategory.setTitle(rs.getString("title"));
        productCategory.setDescription(rs.getString("description"));
        return productCategory;
    }

    protected void updateImpl(SotfLineProductCategory productCategory) throws SQLException {
        Objects.requireNonNull(productCategory);
        boolean update = productCategory.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, description=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, productCategory.getTitle());
            ps.setString(index++, productCategory.getDescription());
            if (update) {
                ps.setInt(index, productCategory.getId());
            }
            ps.executeUpdate();
            if (!update) {
                productCategory.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

