/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tinkoff.server.event.worker;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.tinkoff.server.event.TinkoffCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class TinkoffCheckEventWorker
extends EventWorker {
    private final int moduleId;
    private TransactionManager transactionManager;

    public TinkoffCheckEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), TinkoffCheckEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 10000L;
        this.getLogger().info("Starting TinkoffCheckEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "tinkoff-check-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        try {
            this.transactionManager.doResend();
            TinkoffCheckEvent event = (TinkoffCheckEvent)((Object)task);
            this.transactionManager.doCheckRequest(event.getContractId(), event.isAutopaymentTransaction());
            return null;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

