/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vepay.server.event.worker;

import java.math.BigDecimal;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.vepay.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.vepay.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.vepay.server.event.VepayAutopaymentEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class VepayAutopaymentEventWorker
extends EventWorker {
    private final int moduleId;
    private TransactionManager transactionManager;
    private AutopaymentManager autopaymentManager;

    public VepayAutopaymentEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), VepayAutopaymentEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 60000L;
        this.getLogger().info("Starting VepayAutopaymentEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "vepay-autopayment-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.autopaymentManager = new AutopaymentManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        try {
            VepayAutopaymentEvent event = (VepayAutopaymentEvent)((Object)task);
            int contractId = event.getContractId();
            Autopayment autopayment = this.autopaymentManager.getCurrentAutopayment(contractId);
            BigDecimal sum = event.getSum();
            if (sum == null) {
                sum = autopayment.getSum();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("sum = " + String.valueOf(sum));
                this.getLogger().debug("contractId = " + contractId);
                this.getLogger().debug("autopayment = " + String.valueOf(autopayment));
            }
            if (autopayment != null && autopayment.getMode().getCode() == event.getMode()) {
                this.transactionManager.doRecurrentRequest(contractId, sum, autopayment.getAccessToken());
            }
            return null;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

