/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.service;

import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Channel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.PacketChannel;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.StatusEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.CardPacketService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.AddCheck;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.ChannelManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketChannelManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.StatusEventManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.TariffRequestManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.SubscriptionChangedEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.task.Recalculator;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.cerbercrypt.common.service.CardPacketService")
public class CardPacketServiceImpl
extends AbstractService
implements CardPacketService {
    private Map<Integer, List<PacketChannel>> channelPacketMap = null;

    public List<CardPacket> cardPacketTable(int objectId, int usercardId, Date date, boolean isVirtualCinema, int contractId) throws Exception {
        if (contractId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ArrayList<CardPacket> table = new ArrayList<CardPacket>();
        UserCardManager userCardManager = new UserCardManager(this.getConnection(), this.moduleId, 0);
        Map<Integer, UserCard> cardMap = userCardManager.getUserCardMap(contractId);
        Map<Integer, Packet> packetMap = new PacketManager(this.getConnection(), this.moduleId).getPacketMap();
        StatusEventManager eventManager = new StatusEventManager(this.getConnection(), this.moduleId);
        GregorianCalendar now = new GregorianCalendar();
        List<CardPacket> list = new CardPacketManager(this.getConnection(), this.moduleId).getCardPacketList(contractId, usercardId, objectId, date, isVirtualCinema);
        TariffRequestManager trm = new TariffRequestManager(this.getConnectionSet(), this.moduleId);
        for (CardPacket cardPacket : list) {
            UserCard card;
            Packet packet = packetMap.get(cardPacket.getPacketId());
            table.add(cardPacket);
            StatusEvent lastEvent = eventManager.getLastEventBefore(cardPacket.getId(), now);
            if (lastEvent != null) {
                cardPacket.setChange_date(lastEvent.getTime());
            }
            if (packet != null) {
                cardPacket.setPacketTitle(packet.getTitle());
                if (packet.isVirtualCinema()) {
                    if (date != null) {
                        cardPacket.setCost(BigDecimal.valueOf(trm.getSubscriptionCost(contractId, date, packetMap, Collections.singletonList(cardPacket), false)));
                    } else {
                        cardPacket.setCost(null);
                    }
                }
            } else {
                cardPacket.setPacketTitle("???");
            }
            if ((card = cardMap.get(cardPacket.getUsercardId())) != null) {
                cardPacket.setCardNumber(card.getNumber());
                continue;
            }
            cardPacket.setCardNumber(0L);
        }
        return table;
    }

    public List<CardPacket> cardPacketFutureList(int contractId, int userCardId, Date now) throws Exception {
        return new CardPacketManager(this.getConnection(), this.moduleId).getFutureCardPacketList(contractId, userCardId, now);
    }

    public List<StatusEvent> cardPacketStatusTable(int cardPacketId) throws Exception {
        if (cardPacketId <= 0) {
            throw new BGIllegalArgumentException();
        }
        StatusEventManager eventManager = new StatusEventManager(this.getConnection(), this.moduleId);
        List<StatusEvent> list = eventManager.getEvents(cardPacketId);
        return list;
    }

    public void deleteCardPacket(int cid, int cardPacketId, boolean check) throws Exception {
        if (cardPacketId <= 0) {
            throw new BGIllegalArgumentException();
        }
        PacketManager pm = new PacketManager(this.getConnection(), this.moduleId);
        CardPacketManager cpm = new CardPacketManager(this.getConnection(), this.moduleId);
        CardPacket cp = cpm.getCardPacketById(cardPacketId);
        Calendar closedDate = null;
        if (cp != null && (closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionDeleteCardPacket", (int)this.moduleId, (int)this.userId)) != null) {
            ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Date)cp.getDateFrom());
        }
        if (cid == -1) {
            cid = cp.getContractId();
        } else if (cid != cp.getContractId()) {
            throw new BGIllegalArgumentException();
        }
        HashMap<Integer, Packet> packetMap = new HashMap<Integer, Packet>();
        for (Packet packet : pm.getPacketList()) {
            packetMap.put(packet.getId(), packet);
        }
        Packet packet = (Packet)packetMap.get(cp.getPacketId());
        if (packet == null) {
            throw new BGMessageException("\u043f\u0430\u043a\u0435\u0442\u0430 \u043d\u0435\u0442");
        }
        if (!packet.isVirtualCinema()) {
            cpm.removeCardPackets(this.getConnectionSet(), (ParameterMap)this.getModuleSetup(), packetMap, cid, cp.getUsercardId(), Collections.singletonList(cp), new GregorianCalendar(), check);
            SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.userId, this.moduleId, cid, cp.getUsercardId(), 1, 3, cp.getPacketId(), null);
            this.context.publishAfterCommit((Event)event);
            new UserCardManager(this.getConnection(), this.moduleId, this.userId).updateSubscribe(new Date(), cp.getUsercardId(), true);
        } else {
            cpm.deleteCardPacket(cardPacketId);
        }
    }

    public CardPacket getCardPacket(int cardPacketId) throws Exception {
        if (cardPacketId <= 0) {
            throw new BGIllegalArgumentException("cardPacketId <= 0");
        }
        return new CardPacketManager(this.getConnection(), this.moduleId).getCardPacketById(cardPacketId);
    }

    public void changeStatus(int cardPacketId, int status, Date date) throws Exception {
        if (cardPacketId <= 0 || status <= 0 || date == null) {
            throw new BGIllegalArgumentException("cardPacketId <= 0 || status <= 0 || date == null");
        }
        CardPacketManager cardPacketManager = new CardPacketManager(this.getConnection(), this.moduleId);
        CardPacket cardPacket = cardPacketManager.getCardPacketById(cardPacketId);
        if (cardPacket != null) {
            if (cardPacket.getDateFrom() != null && TimeUtils.dateBefore((Date)date, (Date)cardPacket.getDateFrom()) || cardPacket.getDateTo() != null && TimeUtils.dateBefore((Date)cardPacket.getDateTo(), (Date)date)) {
                throw new BGMessageException("\u0414\u0430\u0442\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043f\u0430\u043a\u0435\u0442\u0430!");
            }
            StatusEventManager eventManager = new StatusEventManager(this.getConnection(), this.moduleId);
            StatusEvent event = StatusEvent.builder().setCardPacketId(cardPacketId).setTime(TimeUtils.convertDateToCalendar((Date)date)).setStatus(status).setUserId(this.userId).build();
            eventManager.addEvent(cardPacket, event);
            new UserCardManager(this.getConnection(), this.moduleId, this.userId).updateSubscribe(date, cardPacket.getUsercardId(), false);
        }
    }

    protected void checkPeriod(Date date1, Date date2) throws Exception {
        boolean result;
        boolean bl = result = date1 == null || date2 == null || TimeUtils.dateBeforeOrEq((Date)date1, (Date)date2);
        if (!result) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434!");
        }
    }

    private Map<Integer, List<PacketChannel>> getChannelPacketMap(Map<Integer, Packet> packetMap) throws Exception {
        Map<Integer, List<PacketChannel>> result = this.channelPacketMap;
        if (result == null) {
            result = new HashMap<Integer, List<PacketChannel>>();
            PacketChannelManager pcm = new PacketChannelManager(this.getConnection(), this.moduleId);
            for (Packet p : packetMap.values()) {
                List<PacketChannel> pcList = pcm.getPacketChannelList(p.getId());
                result.put(p.getId(), pcList);
            }
            this.channelPacketMap = result;
        }
        return result;
    }

    public Object[] hasChannelFromPacket(CardPacketManager cpm, Map<Integer, Packet> packetMap, int cid, int usercardId, int packetId, Date now, Set<Integer> withoutPackets) throws Exception {
        Map<Integer, List<PacketChannel>> channelPacketMap = this.getChannelPacketMap(packetMap);
        List<CardPacket> list = cpm.getCardPacketList(cid, usercardId, now, false);
        List<PacketChannel> addSet = channelPacketMap.get(packetId);
        for (CardPacket cp : list) {
            List<PacketChannel> set = channelPacketMap.get(cp.getPacketId());
            if (set == null || withoutPackets != null && withoutPackets.contains(cp.getPacketId())) continue;
            for (PacketChannel i : addSet) {
                for (PacketChannel s : set) {
                    if (i.getChannelId() != s.getChannelId() || !TimeUtils.dateInRange((Date)now, (Date)s.getDateFrom(), (Date)s.getDateTo()) || !TimeUtils.dateInRange((Date)now, (Date)i.getDateFrom(), (Date)i.getDateTo())) continue;
                    Channel c = new ChannelManager(this.getConnection(), this.moduleId).getChannelById(i.getChannelId());
                    return new Object[]{packetMap.get(cp.getPacketId()), c};
                }
            }
        }
        return null;
    }

    private boolean errorPeriodCardpacket(Date cardPacketDateFrom, Date cardPacketDateTo, Date userCardDate1, Date userCardDate2) {
        return cardPacketDateFrom == null && userCardDate1 != null || cardPacketDateTo == null && userCardDate2 != null || cardPacketDateFrom != null && userCardDate1 != null && TimeUtils.dateBefore((Date)cardPacketDateFrom, (Date)userCardDate1) || cardPacketDateTo != null && userCardDate2 != null && TimeUtils.dateBefore((Date)userCardDate2, (Date)cardPacketDateTo);
    }

    public void updateCardPacket(CardPacket _cardPacket, boolean check, int date1Hour) throws Exception {
        Object[] objectArray;
        int id = _cardPacket.getId();
        Calendar date1 = TimeUtils.convertDateToCalendar((Date)_cardPacket.getDateFrom());
        Calendar date2 = TimeUtils.convertDateToCalendar((Date)_cardPacket.getDateTo());
        String comment = _cardPacket.getComment();
        this.checkPeriod(_cardPacket.getDateFrom(), _cardPacket.getDateTo());
        int userCardId = _cardPacket.getUsercardId();
        int packetId = _cardPacket.getPacketId();
        int cid = _cardPacket.getContractId();
        if (_cardPacket.getContractId() <= 0 || id < 0 || userCardId <= 0 || packetId <= 0) {
            throw new BGIllegalArgumentException();
        }
        TariffRequestManager trm = new TariffRequestManager(this.getConnectionSet(), this.moduleId);
        UserCardManager userCardManager = new UserCardManager(this.getConnection(), this.moduleId, this.userId);
        PacketManager pm = new PacketManager(this.getConnection(), this.moduleId);
        Map<Integer, Packet> packetMap = pm.getPacketMap();
        Packet packet = pm.getPacketById(packetId);
        if (packet == null) {
            throw new BGMessageException("\u0422\u0430\u043a\u043e\u0433\u043e \u043f\u0430\u043a\u0435\u0442\u0430 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
        }
        if (packet.isVirtualCinema() && date1 == null) {
            throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438");
        }
        CardPacketManager cardPacketManager = new CardPacketManager(this.getConnection(), this.moduleId);
        CardPacket cardPacket = null;
        if (id == 0 || packet.isVirtualCinema()) {
            cardPacket = new CardPacket();
        } else {
            cardPacket = cardPacketManager.getCardPacketById(id);
            if (cardPacket == null) {
                throw new BGIllegalArgumentException();
            }
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionUpdateCardPacket", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)cardPacket.getDateFrom(), (Date)cardPacket.getDateTo(), (Date)TimeUtils.convertCalendarToDate((Calendar)date1), (Date)TimeUtils.convertCalendarToDate((Calendar)date2));
        }
        GregorianCalendar now = new GregorianCalendar();
        if (packet.isVirtualCinema()) {
            int nowHour = now.get(11);
            now.set(11, 0);
            now.set(12, 0);
            now.set(13, 0);
            now.set(14, 0);
            date1.set(11, 0);
            date1.set(12, 0);
            date1.set(13, 0);
            date1.set(14, 0);
            if (date1.before(now)) {
                throw new BGMessageException("\u0414\u0430\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u043e\u0448\u043b\u043e\u043c.");
            }
            now.set(11, nowHour);
            date1.set(11, date1Hour);
            if (((Calendar)now).equals(date1) || now.after(date1)) {
                date1 = new GregorianCalendar();
            }
            date2 = (Calendar)date1.clone();
            date2.add(5, 1);
        }
        cardPacket.setContractId(cid);
        cardPacket.setPacketId(packetId);
        cardPacket.setUsercardId(userCardId);
        cardPacket.setDateFrom(TimeUtils.convertCalendarToDate((Calendar)date1));
        cardPacket.setDateTo(TimeUtils.convertCalendarToDate((Calendar)date2));
        cardPacket.setComment(comment);
        UserCard userCard = (UserCard)userCardManager.get(userCardId);
        if (this.errorPeriodCardpacket(cardPacket.getDateFrom(), cardPacket.getDateTo(), userCard.getDate1(), userCard.getDate2())) {
            throw new BGMessageException("\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043f\u0430\u043a\u0435\u0442\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043a\u0430\u0440\u0442\u044b");
        }
        List<CardPacket> cardPacketList = Collections.unmodifiableList(cardPacketManager.getCardPacketList(cid, userCardId, now.getTime(), false));
        List<CardPacket> futureCardPacketList = Collections.unmodifiableList(cardPacketManager.getFutureCardPacketList(cid, userCardId, now.getTime()));
        HashMap<Integer, CardPacket> cardPacketMap = new HashMap<Integer, CardPacket>();
        for (CardPacket cardPacket2 : cardPacketList) {
            cardPacketMap.put(cardPacket2.getPacketId(), cardPacket2);
        }
        HashMap<Integer, CardPacket> futureCardPacketMap = new HashMap<Integer, CardPacket>();
        for (CardPacket cp3 : futureCardPacketList) {
            futureCardPacketMap.put(cp3.getPacketId(), cp3);
        }
        if (id == 0 && this.getModuleSetup().getInt("cerbercrypt.cardpacket.addcheck", AddCheck.OPEN.getCode()) >= AddCheck.ADD.getCode() && (objectArray = this.hasChannelFromPacket(cardPacketManager, packetMap, cid, userCardId, packetId, TimeUtils.convertCalendarToDate((Calendar)date1), null)) != null) {
            Packet p = (Packet)objectArray[0];
            Channel c = (Channel)objectArray[1];
            throw new BGMessageException("\u041a\u0430\u043d\u0430\u043b " + (c != null ? c.getTitle() : "null") + " \u0432 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u043c \u043f\u0430\u043a\u0435\u0442\u0435 " + packet.getTitle() + " \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442 \u0432 \u043f\u0430\u043a\u0435\u0442\u0435 " + p.getTitle());
        }
        if (packet.isVirtualCinema()) {
            if (cardPacketManager.getCardPacket(userCardId, packetId, TimeUtils.convertCalendarToDate((Calendar)date1)) != null) {
                throw new BGMessageException("\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0438\u043d\u043e\u0437\u0430\u043b \u0443\u0436\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u043d\u0430 \u044d\u0442\u043e\u0442 \u043f\u0435\u0440\u0438\u043e\u0434!");
            }
            float f = trm.getSubscriptionCost(cid, TimeUtils.convertCalendarToDate((Calendar)date1), packetMap, Collections.singletonList(cardPacket), true);
            if (Float.isNaN(f)) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0446\u0435\u043d\u0430 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0430\u043a\u0435\u0442\u0430: " + packet.getTitle());
            }
            cardPacketManager.updateCardPacket(cardPacket);
        } else {
            List<CardPacket> list = cardPacketManager.checkConflictSamePackets(userCardId, packetId, cardPacket.getDateFrom(), cardPacket.getDateTo(), cardPacket.getId());
            if (Utils.notEmptyCollection(list)) {
                String confl = list.stream().map(cp -> TimeUtils.formatPeriod((Date)cp.getDateFrom(), (Date)cp.getDateTo()) + " (#" + cp.getId() + ")").collect(Collectors.joining("\n"));
                throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 \"" + packet.getTitle() + "\" \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442 \u0432 \u044d\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435 \u043d\u0430 \u043a\u0430\u0440\u0442\u0435 \"" + userCard.getNumber() + "\"!\n\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u044b: " + confl);
            }
            cardPacketManager.updateCardPackets(this.getConnectionSet(), (ParameterMap)this.getModuleSetup(), packetMap, cid, cardPacket.getUsercardId(), Collections.singletonList(cardPacket), now, check);
            SubscriptionChangedEvent event = null;
            event = id <= 0 ? new SubscriptionChangedEvent(this.userId, this.moduleId, cid, cardPacket.getUsercardId(), 1, 1, cardPacket.getPacketId(), TimeUtils.convertCalendarToDate((Calendar)date1)) : new SubscriptionChangedEvent(this.userId, this.moduleId, cid, cardPacket.getUsercardId(), 1, 4, cardPacket.getPacketId(), null);
            this.context.publishAfterCommit((Event)event);
        }
        userCardManager.updateSubscribe(new Date(), cardPacket.getUsercardId(), true);
        if (packet.isVirtualCinema()) {
            new RunTaskDataManager(this.getConnection()).addTask((RunTask)new Recalculator(this.moduleId, TimeUtils.convertDateToCalendar((Date)cardPacket.getDateFrom()), null, String.valueOf(cid), "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043f\u0430\u043a\u0435\u0442\u0430"));
        }
    }

    public void openCardPackets(String cards, String packets, Date date, int cid, boolean check) throws Exception {
        if (cid <= 0 || Utils.isBlankString((String)cards) || Utils.isBlankString((String)packets) || date == null) {
            throw new BGIllegalArgumentException("cid <= 0 || Utils.isBlankString( cards ) || Utils.isBlankString( packets ) || date == null");
        }
        UserCardManager userCardManager = new UserCardManager(this.getConnection(), this.moduleId, this.userId);
        CardPacketManager cardPacketManager = new CardPacketManager(this.getConnection(), this.moduleId);
        PacketManager packetManager = new PacketManager(this.getConnection(), this.moduleId);
        Map<Integer, Packet> packetMap = packetManager.getPacketMap();
        List userCardIdList = Utils.toIntegerList((String)cards);
        List packetIdList = Utils.toIntegerList((String)packets);
        int checkOpen = this.getModuleSetup().getInt("cerbercrypt.cardpacket.addcheck", AddCheck.OPEN.getCode());
        for (Integer userCardId : userCardIdList) {
            for (Integer packetId : packetIdList) {
                Object[] pkt;
                Packet p = packetMap.get(packetId);
                if (checkOpen >= AddCheck.OPEN.getCode() && (pkt = this.hasChannelFromPacket(cardPacketManager, packetMap, cid, userCardId, packetId, date, null)) != null) {
                    Packet pak = (Packet)pkt[0];
                    Channel c = (Channel)pkt[1];
                    throw new BGMessageException("\u041a\u0430\u043d\u0430\u043b " + (c != null ? c.getTitle() : "null") + " \u0432 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u043c \u043f\u0430\u043a\u0435\u0442\u0435 " + p.getTitle() + " \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442 \u0432 \u043f\u0430\u043a\u0435\u0442\u0435 " + pak.getTitle());
                }
                List<CardPacket> findCp = cardPacketManager.checkConflictSamePackets(userCardId, packetId, date, null, null);
                if (!Utils.notEmptyCollection(findCp)) continue;
                throw new BGMessageException("\u041f\u0430\u043a\u0435\u0442 " + p.getTitle() + " \u0443\u0436\u0435 \u043e\u0442\u043a\u0440\u044b\u0442 \u043d\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443!\n\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0443\u0435\u0442 \u0441: " + Utils.toString(findCp, (String)"\n"));
            }
            UserCard userCard = (UserCard)userCardManager.get(userCardId);
            if (!this.errorPeriodCardpacket(date, null, userCard.getDate1(), userCard.getDate2())) continue;
            throw new BGMessageException("\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043f\u0430\u043a\u0435\u0442\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043a\u0430\u0440\u0442\u044b \"" + userCard.getTitle() + "\"");
        }
        GregorianCalendar now = new GregorianCalendar();
        StringBuilder errors = new StringBuilder();
        for (Integer userCardId : userCardIdList) {
            ArrayList<CardPacket> add = new ArrayList<CardPacket>();
            HashSet<Integer> userCards = new HashSet<Integer>();
            HashSet<Integer> packetIds = new HashSet<Integer>();
            for (Integer packetId : packetIdList) {
                Packet p = packetMap.get(packetId);
                if (cardPacketManager.getCardPacket(userCardId, packetId, date) != null || p == null || p.isVirtualCinema()) continue;
                CardPacket cardPacket = new CardPacket();
                cardPacket.setContractId(cid);
                cardPacket.setDateFrom(date);
                cardPacket.setUsercardId(userCardId.intValue());
                cardPacket.setPacketId(packetId.intValue());
                add.add(cardPacket);
                userCards.add(userCardId);
                packetIds.add(packetId);
            }
            try {
                cardPacketManager.openCardPackets(this.getConnectionSet(), (ParameterMap)this.getModuleSetup(), packetMap, cid, userCardId, add, now, check);
                SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.moduleId, cid, userCards, 1, 1, packetIds, date);
                this.context.publishAfterCommit((Event)event);
                userCardManager.updateSubscribe(date, userCardId, true);
            }
            catch (BGMessageException e) {
                errors.append(e.getMessage()).append("\n");
            }
        }
        if (errors.length() > 0) {
            errors.setLength(errors.length() - 1);
            throw new BGMessageException(errors.toString());
        }
    }

    public void closeCardPackets(String cards, String packets, Date date, int cid, boolean check) throws Exception {
        if (cid <= 0 || Utils.isBlankString((String)cards) || Utils.isBlankString((String)packets) || date == null) {
            throw new BGIllegalArgumentException("cid <= 0 || Utils.isBlankString( cards ) || Utils.isBlankString( packets ) || date == null");
        }
        Calendar nextDay = TimeUtils.convertDateToCalendar((Date)date);
        nextDay.add(6, 1);
        UserCardManager userCardManager = new UserCardManager(this.getConnection(), this.moduleId, this.userId);
        CardPacketManager cardPacketManager = new CardPacketManager(this.getConnection(), this.moduleId);
        PacketManager packetManager = new PacketManager(this.getConnection(), this.moduleId);
        Map<Integer, Packet> packetMap = packetManager.getPacketMap();
        StringBuilder errors = new StringBuilder();
        for (Integer cardId : Utils.toIntegerList((String)cards)) {
            ArrayList<CardPacket> close = new ArrayList<CardPacket>();
            HashSet<Integer> userCards = new HashSet<Integer>();
            HashSet<Integer> packetIds = new HashSet<Integer>();
            for (Integer packet : Utils.toIntegerList((String)packets)) {
                Packet p = packetMap.get(packet);
                if (p != null && p.isVirtualCinema()) continue;
                CardPacket cardPacket = null;
                cardPacket = cardPacketManager.getCardPacket(cardId, packet, nextDay.getTime());
                if (cardPacket == null || cardPacket.getDateTo() != null && !date.before(cardPacket.getDateTo())) continue;
                close.add(cardPacket);
                userCards.add(cardId);
                packetIds.add(cardPacket.getPacketId());
            }
            try {
                cardPacketManager.closeCardPackets(this.getConnectionSet(), (ParameterMap)this.getModuleSetup(), packetMap, cid, cardId, close, date, new GregorianCalendar(), check);
                SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.moduleId, cid, userCards, 1, 2, packetIds, date);
                this.context.publishAfterCommit((Event)event);
                userCardManager.updateSubscribe(date, cardId, true);
            }
            catch (BGMessageException e) {
                errors.append(e.getMessage()).append("\n");
            }
        }
        if (errors.length() > 0) {
            errors.setLength(errors.length() - 1);
            throw new BGMessageException(errors.toString());
        }
    }

    public void syncCardPackets(UserCard ucFrom, UserCard ucTo, Date date, boolean includeUncopyable) throws Exception {
        if (ucFrom == null || ucTo == null) {
            throw new BGIllegalArgumentException("user cards not set -> ucFrom == null || ucTo == null");
        }
        if (ucFrom.getContractId() != ucTo.getContractId()) {
            throw new BGIllegalArgumentException("user cards different contracts");
        }
        TariffRequestManager tariffRequestManager = new TariffRequestManager(this.getConnectionSet(), this.moduleId);
        CardPacketManager cardPacketManager = new CardPacketManager(this.getConnection(), this.moduleId);
        Set<Integer> ignorePackets = includeUncopyable ? null : tariffRequestManager.getMultiroomIgnorePacket((ParameterMap)this.getModuleSetup(), ucFrom.getContractId(), Calendar.getInstance());
        cardPacketManager.synchronizeCardPacketFromTo(ucFrom.getId(), ucTo.getId(), ignorePackets, date);
    }
}

