/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.email.common.bean.AttributeValue;

public class AttributeValueManager
extends AbstarctDaoConstant {
    public AttributeValueManager(Connection con, int moduleId) {
        super(con, "email_attribute", moduleId);
    }

    public List<AttributeValue> getValueList(int accountId) throws SQLException {
        ArrayList<AttributeValue> result = new ArrayList<AttributeValue>();
        String query = "SELECT * FROM " + this.tableName + " WHERE aid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, accountId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getValueFromRs(rs));
                }
            }
        }
        return result;
    }

    public void updateValues(int accountId, List<AttributeValue> valueList) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE aid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, accountId);
            ps.executeUpdate();
        }
        query = "INSERT INTO " + this.tableName + " (aid, attr_id, value) VALUES (?, ?, ?)";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, accountId);
            for (AttributeValue value : valueList) {
                ps.setInt(2, value.getAttributeId());
                ps.setString(3, value.getAttributeValue());
                ps.executeUpdate();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private AttributeValue getValueFromRs(ResultSet rs) throws SQLException {
        AttributeValue result = new AttributeValue();
        result.setAttributeId(rs.getInt("attr_id"));
        result.setAttributeValue(rs.getString("value"));
        return result;
    }
}

