/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.util.Calendar;
import ru.bitel.bgbilling.common.BGException;

class ModelPeriod {
    public static final int MODE_NONE = 0;
    public static final int MODE_WEEK = 1;
    public static final int MODE_MONTH = 2;
    public static final int MODE_YEAR = 3;
    public static final int SUB_MODE_NONE = 0;
    public static final int SUB_MODE_LAST_WEEK = 1;
    public static final int SUB_MODE_CURRENT_WEEK = 2;
    public static final int SUB_MODE_NEXT_WEEK = 3;
    public static final int SUB_MODE_LAST_MONTH = 4;
    public static final int SUB_MODE_CURRENT_MONTH = 5;
    public static final int SUB_MODE_NEXT_MONTH = 6;
    public static final int SUB_MODE_LAST_YEAR = 7;
    public static final int SUB_MODE_CURRENT_YEAR = 8;
    public static final int SUB_MODE_NEXT_YEAR = 9;
    private int mode = 0;
    private int subMode = 0;

    ModelPeriod() {
    }

    public Calendar getDateSubMode(Calendar calendar, boolean begin) throws BGException {
        switch (this.subMode) {
            case 1: {
                return this.getWeek(calendar, -1, begin);
            }
            case 2: {
                return this.getWeek(calendar, 0, begin);
            }
            case 3: {
                return this.getWeek(calendar, 1, begin);
            }
            case 4: {
                return this.getMonth(calendar, -1, begin);
            }
            case 5: {
                return this.getMonth(calendar, 0, begin);
            }
            case 6: {
                return this.getMonth(calendar, 1, begin);
            }
            case 7: {
                return this.getYear(calendar, -1, begin);
            }
            case 8: {
                return this.getYear(calendar, 0, begin);
            }
            case 9: {
                return this.getYear(calendar, 1, begin);
            }
        }
        throw new BGException(" wrong period from mode");
    }

    public Calendar getDateToMode(Calendar calendar, boolean forward, boolean begin) throws BGException {
        switch (this.mode) {
            case 0: {
                return null;
            }
            case 1: {
                return this.getWeek(calendar, forward ? 1 : -1, begin);
            }
            case 2: {
                return this.getMonth(calendar, forward ? 1 : -1, begin);
            }
            case 3: {
                return this.getYear(calendar, forward ? 1 : -1, begin);
            }
        }
        throw new BGException(" wrong period from mode");
    }

    private Calendar getWeek(Calendar calendar, int delta, boolean begin) {
        Calendar date = Calendar.getInstance();
        date.setTime(calendar.getTime());
        date.add(3, delta);
        date.set(7, begin ? 2 : 1);
        return date;
    }

    private Calendar getMonth(Calendar calendar, int delta, boolean begin) {
        return this.getDate(calendar, delta, begin, 2, 5);
    }

    private Calendar getYear(Calendar calendar, int delta, boolean begin) {
        return this.getDate(calendar, delta, begin, 1, 6);
    }

    private Calendar getDate(Calendar calendar, int delta, boolean begin, int field, int subField) {
        Calendar date = Calendar.getInstance();
        date.setTime(calendar.getTime());
        date.add(field, delta);
        date.set(subField, begin ? 1 : date.getActualMaximum(subField));
        return date;
    }

    public Calendar daysOperation(Calendar calendar, boolean add, int countDays) {
        Calendar date = Calendar.getInstance();
        date.setTime(calendar.getTime());
        date.add(6, add ? countDays : -countDays);
        return date;
    }

    public int getSubMode() {
        return this.subMode;
    }

    public void setSubMode(int subMode) {
        this.subMode = subMode;
    }

    public void resetSubMode() {
        this.subMode = 0;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void resetMode() {
        this.mode = 0;
    }

    public void resetDetectMode(Calendar dateFrom, Calendar dateTo) {
        this.mode = 0;
        this.subMode = 0;
        if (dateFrom == null || dateTo == null || dateFrom.get(5) != 1) {
            return;
        }
        if (dateFrom.get(2) == 0 && dateTo.get(5) == 31 && dateTo.get(2) == 11 && dateTo.get(1) == dateFrom.get(1)) {
            this.mode = 3;
            return;
        }
        if (dateTo.get(5) == dateTo.getActualMaximum(5) && dateTo.get(2) == dateFrom.get(2) && dateTo.get(1) == dateFrom.get(1)) {
            this.mode = 2;
            return;
        }
    }
}

