/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.server.service;

import bitel.billing.server.contract.bean.CommentPatternManager;
import jakarta.jws.WebService;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerAccount;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerContract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerPropertyParam;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerContactType;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerEmployee;
import ru.bitel.bgbilling.kernel.customer.common.service.CustomerService;
import ru.bitel.bgbilling.kernel.customer.server.event.CustomerChangedEvent;
import ru.bitel.bgbilling.kernel.customer.server.event.CustomerCreatedEvent;
import ru.bitel.bgbilling.kernel.customer.server.event.CustomerDeletedEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.customer.common.service.CustomerService")
public class CustomerServiceImpl
extends AbstractService
implements CustomerService {
    @Override
    public List<CustomerEmployee> customerEmployeeList(int customerId) throws BGException {
        return this.tryReturn(() -> new CustomerDao(this.getConnection()).customerEmployeeList(customerId));
    }

    @Override
    public String customerEmployeeUpdate(int customerId, CustomerEmployee customerEmployee) throws BGException {
        return this.tryReturn(() -> new CustomerDao(this.getConnection()).customerEmployeeUpdate(customerId, customerEmployee, this.userId));
    }

    @Override
    public String customerEmployeeDelete(int customerId, String customerEmployeeUUID) throws BGException {
        return this.tryReturn(() -> new CustomerDao(this.getConnection()).customerEmployeeDelete(customerId, customerEmployeeUUID, this.userId));
    }

    @Override
    public Customer customerByAccount(long account) throws BGException {
        return this.tryReturn(() -> new CustomerDao(this.getConnection()).customerByCustomerAccount(account));
    }

    @Override
    public SearchResult<Customer> searchCustomerList(Customer.CustomerType customerType, List<KeyValue> filters, Page page, String[] sort) throws BGException {
        return this.tryReturn(() -> {
            SearchResult<Customer> searchResult = new SearchResult<Customer>(page, sort);
            new CustomerDao(this.getConnection()).searchCustomer(searchResult, customerType, filters);
            return searchResult;
        });
    }

    @Override
    public List<CustomerAccount> customerAccounts(int customerId) throws BGException {
        return this.tryReturn(() -> new CustomerDao(this.getConnection()).customerAccounts(customerId));
    }

    @Override
    public CustomerAccount customerAccountAdd(int customerId, long account) throws BGException {
        return this.tryReturn(() -> new CustomerDao(this.getConnection()).customerAccountAdd(customerId, account, this.userId));
    }

    @Override
    public void customerAccountSet(int customerId, int contractId, long account) throws BGException {
        this.tryCall(() -> new CustomerDao(this.getConnection()).customerAccountSet(customerId, contractId, account));
    }

    @Override
    public void customerAccountDelete(int customerId, long account) throws BGException {
        this.tryCall(() -> new CustomerDao(this.getConnection()).customerAccountDelete(customerId, account));
    }

    @Override
    public String customerParameterGet(int contractId) throws BGException {
        return this.tryReturn(() -> {
            JSONObject customer = new JSONObject();
            Contract contract = this.getContract(contractId);
            if (contract != null) {
                customer.put("personType", (Object)(contract.getPersonType() == 0 ? "f" : "u")).put("domainId", contract.getDomainId());
                CustomerDao customerDao = new CustomerDao(this.getConnection());
                Optional<CustomerLink> customerLink = customerDao.getCustomerLink(contractId, LocalDateTime.now());
                if (customerLink.isPresent()) {
                    int customerId = customerLink.get().getCustomerId();
                    customer.put("customerId", customerId).put("customerAccount", customerLink.get().getCustomerAccount()).put("customer", (Object)customerDao.getCustomerDataJson(customerId).optJSONObject("customer"));
                }
            }
            return customer.toString();
        });
    }

    @Override
    public String customerParameterUpdate(int customerId, String fieldKey, String fieldValue) throws BGException {
        return this.tryReturn(() -> {
            Connection con = this.getConnection();
            CustomerDao customerDao = new CustomerDao(con);
            String value = customerDao.updateCustomerFieldValue(customerId, fieldKey, fieldValue, this.userId);
            EventProcessor.getInstance().publish(new CustomerChangedEvent(customerId, this.userId, fieldKey, fieldValue));
            List<CustomerContract> contracts = customerDao.getCustomerContracts(customerId, LocalDateTime.now());
            if (!contracts.isEmpty()) {
                CommentPatternManager commentPatternManager = new CommentPatternManager(con);
                contracts.forEach(contract -> {
                    try {
                        commentPatternManager.updateContractComment(contract.getContractId());
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                });
            }
            return value;
        });
    }

    @Override
    public String customerContactUpdate(int customerId, CustomerContactType contactType, String text) throws BGException {
        return this.tryReturn(() -> {
            String result = new CustomerDao(this.getConnection()).updateCustomerContact(customerId, contactType, text, this.userId);
            EventProcessor.getInstance().publish(new CustomerChangedEvent(customerId, this.userId, contactType.key, text));
            return result;
        });
    }

    @Override
    public String customerBankUpdate(int customerId, String text) throws BGException {
        return this.tryReturn(() -> {
            String result = new CustomerDao(this.getConnection()).updateCustomerBank(customerId, text, this.userId);
            EventProcessor.getInstance().publish(new CustomerChangedEvent(customerId, this.userId, "/customer/bank", text));
            return result;
        });
    }

    @Override
    public int customerNewSet(int contractId) throws BGException {
        return this.tryReturn(() -> {
            CustomerDao customerDao = new CustomerDao(this.getConnection());
            Optional<CustomerLink> customerLink = customerDao.getCustomerLink(contractId, LocalDateTime.now());
            if (customerLink.isPresent()) {
                return customerLink.get().getCustomerId();
            }
            Contract contract = this.getContract(contractId);
            if (contract != null) {
                int customerId = customerDao.getNewCustomerId(contract.getPersonType() == 0 ? Customer.CustomerType.FIZ_CUSTOMER : Customer.CustomerType.JUR_CUSTOMER);
                EventProcessor.getInstance().publish(new CustomerCreatedEvent(customerId, this.userId));
                CustomerLink newCustomerLink = CustomerLink.builder().setContractId(contractId).setCustomerId(customerId).setPeriod(new PeriodWithTime(LocalDateTime.now(), null)).build();
                customerDao.addCustomerLink(newCustomerLink);
                return customerId;
            }
            return 0;
        });
    }

    @Override
    public void customerDelete(int customerId) throws BGException {
        this.tryCall(() -> {
            CustomerDao customerDao = new CustomerDao(this.getConnection());
            Customer customer = customerDao.getCustomer(customerId);
            if (customer.getContractCount() > 0) {
                throw new BGMessageException("\u041a \u043a\u043b\u0438\u0435\u043d\u0442\u0443 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            }
            customerDao.deleteCustomer(customerId);
            EventProcessor.getInstance().publish(new CustomerDeletedEvent(customerId, this.userId));
        });
    }

    @Override
    public String customerSearch(Customer.CustomerType customerType, String text) throws BGException {
        return this.tryReturn(() -> {
            if (text == null || text.isBlank()) {
                return "[]";
            }
            JSONArray array = new JSONArray();
            CustomerDao customerDao = new CustomerDao(this.getConnection());
            String txt = text.trim();
            if (customerType == Customer.CustomerType.JUR_CUSTOMER && txt.matches("^([0-9]{10}|[0-9]{10})$")) {
                array = customerDao.searchByKey(Customer.CustomerType.JUR_CUSTOMER, Customer.Keys.INN.key(), txt);
            } else if (customerType == Customer.CustomerType.FIZ_CUSTOMER && txt.matches("^[0-9]{12}$")) {
                array = customerDao.searchByKey(Customer.CustomerType.FIZ_CUSTOMER, Customer.Keys.INN.key(), txt);
            } else if (customerType == Customer.CustomerType.FIZ_CUSTOMER && txt.matches("^[0-9]{6}$")) {
                array = customerDao.searchByKey(Customer.CustomerType.FIZ_CUSTOMER, Customer.CustomerFizDocument.PASSPORT_RF_NUMBER.key(), txt);
            } else if (customerType == Customer.CustomerType.FIZ_CUSTOMER && txt.matches("^[0-9]{4}\\s*[0-9]{6}$")) {
                String serial = txt.substring(0, 4);
                String number = txt.substring(txt.length() - 6);
                array = customerDao.searchByKey(Customer.CustomerType.FIZ_CUSTOMER, Customer.CustomerFizDocument.PASSPORT_RF_NUMBER.key(), number);
                if (array.length() > 0) {
                    JSONArray array2 = new JSONArray();
                    array.forEach(a -> {
                        JSONObject json = (JSONObject)a;
                        String passport = json.optString("passport", "");
                        if (passport.length() > 6 && passport.startsWith(serial)) {
                            array2.put((Object)json);
                        }
                    });
                    array = array2;
                }
            }
            return array.toString();
        });
    }

    @Override
    public void customerLinkSet(int contractId, int \u0441ustomerId) throws BGException {
        this.tryCall(() -> {
            new CustomerDao(this.getConnection()).setCustomerLink(contractId, \u0441ustomerId, LocalDateTime.now());
            new CommentPatternManager(this.getConnection()).updateContractComment(contractId);
        });
    }

    @Override
    public List<CustomerContract> customerContracts(int customerId, LocalDateTime onTime) throws BGException {
        return this.tryReturn(() -> new CustomerDao(this.getConnection()).getCustomerContracts(customerId, onTime));
    }

    @Override
    public boolean customerUnlinkContract(int contractId, LocalDateTime unlinkTime) throws BGException {
        return this.tryReturn(() -> {
            boolean result = new CustomerDao(this.getConnection()).setCustomerUnlinkContract(contractId, unlinkTime);
            if (result) {
                new CommentPatternManager(this.getConnection()).updateContractComment(contractId);
            }
            return result;
        });
    }

    @Override
    public String customerParameterHistory(int customerId, String fieldKey, int lastRecordCount) throws BGException {
        return this.tryReturn(() -> new CustomerDao(this.getConnection()).getCustomerParameterHistory(customerId, fieldKey, lastRecordCount));
    }

    @Override
    public List<String> customerEmails(int customerId, int contractId) throws BGException {
        return this.tryReturn(() -> {
            JSONObject jsonObject;
            JSONObject contact;
            ArrayList list = new ArrayList();
            CustomerDao customerDao = new CustomerDao(this.getConnection());
            int localCustomerid = customerId;
            if (localCustomerid < 1) {
                Optional<CustomerLink> optional = customerDao.getCustomerLink(contractId, LocalDateTime.now());
                if (optional.isPresent()) {
                    localCustomerid = optional.get().getCustomerId();
                } else {
                    return list;
                }
            }
            if ((contact = (JSONObject)(jsonObject = customerDao.getCustomerDataJson(localCustomerid)).query("/customer/contact")) != null && contact.has("email")) {
                contact.optJSONArray("email").forEach(a -> list.add(((JSONObject)a).optString("value")));
            }
            return list;
        });
    }

    @Override
    public List<CustomerPropertyParam> customerPropertyParams(int customerId) throws BGException {
        return this.tryReturn(() -> {
            Setup setup = Setup.getSetup();
            JSONObject jsonObject = new CustomerDao(this.getConnection()).getCustomerDataJson(customerId);
            JSONObject properties = (JSONObject)jsonObject.optQuery("/customer/properties");
            if (properties == null) {
                properties = new JSONObject();
            }
            ArrayList<CustomerPropertyParam> params = new ArrayList<CustomerPropertyParam>();
            for (String key : Utils.toList(setup.get("customer.properties.keys"))) {
                CustomerPropertyParam param = new CustomerPropertyParam().setKey(key).setType(setup.get("customer.properties." + key + ".type", "string")).setTitle(setup.get("customer.properties." + key + ".title", key)).setValue(properties.optString(key, ""));
                params.add(param);
            }
            return params;
        });
    }
}

