/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.ContractUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

@Deprecated
public class ChargeManager {
    private Connection con;

    public ChargeManager(Connection con) {
        this.con = con;
    }

    public Charge getChargeById(int id) throws SQLException {
        Charge result = null;
        String query = "SELECT * FROM contract_charge WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getChargeFromRs(rs);
                }
            }
        }
        return result;
    }

    public List<Charge> getChargeList(int cid, int chargeTypeId, Period period, int members) throws SQLException {
        ArrayList<Charge> result = new ArrayList<Charge>();
        String cids = ContractUtils.getCidsStringForQuery(cid, members, this.con);
        if (cids == null) {
            return result;
        }
        Date dateFrom = null;
        Date dateTo = null;
        if (period != null) {
            dateFrom = period.getDateFrom();
            dateTo = period.getDateTo();
        }
        StringBuilder query = new StringBuilder("SELECT c.id, c.cid, c.comment, c.dt, c.pt, c.summa, c.uid, c.lm FROM contract_charge c WHERE c.cid IN(" + cids + ")");
        if (chargeTypeId > 0) {
            query.append(" AND c.pt=?");
        }
        if (dateFrom != null) {
            query.append(" AND c.dt >= ?");
        } else if (dateTo != null) {
            query.append(" AND c.dt <= ?");
        }
        query.append(" ORDER BY dt");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        int index = 1;
        if (chargeTypeId > 0) {
            ps.setInt(index++, chargeTypeId);
        }
        if (dateFrom != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)dateFrom));
        } else if (dateTo != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)dateTo));
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(this.getChargeFromRs(rs));
        }
        rs.close();
        ps.close();
        return result;
    }

    public List<Charge> getChargeList(int cid, int chargeTypeId, Period period) throws SQLException {
        return this.getChargeList(cid, chargeTypeId, period, 1);
    }

    public List<Charge> getChargeList(int cid) throws SQLException {
        return this.getChargeList(cid, -1);
    }

    public List<Charge> getChargeList(int cid, int chargeTypeId) throws SQLException {
        return this.getChargeList(cid, chargeTypeId, null, 1);
    }

    public void deleteCharge(int id) throws SQLException {
        String query = "DELETE FROM contract_charge WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }

    public void updateCharge(Charge charge) throws BGException {
        if (charge == null) {
            throw new BGException("Charge is null!");
        }
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            if (charge.getId() <= 0) {
                query = "INSERT INTO contract_charge SET dt=?, cid=?, pt=?, uid=?, summa=?, comment=?";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE contract_charge SET dt=?, cid=?, pt=?, uid=?, summa=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
            }
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)charge.getDate()));
            ps.setInt(index++, charge.getContractId());
            ps.setInt(index++, charge.getTypeId());
            ps.setInt(index++, charge.getUserId());
            ps.setBigDecimal(index++, charge.getSum());
            ps.setString(index++, charge.getComment());
            if (charge.getId() > 0) {
                ps.setInt(index++, charge.getId());
            }
            ps.executeUpdate();
            if (charge.getId() <= 0) {
                charge.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public Map<Integer, String> getTypeTitleMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        String query = "SELECT id,title FROM contract_charge_types";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                map.put(rs.getInt("id"), rs.getString("title"));
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    private Charge getChargeFromRs(ResultSet rs) throws SQLException {
        return Charge.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setComment(rs.getString("comment")).setDate(rs.getDate("dt")).setTypeId(rs.getInt("pt")).setSum(rs.getBigDecimal("summa")).setUserId(rs.getInt("uid")).setTimeChange(rs.getTimestamp("lm")).build();
    }
}

