/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGComponentBorder;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelContractSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelDate;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCreateData;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternMasterDialog;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.ContractPatternInfo;
import ru.bitel.bgbilling.kernel.contract.pattern.common.service.ContractPatternService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGDialog;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.action.BGUAction;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class PatternSelectedDialog
extends BGDialog {
    public static final int MODE_NEW = 1;
    public static final int MODE_WRAP = 2;
    private int mode = 1;
    private int contractId = -1;
    private int responseContractId = 0;
    private BGUList<ContractPatternInfo> patternList = new BGUList();
    private BGControlPanelDate controlPanelDate = new BGControlPanelDate();
    private BGComboBox<ComboBoxItem> subModeCombo = new BGComboBox();
    private BGControlPanelContractSelect superContractSelect = new BGControlPanelContractSelect(false, true);
    private BGControlPanelListSelect paramsList = new BGControlPanelListSelect();
    private BGTextField contractTitle = new BGTextField();
    private JCheckBox manually = new JCheckBox("\u0412\u0440\u0443\u0447\u043d\u0443\u044e");
    private JCheckBox subName;

    public PatternSelectedDialog(int mode, int contractId) {
        this.mode = mode;
        this.contractId = contractId;
        try {
            this.setLayout(new BorderLayout());
            this.setModal(true);
            this.setResizable(true);
            this.add(this.getContractPatternListPanel(), "West");
            this.add(this.getParamPanel(), "East");
            this.add(this.getButtonPanel(), "South");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.setData();
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private JPanel getContractPatternListPanel() throws Exception {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421\u043f\u0438\u0441\u043e\u043a \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.patternList, (int)400, (int)450), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 15, 5, 15), 0, 0));
        return panel;
    }

    private JTabbedPane getParamPanel() throws Exception {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.controlPanelDate.setButtonNow(true);
        this.controlPanelDate.setButtonMove(true);
        JPanel datePanel = new JPanel(new GridBagLayout());
        datePanel.add((Component)this.controlPanelDate, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel titlePanel = new JPanel(new GridBagLayout());
        if (this.mode == 1) {
            this.setTitle("\u0412\u044b\u0431\u043e\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0434\u043b\u044f \u043d\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            this.contractTitle.setEditable(false);
            this.contractTitle.setText("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430");
            this.manually.addActionListener(e -> {
                this.contractTitle.setEditable(this.manually.isSelected());
                this.getTitlePattern();
            });
            titlePanel.setBorder((Border)new BGTitleBorder("\u0428\u0430\u0431\u043b\u043e\u043d \u0438\u043c\u0435\u043d\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
            titlePanel.add((Component)this.manually, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 3, 2), 0, 0));
            titlePanel.add((Component)this.contractTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        } else if (this.mode == 2) {
            this.setTitle("\u0412\u044b\u0431\u043e\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0434\u043b\u044f \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0438\u043c\u0435\u043d\u0438");
        }
        JPanel paramPanel = new JPanel(new GridBagLayout());
        paramPanel.add((Component)this.paramsList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        paramPanel.setVisible(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)datePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)titlePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        if (this.mode == 1) {
            JPanel selectSuperPanel = new JPanel(new GridBagLayout());
            JCheckBox checkBox1 = new JCheckBox("\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0434\u043b\u044f", true);
            JCheckBox checkBox2 = new JCheckBox("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u043a\u0430\u043a \u0421\u0423\u0411\u0414\u041e\u0413\u041e\u0412\u041e\u0420 \u0434\u043b\u044f ...", false);
            JCheckBox copyParamsChB = new JCheckBox("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", false);
            selectSuperPanel.setVisible(false);
            selectSuperPanel.setBorder((Border)new BGComponentBorder((Component)checkBox1, (JComponent)selectSuperPanel, (Border)BorderFactory.createTitledBorder("")));
            selectSuperPanel.add((Component)this.subModeCombo, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            selectSuperPanel.add((Component)this.superContractSelect, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            selectSuperPanel.add((Component)copyParamsChB, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 5, 5), 0, 0));
            this.subModeCombo.addItem((Object)new ComboBoxItem(0, "\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441"));
            this.subModeCombo.addItem((Object)new ComboBoxItem(1, "\u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0431\u0430\u043b\u0430\u043d\u0441"));
            panel.add((Component)selectSuperPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)checkBox2, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            checkBox1.addActionListener(e -> {
                selectSuperPanel.setVisible(false);
                checkBox2.setVisible(true);
                checkBox2.setSelected(false);
                if (paramPanel.isVisible()) {
                    copyParamsChB.doClick();
                }
            });
            checkBox2.addActionListener(e -> {
                selectSuperPanel.setVisible(true);
                checkBox2.setVisible(false);
                checkBox1.setSelected(true);
                this.subModeCombo.requestFocus();
            });
            copyParamsChB.addActionListener(e -> {
                String contracId = this.superContractSelect.getContracts();
                if (!Utils.notBlankString((String)contracId)) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u043d\u0430\u0447\u0430\u043b\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0441\u0443\u043f\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
                    copyParamsChB.setSelected(false);
                    return;
                }
                if (copyParamsChB.isSelected() && this.patternList.getSelectedValue() == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                    return;
                }
                this.paramsList.getListModel().removeAllElements();
                this.setParams(contracId, copyParamsChB.isSelected());
            });
            this.patternList.addListSelectionListener(e -> {
                this.getTitlePattern();
                this.setParams(this.superContractSelect.getContracts(), copyParamsChB.isSelected());
            });
        } else if (this.mode == 2) {
            this.subName = new JCheckBox("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043b\u044f \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u0440\u043e\u0432", false);
            panel.add((Component)this.subName, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 7, 6, 6), 0, 0));
        }
        panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.setDimension((JComponent)panel, (int)400, (int)450);
        tabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 15));
        tabbedPane.add((Component)panel, "\u041e\u0431\u0449\u0438\u0435");
        tabbedPane.add((Component)paramPanel, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        return tabbedPane;
    }

    private JPanel getButtonPanel() {
        JButton createButton = new JButton((Action)new BGUAction("ok", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c"){

            public void actionPerformed(ActionEvent e) {
                PatternSelectedDialog.this.controlPanel_actionPerformed(e);
            }
        });
        JButton cancelButton = new JButton((Action)new BGUAction("cancel", "\u041e\u0442\u043c\u0435\u043d\u0430"){

            public void actionPerformed(ActionEvent e) {
                PatternSelectedDialog.this.controlPanel_actionPerformed(e);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(Box.createGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)createButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 10, 0), 0, 0));
        panel.add((Component)cancelButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 10, 15), 0, 0));
        return panel;
    }

    public int getId() {
        return this.responseContractId;
    }

    private void getTitlePattern() {
        ContractPatternInfo item = (ContractPatternInfo)((Object)this.patternList.getSelectedValue());
        this.contractTitle.setText(item != null ? item.getTitlePattern() : "");
    }

    public void setData() {
        try {
            List<ContractPatternInfo> patterns = ((ContractPatternService)this.getContext().getWebService(ContractPatternService.class, 0)).contractPatternlist(null);
            this.patternList.setData(patterns);
            String patternId = ClientSetup.getInstance().getUserConfig().get(((Object)((Object)this)).getClass().getName() + ".pattern");
            if (patternId != null) {
                ClientUtils.setListSelection(this.patternList, (int)Utils.parseInt((String)patternId), (int)-1);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void controlPanel_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("ok".equals(actionCommand)) {
            ContractPatternInfo selectedPattern = (ContractPatternInfo)((Object)this.patternList.getSelectedValue());
            if (selectedPattern == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d");
                return;
            }
            if (this.controlPanelDate.getDateCalendar() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u0430\u0442\u0443");
                return;
            }
            ContractCreateData data = ContractCreateData.builder().setPatternId(selectedPattern.getId()).setDateFrom(this.controlPanelDate.getDate()).setContractSuperId(Utils.parseInt((String)this.superContractSelect.getContracts())).setContractSubMode(Utils.parseInt((String)ClientUtils.getIdFromComboBox(this.subModeCombo))).setCopyParameterIds(this.paramsList.getListIds()).setCustomTitle(this.manually.isSelected() ? this.contractTitle.getText().trim() : null).build();
            if ("master".equals(selectedPattern.getPatternMode())) {
                this.setVisible(false);
                PatternMasterDialog patternMasterDialog = new PatternMasterDialog(selectedPattern, data);
                patternMasterDialog.setVisible(true);
                String masterResult = patternMasterDialog.getResult();
                if (masterResult == null) {
                    this.responseContractId = patternMasterDialog.getResultContractId();
                    this.dispose();
                    return;
                }
            }
            if (this.mode == 1) {
                try {
                    this.responseContractId = ((ContractService)this.getContext().getWebService(ContractService.class, 0)).contractCreate(data);
                    this.dispose();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            } else if (this.mode == 2) {
                Request request = new Request();
                request.setModule("contract");
                request.setAttribute("pattern_id", selectedPattern.getId());
                request.setAttribute("date", this.controlPanelDate.getDateString());
                request.setAction("WrapContract");
                request.setContractId(this.contractId);
                request.setAttribute("sub_name", this.subName.isSelected());
                Document doc = TransferManager.getDocument((Request)request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    try {
                        Element contract = XMLUtils.selectElement((Node)doc, (String)"//contract");
                        String tmp = XMLUtils.getAttribute((Element)contract, (String)"id", (String)"-1");
                        this.responseContractId = Utils.parseInt((String)tmp, (int)-1);
                        this.dispose();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                } else {
                    this.responseContractId = 0;
                }
                ClientSetup.getInstance().getUserConfig().set(((Object)((Object)this)).getClass().getName() + ".pattern", String.valueOf(selectedPattern.getId()));
                ClientSetup.getInstance().saveUserConfig();
            }
        } else if ("cancel".equals(actionCommand) || "close".equals(actionCommand)) {
            this.dispose();
        } else if ("help".equals(actionCommand)) {
            this.openHelp(PatternSelectedDialog.class.getName());
        }
    }

    private void setParams(String contractId, boolean show) {
        this.paramsList.getListModel().removeAllElements();
        if (!show) {
            return;
        }
        IdTitle item = (IdTitle)this.patternList.getSelectedValue();
        if (item != null) {
            Request request = new Request();
            request.setModule("contract");
            request.setAction("GetContractParameters");
            request.setAttribute("cid", contractId);
            request.setAttribute("filled", true);
            request.setAttribute("patternId", item.getId());
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                try {
                    ClientUtils.buildList((BGControlPanelListSelect)this.paramsList, (Node)XMLUtils.selectNode((Node)doc, (String)"//params"));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        }
    }
}

