/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductHistory;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;

public class MegafonContractProductHistoryDao
extends AbstractIdDao<MegafonContractProductHistory> {
    public MegafonContractProductHistoryDao(Connection con, int moduleId) {
        super(con, "megafon_contract_product_history", moduleId);
    }

    public Result<MegafonContractProductHistory> list(Page page, String filter, String orderBy, Object ... params) throws SQLException {
        return super.list(page, filter, orderBy, params);
    }

    protected MegafonContractProductHistory getFromRS(ResultSet rs) throws SQLException {
        MegafonContractProductHistory productHistory = new MegafonContractProductHistory();
        productHistory.setId(rs.getInt("id"));
        productHistory.setProductId(rs.getInt("product_id"));
        productHistory.setContractId(rs.getInt("contract_id"));
        productHistory.setOldProductStatus(MegafonContractProductStatus.getStatusByCode((int)rs.getInt("old_product_status")));
        productHistory.setNewProductStatus(MegafonContractProductStatus.getStatusByCode((int)rs.getInt("new_product_status")));
        productHistory.setChangeDate(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("change_date")));
        productHistory.setUserId(rs.getInt("user_id"));
        productHistory.setMegafonOptionId(rs.getInt("option_id"));
        productHistory.setMsisdn(rs.getString("msisdn"));
        productHistory.setAdditionalMsisdn(rs.getString("additional_msisdn"));
        productHistory.setTitle(rs.getString("title"));
        return productHistory;
    }

    protected void updateImpl(MegafonContractProductHistory productHistory) throws SQLException {
        try (PreparedStatement ps = this.prepareStatement((Id)productHistory, "product_id=?, contract_id=?, old_product_status=?, new_product_status=?, change_date=?, user_id=?, option_id=?, msisdn=?, additional_msisdn=?, title=?");){
            int index = 1;
            ps.setInt(index++, productHistory.getProductId());
            ps.setInt(index++, productHistory.getContractId());
            ps.setInt(index++, productHistory.getOldProductStatus() != null ? productHistory.getOldProductStatus().ordinal() : -1);
            ps.setInt(index++, productHistory.getNewProductStatus() != null ? productHistory.getNewProductStatus().ordinal() : -1);
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)productHistory.getChangeDate()));
            ps.setInt(index++, productHistory.getUserId());
            ps.setInt(index++, productHistory.getMegafonOptionId());
            ps.setString(index++, productHistory.getMsisdn());
            ps.setString(index++, productHistory.getAdditionalMsisdn());
            ps.setString(index++, productHistory.getTitle());
            this.executeUpdate((Id)productHistory, index, ps);
        }
    }
}

