/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common.table;

import bitel.billing.common.XMLStreamResolver;
import bitel.billing.module.common.Initable;
import bitel.billing.module.common.table.BGColorCell;
import bitel.billing.module.common.table.BGRadio;
import bitel.billing.module.common.table.BGTableColumn;
import bitel.billing.module.common.table.BGTableColumnVisibility;
import bitel.billing.module.common.table.Button;
import bitel.billing.module.common.table.ButtonTableCellEditor;
import bitel.billing.module.common.table.ColspanTableUI;
import bitel.billing.module.common.table.RadioTableCellEditor;
import bitel.billing.module.common.table.SortTableHeaderRenderer;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.ButtonTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractPanel;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUserTable;
import ru.bitel.bgbilling.kernel.table.common.service.TableService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public class BGTable
extends JTable
implements Initable {
    private static Map<String, int[]> tableWidths = new HashMap<String, int[]>();
    private static Map<String, int[]> tablePositions = new HashMap<String, int[]>();
    private static Map<String, boolean[]> tableVisibility = new HashMap<String, boolean[]>();
    private static ClientContext clientKernelContext = new ClientContext("kernel", 0, 0, "");
    private int parentWidth = Integer.MIN_VALUE;
    private boolean setColumnWidth = false;
    protected List<BGTableColumn> columns = new ArrayList<BGTableColumn>();
    protected DefaultTableModel tableModel = null;
    protected SpannedRowModel spannedRowModel = null;
    protected ResourceBundle resourceBundle = null;
    protected Document doc = null;
    protected String tableId = null;
    protected String module = null;
    protected int inited;
    protected ResourceBundle mainResourceBundle = null;
    protected ResourceBundle userResourceBundle = null;
    protected TableRowSorter<DefaultTableModel> rowSorter = null;
    protected int sortClicks = 0;
    protected int lastClickedColumn = -1;
    protected JPopupMenu popupMenuItems = null;
    private int visibleRowCount = -1;

    @Override
    public void addNotify() {
        super.addNotify();
        Container parent = this;
        while ((parent = parent.getParent()) != null && !(parent instanceof ServiceConfigTabbedPanel) && !(parent instanceof ContractPanel)) {
        }
        if (parent instanceof JComponent && this.getName() != null) {
            BGSwingUtilites.buildPopupMenu(this, parent, this.getName() + ".");
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public BGTable() {
        this.setAutoResizeMode(0);
        this.addHierarchyListener(e -> {
            Container cont;
            JViewport viewport;
            if (this.inited == 0 && (e.getChangeFlags() & 1L) > 0L) {
                Container comp;
                for (comp = e.getChangedParent(); comp != null && !(comp instanceof BGPanel); comp = comp.getParent()) {
                }
                if (comp != null) {
                    ((BGPanel)comp).addInitable(this);
                }
            }
            if (e.getID() == 1400 && (e.getChangeFlags() & 1L) > 0L && e.getChanged() == this && e.getChangedParent() instanceof JViewport && (viewport = (JViewport)(cont = this.getParent())) != null) {
                cont = viewport.getParent();
                if (cont instanceof JScrollPane) {
                    ((JScrollPane)cont).setVerticalScrollBarPolicy(22);
                }
                viewport.addChangeListener(ev -> {
                    if (this.parentWidth != viewport.getWidth()) {
                        this.parentWidth = viewport.getWidth();
                        this.columnWidthsByTableWidth();
                    }
                });
            }
        });
        this.setColumnWidth = true;
        this.setNewTableModel();
    }

    protected TableColumn setColumnProperties(int col, String title, int w1, int w2, int w3) {
        TableColumn tableColumn = null;
        if (col <= this.getColumnModel().getColumnCount()) {
            tableColumn = this.getColumnModel().getColumn(col);
            tableColumn.setHeaderValue(title);
            if (w1 > -1) {
                tableColumn.setMinWidth(w1);
            }
            if (w2 > -1) {
                tableColumn.setPreferredWidth(w2);
            }
            if (w3 > -1) {
                tableColumn.setMaxWidth(w3);
            }
        }
        return tableColumn;
    }

    protected TableColumn setColumnProperties(int col, BGTableColumn tc) {
        TableColumn tableColumn = null;
        if (col <= this.getColumnModel().getColumnCount()) {
            tableColumn = this.getColumnModel().getColumn(col);
            tableColumn.setHeaderValue(tc.getTitle());
            tableColumn.setIdentifier(tc);
            TableCellRenderer cellRenderer = tc.getCellRenderer();
            if (cellRenderer != null) {
                tableColumn.setCellRenderer(cellRenderer);
            }
            if (tc.getColumnsWidth()[0] > -1) {
                tableColumn.setMinWidth(tc.getColumnsWidth()[0]);
            }
            if (tc.getColumnsWidth()[1] > -1) {
                tableColumn.setPreferredWidth(tc.getColumnsWidth()[1]);
            }
            if (tc.getColumnsWidth()[2] > -1) {
                tableColumn.setMaxWidth(tc.getColumnsWidth()[2]);
            }
        }
        return tableColumn;
    }

    public void addRow(Vector<?> rowData) {
        if (this.tableModel != null) {
            this.tableModel.addRow(rowData);
        }
    }

    public void insertRow(int row, Vector<?> rowData) {
        if (row > -1 && this.tableModel != null && row < this.tableModel.getRowCount()) {
            this.tableModel.insertRow(row, rowData);
        }
    }

    public void removeRows() {
        if (this.tableModel != null) {
            if (this.tableModel instanceof BGTableModel) {
                ((BGTableModel)this.tableModel).removeRows();
            } else {
                while (this.tableModel.getRowCount() > 0) {
                    this.tableModel.removeRow(0);
                }
            }
        }
    }

    public void removeRow(int row) {
        if (row > -1 && row < this.tableModel.getRowCount()) {
            this.tableModel.removeRow(row);
        }
        this.revalidate();
    }

    public DefaultTableModel getBGTableModel() {
        return this.tableModel;
    }

    public void setHeader(String baseName, String table_id) {
        String prefix;
        String title;
        if (baseName == null || table_id == null) {
            return;
        }
        this.tableId = table_id;
        this.setNewTableModel();
        try {
            String selection = ClientUtils.getValueFromResourceBundle(baseName, "table." + table_id + ".selection");
            this.setSelectionMode(Integer.parseInt(selection));
        }
        catch (Exception selection) {
            // empty catch block
        }
        int i = 0;
        while ((title = ClientUtils.getValueFromResourceBundle(baseName, (prefix = "table." + table_id + ".column." + i + ".").concat("title"))) != null) {
            int[] w = new int[]{-1, -1, -1, -1};
            String w1 = null;
            String w2 = null;
            String w3 = null;
            String width = ClientUtils.getValueFromResourceBundle(baseName, prefix.concat("width"));
            if (width != null) {
                StringTokenizer st = new StringTokenizer(width, ",");
                if (st.hasMoreTokens()) {
                    w1 = st.nextToken().trim();
                }
                if (st.hasMoreTokens()) {
                    w2 = st.nextToken().trim();
                }
                if (st.hasMoreTokens()) {
                    w3 = st.nextToken().trim();
                }
            } else {
                w1 = ClientUtils.getValueFromResourceBundle(baseName, prefix.concat("w1"));
                w2 = ClientUtils.getValueFromResourceBundle(baseName, prefix.concat("w2"));
                w3 = ClientUtils.getValueFromResourceBundle(baseName, prefix.concat("w3"));
            }
            w[0] = Utils.parseInt(w1, -1);
            w[3] = w[1] = Utils.parseInt(w2, -1);
            w[2] = Utils.parseInt(w3, -1);
            String editableValue = ClientUtils.getValueFromResourceBundle(baseName, prefix.concat("editable"), "0");
            String className = ClientUtils.getValueFromResourceBundle(baseName, prefix.concat("class"), "");
            BGTableColumn column = BGTableColumn.getInstance("f" + i, title, w, false, className);
            column.setEditable(editableValue.equals("yes"));
            this.columns.add(column);
            ++i;
        }
        this.tableModel.setColumnCount(this.columns.size());
        for (i = 0; i < this.columns.size(); ++i) {
            BGTableColumn tc = this.columns.get(i);
            this.setColumnProperties(i, tc);
        }
        this.tryInit();
        this.resizeAndRepaint();
    }

    public void setHeader(String baseName, Document doc, String table_id) {
        ResourceBundle rb = null;
        if (baseName != null && (rb = ResourceBundle.getBundle(baseName)) != null && doc != null && table_id != null) {
            this.doc = doc;
            Element table = null;
            String path = "/module/tables/table[@id='" + table_id + "']";
            try {
                table = XMLUtils.selectElement(doc, path);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            this.setHeader(rb, table, table_id);
        }
    }

    public void setHeader(ResourceBundle rb, Element table, String table_id) {
        if (rb != null && table != null && table_id != null) {
            this.setNewTableModel();
            try {
                this.setSelectionMode(Integer.parseInt(table.getAttribute("selection")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setHeader(rb, table.getElementsByTagName("column"), table_id);
        }
    }

    private void setHeader(ResourceBundle rb, NodeList list, String table_id) {
        int i;
        this.rowSorter = new TableRowSorter<DefaultTableModel>(this.tableModel);
        this.setRowSorter(this.rowSorter);
        this.tableId = table_id;
        this.columns.clear();
        for (i = 0; i < list.getLength(); ++i) {
            Element columnElement = (Element)list.item(i);
            String id = XMLUtils.getAttribute(columnElement, "id", null);
            String title = "";
            try {
                title = rb.getString("table." + table_id + ".column." + id + ".title");
            }
            catch (Exception ex) {
                title = "?";
            }
            String width = null;
            String w1 = null;
            String w2 = null;
            String w3 = null;
            width = XMLUtils.getAttribute(columnElement, "width", null);
            if (width != null) {
                StringTokenizer st = new StringTokenizer(width, ",");
                if (st.hasMoreTokens()) {
                    w1 = st.nextToken().trim();
                }
                if (st.hasMoreTokens()) {
                    w2 = st.nextToken().trim();
                }
                if (st.hasMoreTokens()) {
                    w3 = st.nextToken().trim();
                }
            }
            int[] w = new int[4];
            w[0] = Utils.parseInt(w1, -1);
            w[3] = w[1] = Utils.parseInt(w2, -1);
            w[2] = Utils.parseInt(w3, -1);
            BGTableColumn column = BGTableColumn.getInstance(id, title, w, false, XMLUtils.getAttribute(columnElement, "class", ""));
            column.setEditable(XMLUtils.getAttribute(columnElement, "editable", "no").equals("yes"));
            String cellRendererClass = XMLUtils.getAttribute(columnElement, "cellRenderer", null);
            if (cellRendererClass != null) {
                try {
                    column.setCellRenderer((TableCellRenderer)Class.forName(cellRendererClass).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
            this.columns.add(column);
        }
        this.tableModel.setColumnCount(this.columns.size());
        for (i = 0; i < this.columns.size(); ++i) {
            BGTableColumn tc = this.columns.get(i);
            this.setColumnProperties(i, tc);
        }
        this.setSorting(list);
        this.tryInit();
        this.resizeAndRepaint();
    }

    protected void setSorting(NodeList list) {
        if (this.rowSorter != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element columnElement = (Element)list.item(i);
                String type = XMLUtils.getAttribute(columnElement, "sorttype", null);
                if (type == null) {
                    this.rowSorter.setSortable(i, false);
                    continue;
                }
                this.rowSorter.setComparator(i, this.getComparator(type));
                SortTableHeaderRenderer renderer = new SortTableHeaderRenderer();
                renderer.setFont(this.tableHeader.getFont().deriveFont(1));
                this.tableHeader.getColumnModel().getColumn(i).setHeaderRenderer(renderer);
            }
            final BGTable thiz = this;
            this.tableHeader.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        int column = BGTable.this.tableHeader.columnAtPoint(e.getPoint());
                        if (!BGTable.this.rowSorter.isSortable(column)) {
                            return;
                        }
                        if (BGTable.this.lastClickedColumn == -1 || BGTable.this.lastClickedColumn != column) {
                            BGTable.this.sortClicks = -1;
                            thiz.setRowSorter(BGTable.this.rowSorter);
                            BGTable.this.rowSorter.toggleSortOrder(column);
                        }
                        BGTable.this.lastClickedColumn = column;
                        if (BGTable.this.sortClicks == 2) {
                            RowSorter.SortKey sk = new RowSorter.SortKey(column, SortOrder.ASCENDING);
                            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(1);
                            sortKeys.add(sk);
                            BGTable.this.rowSorter.setSortKeys(sortKeys);
                            BGTable.this.sortClicks = 0;
                            return;
                        }
                        if (BGTable.this.sortClicks == 1) {
                            BGTable.this.rowSorter.setSortKeys(null);
                        }
                        ++BGTable.this.sortClicks;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected Comparator<?> getComparator(String type) {
        Comparator<Object> comparator = null;
        if ("string".equals(type)) {
            comparator = new Comparator<String>(this){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            };
        } else if ("integer".equals(type)) {
            comparator = new Comparator<String>(this){

                @Override
                public int compare(String o1, String o2) {
                    Integer i1 = null;
                    Integer i2 = null;
                    try {
                        i1 = Integer.valueOf(o1);
                        i2 = Integer.valueOf(o2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (i1 == null) {
                        return 1;
                    }
                    if (i2 == null) {
                        return -1;
                    }
                    return i1.compareTo(i2);
                }
            };
        } else if ("float".equals(type)) {
            comparator = new Comparator<String>(this){

                @Override
                public int compare(String o1, String o2) {
                    Double d2;
                    Double d1;
                    block3: {
                        d1 = null;
                        d2 = null;
                        try {
                            d1 = Double.valueOf(o1);
                            d1 = Double.valueOf(o2);
                        }
                        catch (Exception ex) {
                            if (d1 == null) {
                                return 1;
                            }
                            if (d2 != null) break block3;
                            return -1;
                        }
                    }
                    return d1.compareTo(d2);
                }
            };
        } else if ("date".equals(type)) {
            comparator = new Comparator<String>(this){

                @Override
                public int compare(String o1, String o2) {
                    Date date1 = TimeUtils.parseDate(o1, "dd.MM.yyyy");
                    Date date2 = TimeUtils.parseDate(o2, "dd.MM.yyyy");
                    if (date1 == null) {
                        return 1;
                    }
                    if (date2 == null) {
                        return -1;
                    }
                    return date1.compareTo(date2);
                }
            };
        } else if ("datetime".equals(type)) {
            comparator = new Comparator<String>(this){

                @Override
                public int compare(String o1, String o2) {
                    try {
                        Date date1 = TimeUtils.parseDate(o1, "dd.MM.yyyy HH:mm:ss");
                        Date date2 = TimeUtils.parseDate(o2, "dd.MM.yyyy HH:mm:ss");
                        if (date1 == null) {
                            return 1;
                        }
                        if (date2 == null) {
                            return -1;
                        }
                        return date1.compareTo(date2);
                    }
                    catch (Exception exception) {
                        return 0;
                    }
                }
            };
        } else if ("period".equals(type)) {
            comparator = new Comparator<String>(this){

                @Override
                public int compare(String o1, String o2) {
                    try {
                        String regex = "(\\d{2}\\.\\d{2}\\.\\d{4})\\s*-{1,}\\s*(\\d{2}\\.\\d{2}\\.\\d{4})";
                        Matcher m1 = Pattern.compile(regex).matcher(o1);
                        Date begin1 = null;
                        Date end1 = null;
                        if (m1.find()) {
                            begin1 = TimeUtils.parseDate(m1.group(1), "dd.MM.yyyy");
                            end1 = TimeUtils.parseDate(m1.group(2), "dd.MM.yyyy");
                        }
                        Matcher m2 = Pattern.compile(regex).matcher(o2);
                        Date begin2 = null;
                        Date end2 = null;
                        if (m2.find()) {
                            begin2 = TimeUtils.parseDate(m2.group(1), "dd.MM.yyyy");
                            end2 = TimeUtils.parseDate(m2.group(2), "dd.MM.yyyy");
                        }
                        if (begin1 == null) {
                            return 1;
                        }
                        if (begin2 == null) {
                            return -1;
                        }
                        int result = begin1.compareTo(begin2);
                        if (result != 0) {
                            return result;
                        }
                        if (end1 == null) {
                            return 1;
                        }
                        if (end2 == null) {
                            return -1;
                        }
                        result = end1.compareTo(end2);
                        return result;
                    }
                    catch (Exception exception) {
                        return 0;
                    }
                }
            };
        } else if ("boolean".equals(type)) {
            comparator = new Comparator<Boolean>(this){

                @Override
                public int compare(Boolean o1, Boolean o2) {
                    return o1.compareTo(o2);
                }
            };
        }
        return comparator;
    }

    public BGTableColumn addColumn(String id, String title, int[] w, boolean editable) {
        BGTableColumn column = BGTableColumn.getInstance(id, title, w, false, "");
        column.setEditable(editable);
        this.addColumn(column);
        return column;
    }

    public void addColumn(BGTableColumn column) {
        this.columns.add(column);
        this.addColumn(new TableColumn());
        int count = this.getColumnCount();
        this.tableModel.setColumnCount(count);
        for (int i = 0; i < this.columns.size(); ++i) {
            BGTableColumn tc = this.columns.get(i);
            this.setColumnProperties(i, tc);
        }
    }

    public void removeColumns() {
        this.tableModel.setColumnCount(0);
        this.columns.clear();
    }

    public void updateData(Node node) {
        int i;
        if (node == null || !node.hasChildNodes()) {
            return;
        }
        Node data = null;
        NodeList list = node.getChildNodes();
        for (i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            String childNodeName = childNode.getNodeName();
            if (childNodeName == null || !"data".equals(childNodeName)) continue;
            data = childNode;
        }
        this.removeRows();
        if (this.tableModel != null && data != null && data.hasChildNodes()) {
            list = data.getChildNodes();
            for (i = 0; i < list.getLength(); ++i) {
                Node item = list.item(i);
                if (item.getNodeType() != 1 || !item.hasAttributes()) continue;
                this.addRow((Element)item);
            }
        }
    }

    public XMLStreamResolver.XMLStreamResolverParam newXMLStreamResolverParam(String path) {
        return new XMLStreamResolver.XMLStreamResolverParam(path, new XMLStreamResolver(){

            @Override
            public void resolveElement(XMLStreamReader r) {
                BGTable.this.addRow(r);
            }
        }){

            @Override
            protected void startDocument() {
                BGTable.this.removeRows();
            }
        };
    }

    public void addRow(Element item) {
        int columnCount = this.columns.size();
        Vector<Object> rowData = new Vector<Object>();
        for (int k = 0; k < columnCount; ++k) {
            BGTableColumn column = this.columns.get(k);
            String id = String.valueOf(column.getId());
            String value = item.getAttribute(id);
            if (value.length() == 0) {
                value = item.getAttribute("f" + id);
            }
            rowData.addElement(column.getValue(value));
        }
        this.tableModel.addRow(rowData);
        if (this.spannedRowModel == this.tableModel && !"".equals(item.getAttribute("colspan"))) {
            this.spannedRowModel.setSpannedRow(this.tableModel.getRowCount() - 1);
        }
    }

    public void addRow(XMLStreamReader r) {
        int columnCount = this.columns.size();
        Vector<Object> rowData = new Vector<Object>();
        for (int k = 0; k < columnCount; ++k) {
            BGTableColumn column = this.columns.get(k);
            String id = String.valueOf(column.getId());
            String value = r.getAttributeValue(null, id);
            if (value == null) {
                value = r.getAttributeValue(null, "f" + id);
            }
            rowData.addElement(column.getValue(value));
        }
        this.tableModel.addRow(rowData);
        if (this.spannedRowModel == this.tableModel && Utils.notEmptyString(r.getAttributeValue(null, "colspan"))) {
            this.spannedRowModel.setSpannedRow(this.tableModel.getRowCount() - 1);
        }
    }

    public void addRow(Map<String, ?> map) {
        int columnCount = this.columns.size();
        Vector<Object> rowData = new Vector<Object>();
        for (int k = 0; k < columnCount; ++k) {
            BGTableColumn column = this.columns.get(k);
            rowData.addElement(column.getValue((String)map.get(column.getId())));
        }
        this.tableModel.addRow(rowData);
        if (this.spannedRowModel == this.tableModel && map.get("colspan") != null) {
            this.spannedRowModel.setSpannedRow(this.tableModel.getRowCount() - 1);
        }
    }

    protected void setNewTableModel() {
        BGTableModel tableModel = new BGTableModel();
        this.tableModel = tableModel;
        this.setModel(tableModel);
        this.spannedRowModel = tableModel;
        this.setUI(new ColspanTableUI(this));
        this.setDefaultRenderer(BGRadio.class, new RadioTableCellRenderer());
        this.setDefaultEditor(BGRadio.class, new RadioTableCellEditor());
        this.setDefaultRenderer(Button.class, new ButtonTableCellRenderer());
        this.setDefaultEditor(Button.class, new ButtonTableCellEditor());
        this.setDefaultRenderer(BGColorCell.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (comp instanceof JLabel) {
                    comp.setBackground(((BGColorCell)value).getColor());
                    ((JLabel)comp).setText(((BGColorCell)value).getText());
                }
                return comp;
            }
        });
    }

    public String getValues(int col_1, int col_2) {
        Object values = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            String id = (String)this.getBGTableModel().getValueAt(i, col_1);
            Boolean b = (Boolean)this.getBGTableModel().getValueAt(i, col_2);
            if (!b.booleanValue()) continue;
            values = (String)values + id + ",";
        }
        return values;
    }

    public String getRadioValue(int col_1, int col_2) {
        String value = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            String id = (String)this.getValueAt(i, col_1);
            BGRadio cellValue = (BGRadio)this.getValueAt(i, col_2);
            if (!cellValue.isSelected()) continue;
            value = id;
            break;
        }
        return value;
    }

    public void setRadioValue(int column, int selectValue) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object obj;
            int id = Utils.parseInt(this.getRowId(i, null), -1);
            if (id < 0 || !((obj = this.getBGTableModel().getValueAt(i, column)) instanceof BGRadio)) continue;
            ((BGRadio)obj).setSelected(id == selectValue);
        }
        this.revalidate();
    }

    public String getColumnValueString(int row, String columnName) {
        return (String)this.getColumnValue(row, columnName);
    }

    public Object getColumnValue(int row, String columnName) {
        Object result = null;
        BGTableColumn column = null;
        int size = this.columns.size();
        for (int i = 0; i < size; ++i) {
            Vector rowData;
            column = this.columns.get(i);
            if (!column.getId().equals(columnName) && !column.getTitle().equals(columnName) && !String.valueOf(i).equals(columnName)) continue;
            Vector<Vector> dataVector = this.tableModel.getDataVector();
            if (row >= dataVector.size() || !((rowData = dataVector.get(row)) instanceof Vector)) break;
            result = rowData.get(i);
            break;
        }
        return result;
    }

    public Map<String, Object> getColumnValueMap(int row) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Vector rowData = this.tableModel.getDataVector().get(row);
        for (int i = 0; i < this.columns.size(); ++i) {
            BGTableColumn column = this.columns.get(i);
            result.put(column.getId(), rowData.get(i));
        }
        return result;
    }

    public int findColumnValue(String columnName, Object columnValue) {
        int colNum = -1;
        for (int i = 0; i < this.columns.size(); ++i) {
            BGTableColumn column = this.columns.get(i);
            if (!column.getId().equals(columnName) && !column.getTitle().equals(columnName) && !String.valueOf(i).equals(columnName)) continue;
            colNum = i;
        }
        for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
            Object obj = this.tableModel.getValueAt(row, colNum);
            if (!obj.equals(columnValue)) continue;
            return row;
        }
        return Integer.MIN_VALUE;
    }

    public void setColumnValue(int row, String columnName, Object value) {
        BGTableColumn column = null;
        int size = this.columns.size();
        for (int i = 0; i < size; ++i) {
            column = this.columns.get(i);
            if (!column.getId().equals(columnName) && !column.getTitle().equals(columnName) && !String.valueOf(i).equals(columnName)) continue;
            this.tableModel.setValueAt(value, row, i);
            break;
        }
    }

    public String getRowId(int row, String columnName) {
        String sValue = null;
        if (columnName != null) {
            sValue = this.getColumnValueString(row, columnName);
        }
        if (sValue == null) {
            sValue = this.getColumnValueString(row, "id");
        }
        if (sValue == null) {
            sValue = this.getColumnValueString(row, "ID");
        }
        if (sValue == null) {
            sValue = this.getColumnValueString(row, "0");
        }
        return sValue;
    }

    public final boolean columnWidthsByTableWidth() {
        Container cont = this.getParent();
        if (cont instanceof JViewport && this.setColumnWidth) {
            int i;
            JViewport viewport = (JViewport)cont;
            int delta = viewport.getWidth();
            if (delta < 0) {
                return false;
            }
            Vector<TableColumn> cols = new Vector<TableColumn>();
            for (i = 0; i < this.getColumnCount(); ++i) {
                TableColumn tableColumn = this.getColumnModel().getColumn(i);
                delta -= tableColumn.getPreferredWidth();
                cols.add(tableColumn);
            }
            while (delta > 1 && cols.size() != 0) {
                i = 0;
                while (i < cols.size()) {
                    int delta1 = delta / (cols.size() - i);
                    TableColumn tableColumn = (TableColumn)cols.elementAt(i);
                    int w = tableColumn.getPreferredWidth();
                    int max = tableColumn.getMaxWidth();
                    int delta2 = max - w;
                    if (delta2 == 0) {
                        cols.removeElementAt(i);
                        continue;
                    }
                    if (delta2 > delta1) {
                        tableColumn.setPreferredWidth(w + delta1);
                        delta -= delta1;
                        ++i;
                        continue;
                    }
                    tableColumn.setPreferredWidth(max);
                    cols.removeElementAt(i);
                    delta -= delta2;
                }
            }
        }
        return true;
    }

    public List<BGTableColumn> getColumns() {
        return this.columns;
    }

    public void columnWidthsByContent() {
        Enumeration<TableColumn> columnList = this.getColumnModel().getColumns();
        while (columnList.hasMoreElements()) {
            TableColumn column = columnList.nextElement();
            TableCellRenderer renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.getTableHeader().getDefaultRenderer();
            }
            int index = this.convertColumnIndexToView(column.getModelIndex());
            Component comp = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, index);
            int width = comp.getPreferredSize().width;
            if (this.getRowCount() > 0) {
                renderer = this.getCellRenderer(0, index);
            }
            for (int r = 0; r < this.getRowCount(); ++r) {
                comp = renderer.getTableCellRendererComponent(this, this.getValueAt(r, index), false, false, r, index);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            if ((width += 4) < 50) {
                width = 50;
            } else if (width > 200) {
                width = 200;
            }
            column.setPreferredWidth(width);
        }
    }

    private void tryInit() {
        if (this.inited == 1) {
            this.init(this.module, 0);
        }
    }

    @Override
    public void init(String _module, int mid) {
        this.module = _module;
        this.inited = 1;
        if (this.columns.size() == 0) {
            return;
        }
        try {
            if (this.inited < 2) {
                Enumeration<TableColumn> columnList;
                BGUserTable userTable;
                this.inited = 2;
                ActionListener listener = e -> {
                    if ("extend".equals(e.getActionCommand())) {
                        this.setColumnWidth = true;
                        this.columnWidthsByTableWidth();
                    } else if ("store".equals(e.getActionCommand())) {
                        this.saveColumnProperties();
                    } else if ("visibility".equals(e.getActionCommand())) {
                        this.configureVisibility();
                    } else if ("reset".equals(e.getActionCommand()) && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                        this.resetColumnProperties();
                    }
                };
                final JPopupMenu menu = new JPopupMenu();
                JMenuItem item = new JMenuItem("<< \u0420\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u044c >>");
                item.setActionCommand("extend");
                item.addActionListener(listener);
                menu.add(item);
                menu.addSeparator();
                item = new JMenuItem("\u0417\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435");
                item.setActionCommand("store");
                item.addActionListener(listener);
                menu.add(item);
                item = new JMenuItem("\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u0441\u0442\u043e\u043b\u0431\u0446\u043e\u0432...");
                item.setActionCommand("visibility");
                item.addActionListener(listener);
                menu.add(item);
                item = new JMenuItem("\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435");
                item.setActionCommand("reset");
                item.addActionListener(listener);
                menu.add(item);
                this.getTableHeader().addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (SwingUtilities.isRightMouseButton(e)) {
                            menu.show(BGTable.this, e.getX(), e.getY());
                        }
                    }
                });
                for (BGPlugInElement extension : BGPluginManagerClient.getManager().getExtensions("bitel.billing.module.common.table.BGTable", true)) {
                    try {
                        Element extensionElement = extension.getElement();
                        String module = XMLUtils.getAttribute(extensionElement, "module", null);
                        String tableid = XMLUtils.getAttribute(extensionElement, "tableid", null);
                        if (module == null || tableid == null || !module.equals(this.getModule()) || !tableid.equals(this.getTableId())) continue;
                        BGPluginClient plugin = (BGPluginClient)extension.getPlugin();
                        Iterator<Integer> popupitemList = extensionElement.getElementsByTagName("popupitem");
                        for (int index1 = 0; index1 < popupitemList.getLength(); ++index1) {
                            Element popupitemElement = (Element)popupitemList.item(index1);
                            String actionCommand = XMLUtils.getAttribute(popupitemElement, "ActionCommand", null);
                            String actionListener = XMLUtils.getAttribute(popupitemElement, "ActionListener", null);
                            String title = XMLUtils.getAttribute(popupitemElement, "title", null);
                            if (actionCommand == null || actionListener == null || title == null) continue;
                            JMenuItem menuItemPlugin = new JMenuItem(plugin.getResourceString(title));
                            menuItemPlugin.setActionCommand(actionCommand);
                            menuItemPlugin.addActionListener((ActionListener)Class.forName(actionListener).newInstance());
                            this.addPopupMenuIfNotExists(this.getPopupMenu(), menuItemPlugin);
                        }
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
                int[] widths = tableWidths.get(this.module + this.tableId);
                int[] positions = tablePositions.get(this.module + this.tableId);
                boolean[] hiddens = tableVisibility.get(this.module + this.tableId);
                if (widths != null && widths.length <= 0) {
                    return;
                }
                if (widths == null && (userTable = clientKernelContext.getWebService(TableService.class).userTableGet(false, this.module, this.tableId)) != null) {
                    List<Integer> _params = Utils.toIntegerList(userTable.getWidths());
                    if (_params.size() > 0) {
                        widths = new int[_params.size()];
                        int i = 0;
                        for (Integer par : _params) {
                            widths[i++] = par;
                        }
                    }
                    if ((_params = Utils.toIntegerList(userTable.getPositions())).size() > 0) {
                        positions = new int[_params.size()];
                        int i = 0;
                        for (Integer par : _params) {
                            positions[i++] = par;
                        }
                    }
                    if ((_params = Utils.toIntegerList(userTable.getHiddens())).size() > 0) {
                        hiddens = new boolean[_params.size()];
                        int i = 0;
                        for (Integer par : _params) {
                            hiddens[i++] = par != 0;
                        }
                    }
                }
                if (widths != null && this.columnModel.getColumnCount() == widths.length) {
                    int i = 0;
                    columnList = this.getColumnModel().getColumns();
                    while (columnList.hasMoreElements() && i < widths.length) {
                        TableColumn column = columnList.nextElement();
                        column.setPreferredWidth(widths[i++]);
                    }
                }
                if (hiddens != null && this.columnModel.getColumnCount() == widths.length) {
                    int i = 0;
                    columnList = this.getColumnModel().getColumns();
                    while (columnList.hasMoreElements() && i < hiddens.length) {
                        TableColumn column = columnList.nextElement();
                        if (!hiddens[i++]) continue;
                        column.setMinWidth(0);
                        column.setPreferredWidth(0);
                        column.setMaxWidth(0);
                    }
                }
                if (positions != null && this.columnModel.getColumnCount() == widths.length) {
                    int i;
                    int[] temp = new int[positions.length];
                    for (int i2 = 0; i2 < positions.length; ++i2) {
                        temp[positions[i2]] = i2;
                    }
                    Vector<Integer> vect = new Vector<Integer>();
                    for (i = 0; i < this.columnModel.getColumnCount(); ++i) {
                        vect.add(temp[i]);
                    }
                    i = 0;
                    while (i < positions.length) {
                        if ((Integer)vect.get(i) > i) {
                            int newPos = (Integer)vect.get(i);
                            this.columnModel.moveColumn(i, newPos);
                            vect.insertElementAt((Integer)vect.remove(i), newPos);
                            continue;
                        }
                        ++i;
                    }
                }
                if (widths == null) {
                    widths = new int[]{};
                }
                tableWidths.put(this.module + this.tableId, widths);
                if (positions == null) {
                    positions = new int[]{};
                }
                tablePositions.put(this.module + this.tableId, positions);
                tableVisibility.put(this.module + this.tableId, hiddens);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void addPopupMenuIfNotExists(JPopupMenu popupMenu, JMenuItem itemPlugin) {
        for (int i = 0; i < popupMenu.getComponentCount(); ++i) {
            if (!(popupMenu.getComponent(i) instanceof JMenuItem) || !((JMenuItem)popupMenu.getComponent(i)).getActionCommand().equals(itemPlugin.getActionCommand())) continue;
            return;
        }
        popupMenu.add(itemPlugin);
    }

    private void saveColumnProperties() {
        ArrayList<Integer> widthList = new ArrayList<Integer>();
        ArrayList<Integer> posList = new ArrayList<Integer>();
        boolean[] hiddens = new boolean[this.columnModel.getColumnCount()];
        int[] _widths = new int[this.columnModel.getColumnCount()];
        int[] _positions = new int[this.columnModel.getColumnCount()];
        int i = 0;
        Enumeration<TableColumn> columnList = this.columnModel.getColumns();
        while (columnList.hasMoreElements()) {
            TableColumn column = columnList.nextElement();
            int pos = column.getModelIndex();
            int width = column.getWidth();
            if (width == 0) {
                width = ((BGTableColumn)column.getIdentifier()).getColumnsWidth()[3];
            }
            widthList.add(width);
            _widths[i] = width;
            posList.add(column.getModelIndex());
            _positions[i] = pos;
            hiddens[pos] = column.getWidth() <= 0;
            ++i;
        }
        String widths = Utils.toString(widthList);
        String positions = Utils.toString(posList);
        StringBuffer vis = new StringBuffer();
        if (hiddens.length > 0) {
            vis.append(hiddens[0] ? "1" : "0");
        }
        for (i = 1; i < hiddens.length; ++i) {
            vis.append(hiddens[i] ? ",1" : ",0");
        }
        try {
            BGUserTable userTable = new BGUserTable().setModule(this.module).setTableId(this.tableId).setWidths(widths).setPositions(positions).setHiddens(vis.toString());
            clientKernelContext.getWebService(TableService.class).userTableSet(false, userTable);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        tableWidths.put(this.module + this.tableId, _widths);
        tablePositions.put(this.module + this.tableId, _positions);
        tableVisibility.put(this.module + this.tableId, hiddens);
    }

    private void resetColumnProperties() {
        try {
            clientKernelContext.getWebService(TableService.class).userTableReset(false, this.module, this.tableId);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        tableWidths.put(this.module + this.tableId, new int[0]);
        tablePositions.remove(this.module + this.tableId);
        tableVisibility.remove(this.module + this.tableId);
        for (int j = 1; j < this.columnModel.getColumnCount(); ++j) {
            Enumeration<TableColumn> columns = this.getColumnModel().getColumns();
            int i = 0;
            while (columns.hasMoreElements()) {
                TableColumn column = columns.nextElement();
                int pos = column.getModelIndex();
                if (pos > i) {
                    this.columnModel.moveColumn(i, pos);
                }
                ++i;
            }
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            BGTableColumn tc = this.columns.get(i);
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            tableColumn.setHeaderValue(tc.getTitle());
            int width = tc.getColumnsWidth()[2];
            if (width > -1) {
                tableColumn.setMaxWidth(width);
            } else {
                tableColumn.setMaxWidth(Integer.MAX_VALUE);
            }
            width = tc.getColumnsWidth()[0];
            if (width > -1) {
                tableColumn.setMinWidth(width);
            } else {
                tableColumn.setMinWidth(15);
            }
            width = tc.getColumnsWidth()[1];
            if (width <= -1) continue;
            tableColumn.setPreferredWidth(width);
        }
        this.setColumnWidth = true;
        this.columnWidthsByTableWidth();
    }

    private void configureVisibility() {
        new BGTableColumnVisibility(this);
    }

    public void setColumnWidths() {
        if (!this.setColumnWidth) {
            this.setColumnWidth = true;
            this.doLayout();
        }
    }

    public int getVisibleRowCount() {
        Container cont;
        if (this.visibleRowCount <= 0 && (cont = this.getParent()) instanceof JViewport) {
            JViewport viewport = (JViewport)cont;
            Dimension viewportSize = viewport.getSize();
            this.visibleRowCount = viewportSize.height / this.rowHeight;
        }
        return this.visibleRowCount;
    }

    public String getModule() {
        return this.module;
    }

    public String getTableId() {
        return this.tableId;
    }

    public Element updateData(Document doc) throws Exception {
        return this.updateData(doc, "//table");
    }

    public Element updateData(Document doc, String tableElementName) throws Exception {
        Element tableElement = XMLUtils.selectElement(doc, tableElementName);
        this.updateData(tableElement);
        return tableElement;
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = this.getComponentPopupMenu();
        if (popupMenu == null) {
            popupMenu = new JPopupMenu();
            this.setComponentPopupMenu(popupMenu);
        }
        return popupMenu;
    }

    protected void initResourceBundle(String resourceBundleName) {
        try {
            this.mainResourceBundle = ResourceBundle.getBundle(resourceBundleName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.userResourceBundle = ResourceBundle.getBundle(resourceBundleName.concat("_user"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void recycleResourceBundle() {
        this.userResourceBundle = null;
        this.mainResourceBundle = null;
    }

    public static interface SpannedRowModel {
        public void setSpannedRow(int var1);

        public boolean isSpannedRow(int var1);

        public boolean isSpannedRowExists();
    }

    public final class BGTableModel
    extends DefaultTableModel
    implements SpannedRowModel {
        private final HashSet<Integer> colspanSet = new HashSet();

        @Override
        public String getColumnName(int column) {
            return BGTable.this.columns != null && column < BGTable.this.columns.size() ? BGTable.this.columns.get(column).getId() : null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            Class<?> _Class = super.getColumnClass(col);
            if (col < BGTable.this.columns.size()) {
                try {
                    String cl = BGTable.this.columns.get(col).getColumnsClass();
                    if (!"".equals(cl)) {
                        _Class = Class.forName(cl);
                    }
                }
                catch (ClassNotFoundException ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
            return _Class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            boolean edit = false;
            if (columnIndex < BGTable.this.columns.size()) {
                edit = BGTable.this.columns.get(columnIndex).isEditable();
            }
            return edit;
        }

        @Override
        public void setSpannedRow(int row) {
            this.colspanSet.add(row);
        }

        @Override
        public boolean isSpannedRow(int row) {
            return this.colspanSet.contains(row);
        }

        @Override
        public boolean isSpannedRowExists() {
            return this.colspanSet.size() > 0;
        }

        @Override
        public void removeRow(int row) {
            super.removeRow(row);
            this.colspanSet.remove(row);
            for (Integer i : new HashSet<Integer>(this.colspanSet)) {
                if (i <= row) continue;
                this.colspanSet.remove(i);
                this.colspanSet.add(i - 1);
            }
        }

        @Override
        public void moveRow(int start, int end, int to) {
            super.moveRow(start, end, to);
            for (int i = start; i <= end; ++i) {
                this.colspanSet.remove(i);
                this.colspanSet.add(i + to);
            }
        }

        public void removeRows() {
            int lastRow = this.getRowCount() - 1;
            if (lastRow >= 0) {
                this.dataVector = new Vector();
                this.colspanSet.clear();
                this.fireTableRowsDeleted(0, lastRow);
            }
        }
    }
}

